/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.http.body;

import androidx.annotation.NonNull;
import com.blankj.utilcode.util.LogUtils;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import x.aichen.http.callback.UCallback;

public class UploadProgressRequestBody
extends RequestBody {
    private RequestBody requestBody;
    private UCallback callback;
    private long lastTime;

    public UploadProgressRequestBody(RequestBody requestBody, UCallback callback) {
        this.requestBody = requestBody;
        this.callback = callback;
        if (requestBody == null || callback == null) {
            throw new NullPointerException("this requestBody and callback must not null.");
        }
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() {
        try {
            return this.requestBody.contentLength();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)countingSink);
        this.requestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private final class CountingSink
    extends ForwardingSink {
        private long currentLength;
        private long totalLength;

        public CountingSink(Sink sink) {
            super(sink);
            this.currentLength = 0L;
            this.totalLength = 0L;
        }

        public void write(@NonNull Buffer source, long byteCount) throws IOException {
            long currentTime;
            super.write(source, byteCount);
            this.currentLength += byteCount;
            if (this.totalLength == 0L) {
                this.totalLength = UploadProgressRequestBody.this.contentLength();
            }
            if ((currentTime = System.currentTimeMillis()) - UploadProgressRequestBody.this.lastTime >= 100L || UploadProgressRequestBody.this.lastTime == 0L || this.currentLength == this.totalLength) {
                UploadProgressRequestBody.this.lastTime = currentTime;
                Observable.just((Object)this.currentLength).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                    public void accept(Long aLong) throws Exception {
                        LogUtils.i((Object[])new Object[]{"upload progress currentLength:" + CountingSink.this.currentLength + ",totalLength:" + CountingSink.this.totalLength});
                        UploadProgressRequestBody.this.callback.onProgress(CountingSink.this.currentLength, CountingSink.this.totalLength, 100.0f * (float)CountingSink.this.currentLength / (float)CountingSink.this.totalLength);
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) throws Exception {
                        UploadProgressRequestBody.this.callback.onFail(-1, throwable.getMessage());
                    }
                });
            }
        }
    }
}

