/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.util;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.LogUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lx/aichen/util/Util;", "", "()V", "CreateCacheFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "childrenName", "", "formatMoney", "s", "len", "", "getRealFilePath", "uri", "Landroid/net/Uri;", "util_release"})
public final class Util {
    public static final Util INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatMoney(@Nullable String s, int len) {
        String result;
        NumberFormat numberFormat;
        CharSequence charSequence;
        if (s == null || (charSequence = (CharSequence)s).length() == 0) {
            return "";
        }
        StringBuffer zero = new StringBuffer();
        double num = Double.parseDouble(s);
        if (len == 0) {
            numberFormat = new DecimalFormat("######");
        } else {
            StringBuffer buff = new StringBuffer();
            buff.append("######.");
            int n = 0;
            int n2 = len;
            while (n < n2) {
                void i;
                buff.append("#");
                zero.append("0");
                ++i;
            }
            numberFormat = new DecimalFormat(buff.toString());
        }
        NumberFormat formater = numberFormat;
        String string = result = formater.format(num);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result");
        if (StringsKt.indexOf$default((CharSequence)string, (String)".", (int)0, (boolean)false, (int)6, null) == -1) {
            result = "" + result + "." + zero.toString();
        }
        return result.toString();
    }

    @Nullable
    public final String getRealFilePath(@NotNull Context context, @NotNull Uri uri) {
        Cursor cursor;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if (Intrinsics.areEqual((Object)"file", (Object)scheme)) {
            data = uri.getPath();
        } else if (Intrinsics.areEqual((Object)"content", (Object)scheme) && (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null)) != null) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    @Nullable
    public final File CreateCacheFile(@NotNull Context context, @NotNull String childrenName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)childrenName, (String)"childrenName");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        File cache = context2.getExternalCacheDir();
        if (cache == null) {
            File file = Environment.getExternalStorageDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
            String sdCard = file.getAbsolutePath();
            String cacheString = sdCard + "/Android/data/" + AppUtils.getAppPackageName() + "/cache";
            LogUtils.e((Object[])new Object[]{cacheString});
            cache = new File(cacheString);
            if (!cache.exists()) {
                cache.mkdir();
            }
        }
        if (cache.exists()) {
            File appBaseDir = new File(cache, childrenName);
            if (!appBaseDir.exists()) {
                appBaseDir.mkdir();
            }
            return appBaseDir;
        }
        return null;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

