/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.sonic;

import android.content.Context;
import com.just.agentweb.AgentWeb;
import com.just.agentweb.MiddlewareWebClientBase;
import com.tencent.sonic.sdk.SonicConfig;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicRuntime;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionClient;
import com.tencent.sonic.sdk.SonicSessionConfig;
import x.aichen.sonic.DefaultSonicRuntimeImpl;
import x.aichen.sonic.SonicSessionClientImpl;
import x.aichen.sonic.SonicWebViewClient;

public class SonicImpl {
    private SonicSession sonicSession;
    private Context mContext;
    private String url;
    private SonicSessionClientImpl sonicSessionClient;

    public SonicImpl(String url, Context context) {
        this.url = url;
        this.mContext = context;
    }

    public void onCreateSession() {
        SonicSessionConfig.Builder sessionConfigBuilder = new SonicSessionConfig.Builder();
        sessionConfigBuilder.setSupportLocalServer(true);
        SonicEngine.createInstance((SonicRuntime)new DefaultSonicRuntimeImpl(this.mContext.getApplicationContext()), (SonicConfig)new SonicConfig.Builder().build());
        this.sonicSession = SonicEngine.getInstance().createSession(this.url, sessionConfigBuilder.build());
        if (null != this.sonicSession) {
            this.sonicSessionClient = new SonicSessionClientImpl();
            this.sonicSession.bindClient((SonicSessionClient)this.sonicSessionClient);
        }
    }

    public SonicSessionClientImpl getSonicSessionClient() {
        return this.sonicSessionClient;
    }

    public MiddlewareWebClientBase createSonicClientMiddleWare() {
        return new SonicWebViewClient(this.sonicSession);
    }

    public void bindAgentWeb(AgentWeb agentWeb) {
        if (this.sonicSessionClient != null) {
            this.sonicSessionClient.bindWebView(agentWeb);
            this.sonicSessionClient.clientReady();
        } else {
            agentWeb.getUrlLoader().loadUrl(this.url);
        }
    }

    public void destrory() {
        if (this.sonicSession != null) {
            this.sonicSession.destroy();
        }
    }
}

