/*
 * Decompiled with CFR 0.152.
 */
package com.anarchy.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.anarchy.library.R;

public class DoubleSeekBar
extends View {
    private static final float THUMB_SHADOW = 3.5f;
    private static final float Y_OFFSET = 1.75f;
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final float HIT_SCOPE_RATIO = 1.2f;
    private int mThumbRadius;
    private int mThumbColor;
    private int mProgressColor;
    private int mProgressBackgroundColor;
    private int mProgressWidth;
    private int mTextColor;
    private int mTextSize;
    private Point mStartPoint = new Point();
    private float mFirstThumbRatio = 0.0f;
    private float mSecondThumbRatio = 1.0f;
    private RectF mFirstThumb = new RectF();
    private RectF mSecondThumb = new RectF();
    private int mProgressLength;
    private int mThumbShadowRadius;
    private int mYOffset;
    private String mFirstPrompt;
    private String mSecondPrompt;
    private Paint mProgressPaint = new Paint();
    private Paint mThumbPaint = new Paint(1);
    private Paint mTextPaint = new Paint(1);
    private onSeekBarChangeListener mOnSeekBarChangeListener;
    private static final int INVALID_POINTER = -1;
    private SelectInfo firstInfo = new SelectInfo();
    private SelectInfo secondInfo = new SelectInfo();

    public DoubleSeekBar(Context context) {
        this(context, null, 0);
    }

    public DoubleSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DoubleSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DoubleSeekBar, defStyleAttr, R.style.DoubleSeekBar);
        this.mThumbRadius = a.getDimensionPixelSize(R.styleable.DoubleSeekBar_DB_ThumbRadius, 0);
        this.mThumbColor = a.getColor(R.styleable.DoubleSeekBar_DB_ThumbColor, 0);
        this.mTextColor = a.getColor(R.styleable.DoubleSeekBar_DB_TextColor, 0);
        this.mProgressColor = a.getColor(R.styleable.DoubleSeekBar_DB_ProgressColor, 0);
        this.mProgressBackgroundColor = a.getColor(R.styleable.DoubleSeekBar_DB_ProgressBackgroundColor, 0);
        this.mTextSize = a.getDimensionPixelSize(R.styleable.DoubleSeekBar_DB_TextSize, 0);
        this.mProgressWidth = a.getDimensionPixelOffset(R.styleable.DoubleSeekBar_DB_ProgressWidth, 0);
        a.recycle();
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setColor(this.mTextColor);
        this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeWidth((float)this.mProgressWidth);
        this.mThumbShadowRadius = (int)(this.getResources().getDisplayMetrics().density * 3.5f);
        this.mYOffset = (int)(this.getResources().getDisplayMetrics().density * 1.75f);
        ViewCompat.setLayerType((View)this, (int)1, (Paint)this.mThumbPaint);
        this.mThumbPaint.setShadowLayer((float)this.mThumbShadowRadius, 0.0f, (float)this.mYOffset, 0x1E000000);
        this.mThumbPaint.setColor(this.mThumbColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        int suggestHeight = (int)((float)(3 * this.mThumbRadius + this.mThumbShadowRadius) - fontMetrics.top + fontMetrics.bottom + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        this.setMeasuredDimension(DoubleSeekBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), DoubleSeekBar.resolveSizeAndState((int)suggestHeight, (int)heightMeasureSpec, (int)0));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mStartPoint.set(this.getPaddingLeft() + this.mThumbRadius, h - this.getPaddingBottom() - this.mThumbRadius - this.mThumbShadowRadius);
        this.mProgressLength = w - this.getPaddingLeft() - this.getPaddingRight() - 2 * this.mThumbRadius;
        this.mFirstThumb.set((float)this.mStartPoint.x + (float)this.mProgressLength * this.mFirstThumbRatio - 1.2f * (float)this.mThumbRadius, (float)this.mStartPoint.y - 1.2f * (float)this.mThumbRadius, (float)this.mStartPoint.x + (float)this.mProgressLength * this.mFirstThumbRatio + 1.2f * (float)this.mThumbRadius, (float)this.mStartPoint.y + 1.2f * (float)this.mThumbRadius);
        this.mSecondThumb.set((float)this.mStartPoint.x + (float)this.mProgressLength * this.mSecondThumbRatio - 1.2f * (float)this.mThumbRadius, (float)this.mStartPoint.y - 1.2f * (float)this.mThumbRadius, (float)this.mStartPoint.x + (float)this.mProgressLength * this.mSecondThumbRatio + 1.2f * (float)this.mThumbRadius, (float)this.mStartPoint.y + 1.2f * (float)this.mThumbRadius);
    }

    protected void onDraw(Canvas canvas) {
        int y = this.mStartPoint.y;
        int firstX = this.mStartPoint.x;
        int secondX = (int)this.mFirstThumb.centerX();
        int thirdX = (int)this.mSecondThumb.centerX();
        this.mProgressPaint.setColor(this.mProgressBackgroundColor);
        canvas.drawLine((float)firstX, (float)y, (float)secondX, (float)y, this.mProgressPaint);
        this.mProgressPaint.setColor(this.mProgressColor);
        canvas.drawLine((float)secondX, (float)y, (float)thirdX, (float)y, this.mProgressPaint);
        this.mProgressPaint.setColor(this.mProgressBackgroundColor);
        canvas.drawLine((float)thirdX, (float)y, (float)(firstX + this.mProgressLength), (float)y, this.mProgressPaint);
        canvas.drawCircle((float)secondX, (float)y, (float)this.mThumbRadius, this.mThumbPaint);
        canvas.drawCircle((float)thirdX, (float)y, (float)this.mThumbRadius, this.mThumbPaint);
        this.mFirstPrompt = this.ratio2DateString(this.mFirstThumbRatio);
        this.mSecondPrompt = this.ratio2DateString(this.mSecondThumbRatio);
        if ((double)this.mFirstThumbRatio < 0.1) {
            this.mTextPaint.setTextAlign(Paint.Align.LEFT);
            canvas.drawText(this.mFirstPrompt, this.mFirstThumb.left, this.mFirstThumb.top - (float)this.mThumbRadius, this.mTextPaint);
        } else if (this.mSecondThumbRatio - this.mFirstThumbRatio < 0.2f) {
            this.mTextPaint.setTextAlign(Paint.Align.RIGHT);
            canvas.drawText(this.mFirstPrompt, this.mFirstThumb.right, this.mFirstThumb.top - (float)this.mThumbRadius, this.mTextPaint);
        } else {
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(this.mFirstPrompt, this.mFirstThumb.centerX(), this.mFirstThumb.top - (float)this.mThumbRadius, this.mTextPaint);
        }
        if ((double)this.mSecondThumbRatio > 0.9) {
            this.mTextPaint.setTextAlign(Paint.Align.RIGHT);
            canvas.drawText(this.mSecondPrompt, this.mSecondThumb.right, this.mSecondThumb.top - (float)this.mThumbRadius, this.mTextPaint);
        } else if (this.mSecondThumbRatio - this.mFirstThumbRatio < 0.2f) {
            this.mTextPaint.setTextAlign(Paint.Align.LEFT);
            canvas.drawText(this.mSecondPrompt, this.mSecondThumb.left, this.mSecondThumb.top - (float)this.mThumbRadius, this.mTextPaint);
        } else {
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(this.mSecondPrompt, this.mSecondThumb.centerX(), this.mSecondThumb.top - (float)this.mThumbRadius, this.mTextPaint);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.fistThumbRatio = this.mFirstThumbRatio;
        ss.secondThumbRatio = this.mSecondThumbRatio;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mFirstThumbRatio = ((SavedState)state).fistThumbRatio;
            this.mSecondThumbRatio = ((SavedState)state).secondThumbRatio;
            super.onRestoreInstanceState(((SavedState)state).getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        float x = event.getX();
        float y = event.getY();
        switch (action) {
            case 0: {
                int firstPointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                if (this.mFirstThumb.contains(x, y)) {
                    this.firstInfo.pointerId = firstPointerId;
                    this.firstInfo.isCaptured = true;
                }
                if (!this.mSecondThumb.contains(x, y)) break;
                this.secondInfo.pointerId = firstPointerId;
                this.secondInfo.isCaptured = true;
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)event);
                float otherX = MotionEventCompat.getX((MotionEvent)event, (int)index);
                float otherY = MotionEventCompat.getY((MotionEvent)event, (int)index);
                if (this.mFirstThumb.contains(otherX, otherY)) {
                    this.firstInfo.isCaptured = true;
                    this.firstInfo.pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)index);
                }
                if (!this.mSecondThumb.contains(otherX, otherY)) break;
                this.secondInfo.isCaptured = true;
                this.secondInfo.pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)index);
                break;
            }
            case 2: {
                float secondX;
                int i;
                float firstX;
                if (this.firstInfo.isCaptured && this.moveFirstThumb(firstX = MotionEventCompat.getX((MotionEvent)event, (int)(i = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)this.firstInfo.pointerId))))) {
                    return false;
                }
                if (!this.secondInfo.isCaptured || !this.moveSecondThumb(secondX = MotionEventCompat.getX((MotionEvent)event, (int)(i = MotionEventCompat.findPointerIndex((MotionEvent)event, (int)this.secondInfo.pointerId))))) break;
                return false;
            }
            case 6: {
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)MotionEventCompat.getActionIndex((MotionEvent)event));
                if (this.firstInfo.pointerId == pointerId) {
                    this.firstInfo.invalid();
                }
                if (this.secondInfo.pointerId != pointerId) break;
                this.secondInfo.invalid();
                break;
            }
            case 1: 
            case 3: {
                this.firstInfo.invalid();
                this.secondInfo.invalid();
            }
        }
        if (this.firstInfo.isCaptured || this.secondInfo.isCaptured) {
            if (this.mOnSeekBarChangeListener != null) {
                this.mOnSeekBarChangeListener.onProgressChanged(this, this.mFirstThumbRatio, this.mSecondThumbRatio);
            }
            this.invalidate();
        }
        return this.firstInfo.isCaptured || this.secondInfo.isCaptured;
    }

    private boolean moveSecondThumb(float x) {
        if (x > this.mFirstThumb.right + (float)this.mThumbRadius) {
            this.mSecondThumbRatio = (x - (float)this.mStartPoint.x) / (float)this.mProgressLength;
            if (this.mSecondThumbRatio > 1.0f) {
                this.mSecondThumbRatio = 1.0f;
                return true;
            }
            float offsetX = x - this.mSecondThumb.centerX();
            this.mSecondThumb.offset(offsetX, 0.0f);
        }
        return false;
    }

    private boolean moveFirstThumb(float x) {
        if (x < this.mSecondThumb.left - (float)this.mThumbRadius) {
            this.mFirstThumbRatio = (x - (float)this.mStartPoint.x) / (float)this.mProgressLength;
            if (this.mFirstThumbRatio < 0.0f) {
                this.mFirstThumbRatio = 0.0f;
                return true;
            }
            float offsetX = x - this.mFirstThumb.centerX();
            this.mFirstThumb.offset(offsetX, 0.0f);
        }
        return false;
    }

    protected String ratio2DateString(float ratio) {
        StringBuilder builder = new StringBuilder();
        int currentMinute = (int)(1440.0f * ratio);
        String hour = String.valueOf(currentMinute / 60);
        if (hour.length() == 1) {
            builder.append("0").append(hour);
        } else {
            builder.append(hour);
        }
        builder.append(":");
        String minute = String.valueOf(currentMinute % 60);
        if (minute.length() == 1) {
            builder.append("0").append(minute);
        } else {
            builder.append(minute);
        }
        return builder.toString();
    }

    public void setOnSeekBarChangeListener(onSeekBarChangeListener onSeekBarChangeListener2) {
        this.mOnSeekBarChangeListener = onSeekBarChangeListener2;
    }

    public void setFirstThumbRatio(float ratio) {
        this.mFirstThumbRatio = ratio;
        this.invalidate();
    }

    public void setSecondThumbRatio(float ratio) {
        this.mSecondThumbRatio = ratio;
        this.invalidate();
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        float fistThumbRatio;
        float secondThumbRatio;

        public SavedState(Parcel source) {
            super(source);
            this.fistThumbRatio = source.readFloat();
            this.secondThumbRatio = source.readFloat();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.fistThumbRatio);
            out.writeFloat(this.secondThumbRatio);
        }
    }

    public static interface onSeekBarChangeListener {
        public void onProgressChanged(DoubleSeekBar var1, float var2, float var3);
    }

    static class SelectInfo {
        int pointerId = -1;
        boolean isCaptured = false;

        SelectInfo() {
        }

        void invalid() {
            this.pointerId = -1;
            this.isCaptured = false;
        }
    }
}

