/*
 * Decompiled with CFR 0.152.
 */
package wu.seal.textwithimagedrawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;

public class BaseCombinedDrawable
extends Drawable {
    private Drawable one;
    private Drawable two;
    private int relatedX;
    private int relatedY;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;

    public BaseCombinedDrawable(Drawable one, Drawable two) {
        this.one = one;
        this.two = two;
        if (one == null || two == null) {
            throw new IllegalArgumentException("drawable one or two can't be null!");
        }
    }

    public void setRelatedPosition(int relatedX, int relatedY) {
        this.relatedX = relatedX;
        this.relatedY = relatedY;
    }

    public void setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
    }

    public void draw(Canvas canvas) {
        this.one.setBounds(0, 0, this.one.getIntrinsicWidth(), this.one.getIntrinsicHeight());
        this.two.setBounds(0, 0, this.two.getIntrinsicWidth(), this.two.getIntrinsicHeight());
        canvas.translate((float)this.paddingLeft, (float)this.paddingTop);
        canvas.save();
        canvas.translate(this.relatedX < 0 ? (float)Math.abs(this.relatedX) : 0.0f, this.relatedY < 0 ? (float)Math.abs(this.relatedY) : 0.0f);
        this.one.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.translate(this.relatedX > 0 ? (float)Math.abs(this.relatedX) : 0.0f, this.relatedY > 0 ? (float)Math.abs(this.relatedY) : 0.0f);
        this.two.draw(canvas);
        canvas.restore();
    }

    public int getIntrinsicWidth() {
        int del;
        int width = this.paddingLeft + this.paddingRight;
        width += this.one.getIntrinsicWidth();
        width = this.relatedX < 0 ? (width += Math.abs(this.relatedX)) : (width += (del = this.relatedX + this.two.getIntrinsicWidth() - this.one.getIntrinsicWidth()) > 0 ? del : 0);
        return width;
    }

    public int getIntrinsicHeight() {
        int del;
        int height = this.paddingTop + this.paddingBottom;
        height += this.one.getIntrinsicHeight();
        height = this.relatedY < 0 ? (height += Math.abs(this.relatedY)) : (height += (del = this.relatedY + this.two.getIntrinsicHeight() - this.one.getIntrinsicHeight()) > 0 ? del : 0);
        return height;
    }

    public void setAlpha(int alpha) {
        this.one.setAlpha(alpha);
        this.two.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.one.setColorFilter(colorFilter);
        this.two.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.one.getOpacity();
    }
}

