/*
 * Decompiled with CFR 0.152.
 */
package wu.seal.textwithimagedrawable;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class TextWithImageDrawable
extends Drawable {
    private int imageRes;
    private Bitmap bitmap;
    private String mText;
    private String originText;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private int drawablePadding;
    private int alpha;
    private Resources mResources;
    private Position position = Position.LEFT;
    private TextPaint mTextPaint;
    private float mTextSize = 14.0f;
    private int mTextHeight;
    private int textTopDelBaseLine;
    private int maxTextLength = Integer.MAX_VALUE;
    private static final String SUFFIX = "\u2026";
    private EllipsizeModel ellipsizeModel = EllipsizeModel.END;

    public TextWithImageDrawable(Context context) {
        this.mResources = context.getResources();
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setFlags(1);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.mTextPaint.density = this.mResources.getDisplayMetrics().density;
        this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)this.mTextSize, (DisplayMetrics)this.mResources.getDisplayMetrics()));
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        this.mTextHeight = Math.round(fontMetrics.descent - fontMetrics.ascent);
        this.textTopDelBaseLine = Math.round(-fontMetrics.ascent - fontMetrics.leading);
    }

    public void setText(String mText) {
        this.originText = mText;
        if (this.maxTextLength != Integer.MAX_VALUE && this.maxTextLength < mText.length()) {
            if (this.ellipsizeModel == EllipsizeModel.END) {
                this.mText = mText.substring(0, this.maxTextLength) + SUFFIX;
            } else if (this.ellipsizeModel == EllipsizeModel.PRE) {
                this.mText = SUFFIX + mText.substring(mText.length() - 3, mText.length());
            } else if (this.ellipsizeModel == EllipsizeModel.MID) {
                int firstStringLength = this.maxTextLength / 2;
                this.mText = mText.substring(0, firstStringLength) + SUFFIX + mText.substring(mText.length() - (this.maxTextLength - firstStringLength), mText.length());
            }
        } else {
            this.mText = mText;
        }
        this.invalidateSelf();
    }

    public void setImageRes(int imageRes) {
        this.imageRes = imageRes;
        this.invalidateSelf();
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
        this.invalidateSelf();
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
        this.invalidateSelf();
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
        this.invalidateSelf();
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
        this.invalidateSelf();
    }

    public void setImagePadding(int drawablePadding) {
        this.drawablePadding = drawablePadding;
        this.invalidateSelf();
    }

    public void setEllipsizeModel(EllipsizeModel ellipsizeModel) {
        this.ellipsizeModel = ellipsizeModel;
        if (this.originText != null) {
            this.setText(this.originText);
        }
    }

    public void draw(Canvas canvas) {
        canvas.clipRect(this.paddingLeft, this.paddingTop, canvas.getWidth() - this.paddingRight, canvas.getHeight() - this.paddingBottom);
        int contentHeight = this.getIntrinsicHeight() - this.paddingTop - this.paddingBottom;
        int contentWidth = this.getIntrinsicWidth() - this.paddingLeft - this.paddingRight;
        this.bitmap = this.imageRes != 0 ? BitmapFactory.decodeResource((Resources)this.mResources, (int)this.imageRes) : null;
        if (this.position == Position.LEFT) {
            if (this.bitmap != null) {
                int bitmapTop = (contentHeight - this.bitmap.getHeight()) / 2 + this.paddingTop;
                int bitmapLeft = this.paddingLeft;
                canvas.drawBitmap(this.bitmap, (float)bitmapLeft, (float)bitmapTop, null);
                if (this.isNotEmpty(this.mText)) {
                    int left = this.paddingLeft + this.bitmap.getWidth() + this.drawablePadding;
                    int top = (contentHeight - this.mTextHeight) / 2 + this.textTopDelBaseLine + this.paddingTop;
                    canvas.drawText(this.mText, (float)left, (float)top, (Paint)this.mTextPaint);
                }
            } else if (this.isNotEmpty(this.mText)) {
                int left = this.paddingLeft + this.drawablePadding;
                int top = (contentHeight - this.mTextHeight) / 2 + this.textTopDelBaseLine + this.paddingTop;
                canvas.drawText(this.mText, (float)left, (float)top, (Paint)this.mTextPaint);
            }
        } else if (this.position == Position.RIGHT) {
            if (this.isNotEmpty(this.mText)) {
                int textLeft = this.paddingLeft;
                int textTop = (contentHeight - this.mTextHeight) / 2 + this.textTopDelBaseLine + this.paddingTop;
                canvas.drawText(this.mText, (float)textLeft, (float)textTop, (Paint)this.mTextPaint);
            }
            if (this.bitmap != null) {
                int textWidth = Math.round(this.mTextPaint.measureText(this.mText));
                int left = this.paddingLeft + textWidth + this.drawablePadding;
                int top = (contentHeight - this.bitmap.getHeight()) / 2 + this.paddingTop;
                canvas.drawBitmap(this.bitmap, (float)left, (float)top, null);
            }
        } else if (this.position == Position.TOP) {
            if (this.bitmap != null) {
                int bitmapLeft = (contentWidth - this.bitmap.getWidth()) / 2 + this.paddingLeft;
                int bitmapTop = this.paddingTop;
                canvas.drawBitmap(this.bitmap, (float)bitmapLeft, (float)bitmapTop, null);
                if (this.isNotEmpty(this.mText)) {
                    int left = Math.round((float)contentWidth - this.mTextPaint.measureText(this.mText)) / 2 + this.paddingLeft;
                    int top = this.paddingTop + this.bitmap.getHeight() + this.drawablePadding + this.textTopDelBaseLine;
                    canvas.drawText(this.mText, (float)left, (float)top, (Paint)this.mTextPaint);
                }
            } else if (this.isNotEmpty(this.mText)) {
                int left = Math.round((float)contentWidth - this.mTextPaint.measureText(this.mText)) / 2 + this.paddingLeft;
                int top = this.paddingTop + this.drawablePadding + this.textTopDelBaseLine;
                canvas.drawText(this.mText, (float)left, (float)top, (Paint)this.mTextPaint);
            }
        } else if (this.position == Position.BOTTOM) {
            if (this.isNotEmpty(this.mText)) {
                int textLeft = Math.round((float)this.paddingLeft + ((float)contentWidth - this.mTextPaint.measureText(this.mText)) / 2.0f);
                int textTop = this.paddingTop + this.textTopDelBaseLine;
                canvas.drawText(this.mText, (float)textLeft, (float)textTop, (Paint)this.mTextPaint);
                if (this.bitmap != null) {
                    int bitmapLeft = Math.round(this.paddingLeft + (contentWidth - this.bitmap.getWidth()) / 2);
                    int bitmapTop = this.paddingTop + this.mTextHeight + this.drawablePadding;
                    canvas.drawBitmap(this.bitmap, (float)bitmapLeft, (float)bitmapTop, null);
                }
            } else if (this.bitmap != null) {
                int bitmapLeft = Math.round(this.paddingLeft + (contentWidth - this.bitmap.getWidth()) / 2);
                int bitmapTop = this.paddingTop + this.mTextHeight + this.drawablePadding;
                canvas.drawBitmap(this.bitmap, (float)bitmapLeft, (float)bitmapTop, null);
            }
        }
    }

    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
        if (this.originText != null) {
            this.setText(this.originText);
        } else {
            this.invalidateSelf();
        }
    }

    public int getIntrinsicHeight() {
        int bitmapHeight = 0;
        if (this.bitmap == null && this.imageRes != 0) {
            this.bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)this.imageRes);
        }
        if (this.bitmap != null) {
            bitmapHeight = this.bitmap.getHeight();
        }
        if (this.position == Position.LEFT || this.position == Position.RIGHT) {
            return Math.max(bitmapHeight, this.mTextHeight) + this.paddingTop + this.paddingBottom;
        }
        if (this.position == Position.TOP || this.position == Position.BOTTOM) {
            return bitmapHeight + this.mTextHeight + this.paddingTop + this.drawablePadding + this.paddingBottom;
        }
        throw new IllegalArgumentException("position not known as one of the [ LEFT,TOP,RIGHT,BOTTOM ]!");
    }

    public int getIntrinsicWidth() {
        int bitmapWidth = 0;
        int textWidth = 0;
        if (this.bitmap == null && this.imageRes != 0) {
            this.bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)this.imageRes);
        }
        if (this.bitmap != null) {
            bitmapWidth = this.bitmap.getWidth();
        }
        if (this.isNotEmpty(this.mText)) {
            textWidth = Math.round(this.mTextPaint.measureText(this.mText));
        }
        if (this.position == Position.LEFT || this.position == Position.RIGHT) {
            return bitmapWidth + textWidth + this.paddingLeft + this.paddingRight + this.drawablePadding;
        }
        if (this.position == Position.TOP || this.position == Position.BOTTOM) {
            return Math.max(bitmapWidth, textWidth) + this.paddingLeft + this.paddingRight;
        }
        throw new IllegalArgumentException("position not known as one of the [ LEFT,TOP,RIGHT,BOTTOM ]!");
    }

    public void setAlpha(int alpha) {
        if (this.mTextPaint.getAlpha() != alpha) {
            this.mTextPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public int getOpacity() {
        return this.mTextPaint.getAlpha();
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mTextPaint.getColorFilter() != cf) {
            this.mTextPaint.setColorFilter(cf);
            this.invalidateSelf();
        }
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)this.mTextSize, (DisplayMetrics)this.mResources.getDisplayMetrics()));
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        this.mTextHeight = Math.round(fontMetrics.descent - fontMetrics.ascent);
        this.invalidateSelf();
    }

    public void setTextColor(int color) {
        this.mTextPaint.setColor(color);
    }

    public void setImagePosition(Position position) {
        this.position = position;
    }

    private boolean isNotEmpty(String mText) {
        return mText != null && !mText.equals("");
    }

    public static enum EllipsizeModel {
        PRE,
        MID,
        END;

    }

    public static enum Position {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }
}

