/*
 * Decompiled with CFR 0.152.
 */
package wu.poker.library.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.TextView;
import wu.poker.library.R;

public class RippleSelectView
extends TextView {
    public static final int MODE_INNER = 0;
    public static final int MODE_OUT = 1;
    private Drawable bgNormal;
    private Drawable bgSelect;
    private Rect bounds;
    private int duration;
    private int mode;
    private float downX;
    private float downY;
    private float centerX;
    private float centerY;
    private float rippleX;
    private float rippleY;
    private int maxRippleRadius;
    private int rippleRadius;
    private boolean isAnimator;
    private boolean isSelect;
    private Paint paint;
    private RippleAnimatorListener listener;
    private int rippleColor = -15417048;

    public RippleSelectView(Context context) {
        super(context);
        this.init();
    }

    public RippleSelectView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getDrawable(attrs);
        this.init();
    }

    public RippleSelectView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getDrawable(attrs);
        this.init();
    }

    private void getDrawable(AttributeSet attrs) {
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.RippleSelectView);
        this.bgNormal = array.getDrawable(R.styleable.RippleSelectView_ripple_bg_normal);
        this.bgSelect = array.getDrawable(R.styleable.RippleSelectView_ripple_bg_select);
        this.duration = array.getInt(R.styleable.RippleSelectView_ripple_duration, 500);
        this.mode = array.getInt(R.styleable.RippleSelectView_ripple_mode, 0);
        this.rippleColor = array.getColor(R.styleable.RippleSelectView_ripple_color, this.rippleColor);
        array.recycle();
    }

    private void init() {
        if (this.bgNormal == null) {
            this.bgNormal = Build.VERSION.SDK_INT >= 21 ? this.getContext().getDrawable(R.drawable.drawable_normal) : this.getContext().getResources().getDrawable(R.drawable.drawable_normal);
        }
        if (this.bgSelect == null) {
            this.bgSelect = Build.VERSION.SDK_INT >= 21 ? this.getContext().getDrawable(R.drawable.drawable_select) : this.getContext().getResources().getDrawable(R.drawable.drawable_select);
        }
        this.paint = new Paint(1);
        this.paint.setColor(this.rippleColor);
    }

    protected void onDraw(Canvas canvas) {
        if (this.isAnimator) {
            canvas.drawCircle(this.rippleX, this.rippleY, (float)this.rippleRadius, this.paint);
        }
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isAnimator) {
            return super.onTouchEvent(event);
        }
        if (event.getAction() == 0) {
            this.downX = event.getX();
            this.downY = event.getY();
        }
        return super.onTouchEvent(event);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.bounds = new Rect(0, 0, w, h);
        this.centerX = w / 2;
        this.centerY = h / 2;
        this.bgNormal.setBounds(this.bounds);
        this.maxRippleRadius = this.mode == 0 ? Math.max(w / 2, h / 2) : (int)Math.sqrt(w / 2 * w / 2 + h / 2 * h / 2);
    }

    public boolean isSelect() {
        return this.isSelect;
    }

    public void setSelect(boolean select) {
        if (this.isAnimator) {
            return;
        }
        this.isSelect = select;
        if (select) {
            this.animateToSelect();
        } else {
            this.animateToNormal();
        }
    }

    private void animateToNormal() {
        this.rippleAnimator(this.maxRippleRadius, this.maxRippleRadius / 5, this.centerX, this.downX, this.centerY, this.downY, this.duration);
    }

    private void animateToSelect() {
        this.rippleAnimator(this.maxRippleRadius / 5, this.maxRippleRadius, this.downX, this.centerX, this.downY, this.centerY, this.duration);
    }

    private void rippleAnimator(int rFrom, int rTo, float xFrom, float xTo, float yFrom, float yTo, int duration) {
        if (!this.isSelect) {
            duration = (int)(0.75f * (float)duration);
        }
        RippleAnimation animation = new RippleAnimation(rFrom, rTo, xFrom, xTo, yFrom, yTo, duration);
        animation.setRadiusUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                RippleSelectView.this.rippleRadius = (Integer)valueAnimator.getAnimatedValue();
                float alpha = (float)RippleSelectView.this.rippleRadius * 1.0f / (float)RippleSelectView.this.maxRippleRadius * 255.0f;
                RippleSelectView.this.paint.setAlpha((int)alpha);
                if (!RippleSelectView.this.isSelect) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        RippleSelectView.this.setBackground(RippleSelectView.this.bgNormal);
                    } else {
                        RippleSelectView.this.setBackgroundDrawable(RippleSelectView.this.bgNormal);
                    }
                }
                RippleSelectView.this.invalidate();
            }
        }).setCenterXUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                RippleSelectView.this.rippleX = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            }
        }).setCenterYUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                RippleSelectView.this.rippleY = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            }
        }).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                RippleSelectView.this.isAnimator = true;
                if (RippleSelectView.this.listener != null) {
                    RippleSelectView.this.listener.onStart();
                }
            }

            public void onAnimationEnd(Animator animator) {
                RippleSelectView.this.isAnimator = false;
                if (RippleSelectView.this.isSelect) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        RippleSelectView.this.setBackground(RippleSelectView.this.bgSelect);
                    } else {
                        RippleSelectView.this.setBackgroundDrawable(RippleSelectView.this.bgSelect);
                    }
                } else if (Build.VERSION.SDK_INT >= 16) {
                    RippleSelectView.this.setBackground(RippleSelectView.this.bgNormal);
                } else {
                    RippleSelectView.this.setBackgroundDrawable(RippleSelectView.this.bgNormal);
                }
                RippleSelectView.this.rippleX = 0.0f;
                RippleSelectView.this.rippleY = 0.0f;
                RippleSelectView.this.rippleRadius = 0;
                if (RippleSelectView.this.listener != null) {
                    RippleSelectView.this.listener.onEnd();
                }
            }

            public void onAnimationCancel(Animator animator) {
                RippleSelectView.this.isAnimator = false;
                if (RippleSelectView.this.listener != null) {
                    RippleSelectView.this.listener.onCancel();
                }
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    public RippleAnimatorListener getListener() {
        return this.listener;
    }

    public void setListener(RippleAnimatorListener listener) {
        this.listener = listener;
    }

    public static interface RippleAnimatorListener {
        public void onStart();

        public void onEnd();

        public void onCancel();
    }

    private class RippleAnimation {
        private AnimatorSet animatorSet = new AnimatorSet();
        private ValueAnimator radiusAnimator;
        private ValueAnimator centerXAnimator;
        private ValueAnimator centerYAnimator;

        RippleAnimation(int rFrom, int rTo, float xFrom, float xTo, float yFrom, float yTo, int duration) {
            this.animatorSet.setDuration((long)duration);
            this.radiusAnimator = ValueAnimator.ofInt((int[])new int[]{rFrom, rTo});
            this.centerXAnimator = ValueAnimator.ofFloat((float[])new float[]{xFrom, xTo});
            this.centerYAnimator = ValueAnimator.ofFloat((float[])new float[]{yFrom, yTo});
            this.animatorSet.playTogether(new Animator[]{this.radiusAnimator, this.centerXAnimator, this.centerYAnimator});
            this.animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        }

        void start() {
            this.animatorSet.start();
        }

        RippleAnimation setRadiusUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
            this.radiusAnimator.addUpdateListener(listener);
            return this;
        }

        RippleAnimation setCenterXUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
            this.centerXAnimator.addUpdateListener(listener);
            return this;
        }

        RippleAnimation setCenterYUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
            this.centerYAnimator.addUpdateListener(listener);
            return this;
        }

        RippleAnimation setListener(Animator.AnimatorListener listener) {
            this.animatorSet.addListener(listener);
            return this;
        }
    }
}

