/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import wtf.emulator.OutputType;

@CacheableTask
public abstract class EwExecTask
extends DefaultTask {
    @Classpath
    @InputFiles
    public abstract Property<FileCollection> getClasspath();

    @Input
    public abstract Property<String> getToken();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getAppApk();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getTestApk();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLibraryTestApk();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getOutputsDir();

    @Optional
    @Input
    public abstract ListProperty<OutputType> getOutputTypes();

    @Optional
    @Input
    public abstract ListProperty<Map<String, String>> getDevices();

    @Optional
    @Input
    public abstract Property<Boolean> getUseOrchestrator();

    @Optional
    @Input
    public abstract Property<Boolean> getClearPackageData();

    @Optional
    @Input
    public abstract Property<Boolean> getWithCoverage();

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract Property<FileCollection> getAdditionalApks();

    @Optional
    @Input
    public abstract MapProperty<String, String> getEnvironmentVariables();

    @Optional
    @Input
    public abstract Property<Integer> getNumUniformShards();

    @Optional
    @Input
    public abstract Property<Integer> getNumBalancedShards();

    @Optional
    @Input
    public abstract Property<Integer> getNumShards();

    @Optional
    @Input
    public abstract ListProperty<String> getDirectoriesToPull();

    @Optional
    @Input
    public abstract Property<Boolean> getSideEffects();

    @Optional
    @Input
    public abstract Property<Duration> getTestTimeout();

    @Optional
    @Input
    public abstract Property<Boolean> getFileCacheEnabled();

    @Optional
    @Input
    public abstract Property<Duration> getFileCacheTtl();

    @Optional
    @Input
    public abstract Property<Boolean> getTestCacheEnabled();

    @Optional
    @Input
    public abstract Property<Integer> getNumFlakyTestAttempts();

    @TaskAction
    public void runTests() {
        String token = (String)this.getToken().getOrNull();
        if (token == null) {
            throw new IllegalArgumentException("Missing token for emulator.wtf.\nDid you forget to set token in the emulatorwtf {} block or EW_API_TOKEN env var?");
        }
        ExecResult result = this.getProject().javaexec(spec -> {
            List dirsToPull;
            Map env;
            Set additionalApks;
            spec.environment("EW_API_TOKEN", (Object)token);
            spec.classpath(new Object[]{this.getClasspath().get()});
            if (this.getLibraryTestApk().isPresent()) {
                spec.args(new Object[]{"--library-test", ((RegularFile)this.getLibraryTestApk().get()).getAsFile().getAbsolutePath()});
            } else {
                spec.args(new Object[]{"--app", ((RegularFile)this.getAppApk().get()).getAsFile().getAbsolutePath()});
                spec.args(new Object[]{"--test", ((RegularFile)this.getTestApk().get()).getAsFile().getAbsolutePath()});
            }
            if (this.getOutputsDir().isPresent()) {
                spec.args(new Object[]{"--outputs-dir", ((Directory)this.getOutputsDir().get()).getAsFile().getAbsolutePath()});
            }
            if (this.getOutputTypes().isPresent() && !((List)this.getOutputTypes().get()).isEmpty()) {
                String outputs = ((List)this.getOutputTypes().get()).stream().map(OutputType::getTypeName).collect(Collectors.joining(","));
                spec.args(new Object[]{"--outputs", outputs});
            }
            if (this.getTestTimeout().isPresent()) {
                spec.args(new Object[]{"--timeout", EwExecTask.toCliString((Duration)this.getTestTimeout().get())});
            }
            if (this.getDevices().isPresent()) {
                ((List)this.getDevices().get()).forEach(device -> {
                    if (!device.isEmpty()) {
                        spec.args(new Object[]{"--device", device.entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).collect(Collectors.joining(","))});
                    }
                });
            }
            if (Boolean.TRUE.equals(this.getUseOrchestrator().getOrNull())) {
                spec.args(new Object[]{"--use-orchestrator"});
            }
            if (Boolean.TRUE.equals(this.getClearPackageData().getOrNull())) {
                spec.args(new Object[]{"--clear-package-data"});
            }
            if (Boolean.TRUE.equals(this.getWithCoverage().getOrNull())) {
                spec.args(new Object[]{"--with-coverage"});
            }
            if (this.getAdditionalApks().isPresent() && !(additionalApks = ((FileCollection)this.getAdditionalApks().get()).getFiles()).isEmpty()) {
                spec.args(new Object[]{"--additional-apks", additionalApks.stream().map(File::getAbsolutePath).collect(Collectors.joining(","))});
            }
            if (this.getEnvironmentVariables().isPresent() && !(env = (Map)this.getEnvironmentVariables().get()).isEmpty()) {
                String envLine = env.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
                spec.args(new Object[]{"--environment-variables", envLine});
            }
            if (this.getNumBalancedShards().isPresent()) {
                spec.args(new Object[]{"--num-balanced-shards", String.valueOf(this.getNumBalancedShards().get())});
            } else if (this.getNumUniformShards().isPresent()) {
                spec.args(new Object[]{"--num-uniform-shards", String.valueOf(this.getNumUniformShards().get())});
            } else if (this.getNumShards().isPresent()) {
                spec.args(new Object[]{"--num-shards", String.valueOf(this.getNumShards().get())});
            }
            if (this.getDirectoriesToPull().isPresent() && !(dirsToPull = (List)this.getDirectoriesToPull().get()).isEmpty()) {
                spec.args(new Object[]{"--directories-to-pull", String.join((CharSequence)",", dirsToPull)});
            }
            if (this.getSideEffects().isPresent() && ((Boolean)this.getSideEffects().get()).booleanValue()) {
                spec.args(new Object[]{"--side-effects"});
            }
            if (this.getFileCacheEnabled().isPresent() && !((Boolean)this.getFileCacheEnabled().get()).booleanValue()) {
                spec.args(new Object[]{"--no-file-cache"});
            } else if (this.getFileCacheTtl().isPresent()) {
                spec.args(new Object[]{"--file-cache-ttl", EwExecTask.toCliString((Duration)this.getFileCacheTtl().get())});
            }
            if (this.getTestCacheEnabled().isPresent() && !((Boolean)this.getTestCacheEnabled().get()).booleanValue()) {
                spec.args(new Object[]{"--no-test-cache"});
            }
            if (this.getNumFlakyTestAttempts().isPresent()) {
                spec.args(new Object[]{"--num-flaky-test-attempts", ((Integer)this.getNumFlakyTestAttempts().get()).toString()});
            }
        });
        result.assertNormalExitValue();
    }

    private static String toCliString(Duration duration) {
        return duration.getSeconds() + "s";
    }
}

