/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wtf.emulator.OutputType;
import wtf.emulator.exec.EwCollectResultsWorkParameters;
import wtf.emulator.exec.EwWorkParameters;
import wtf.emulator.ext.Slf4jInfoOutputStream;

public class EwCliExecutor {
    private final Logger log = LoggerFactory.getLogger((String)"emulator.wtf");
    private final ExecOperations execOperations;

    public EwCliExecutor(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }

    public String collectRunResults(EwCollectResultsWorkParameters parameters, String runUuid, String runToken, String startTime, String displayName, String folderName) {
        if (runToken == null) {
            throw new IllegalArgumentException("Missing token for collecting emulator.wtf results. This is probably a bug - let us know at support@emulator.wtf.");
        }
        try {
            ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();
            ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
            ExecResult result = this.execOperations.javaexec(spec -> {
                Directory baseOutputDir = (Directory)parameters.getOutputsDir().getOrNull();
                File outputsDir = baseOutputDir == null ? null : new File(baseOutputDir.getAsFile(), folderName);
                EwCliExecutor.configureCollectExec(spec, parameters, runUuid, runToken, startTime, outputsDir);
                if (((Boolean)parameters.getPrintOutput().getOrElse((Object)false)).booleanValue()) {
                    spec.setErrorOutput((OutputStream)System.out);
                } else {
                    spec.setErrorOutput((OutputStream)new TeeOutputStream((OutputStream)errorOut, (OutputStream)new Slf4jInfoOutputStream(this.log)));
                }
                spec.setStandardOutput((OutputStream)jsonOut);
                spec.setIgnoreExitValue(true);
            });
            if (!((Boolean)parameters.getPrintOutput().getOrElse((Object)false)).booleanValue() && result.getExitValue() != 0) {
                System.out.println(errorOut);
            }
            JSONObject json = new JSONObject(jsonOut.toString());
            String resultsUrl = json.optString("resultsUrl");
            if (result.getExitValue() != 0) {
                String error = json.optString("error");
                String message = error != null && error.length() > 0 ? "\u274c " + displayName + " tests failed: " + error : (resultsUrl != null && resultsUrl.length() > 0 ? "\u274c " + displayName + " tests failed.\nDetails: " + resultsUrl + "\n" : "\u274c " + displayName + " tests failed");
                return message;
            }
            if (resultsUrl != null && resultsUrl.length() > 0) {
                return "\u2705 " + displayName + " tests passed.\nDetails: " + resultsUrl + "\n";
            }
            return "\u2705 " + displayName + " tests passed";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject invokeCli(EwWorkParameters parameters) {
        String token = (String)parameters.getToken().getOrNull();
        if (token == null) {
            throw new IllegalArgumentException("Missing token for emulator.wtf.\nDid you forget to set token in the emulatorwtf {} block or EW_API_TOKEN env var?");
        }
        try {
            ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();
            ByteArrayOutputStream errorOut = new ByteArrayOutputStream();
            ExecResult result = this.execOperations.javaexec(spec -> {
                EwCliExecutor.configureCliExec(spec, parameters, token);
                if (((Boolean)parameters.getPrintOutput().getOrElse((Object)false)).booleanValue()) {
                    spec.setErrorOutput((OutputStream)System.out);
                } else {
                    spec.setErrorOutput((OutputStream)new TeeOutputStream((OutputStream)errorOut, (OutputStream)new Slf4jInfoOutputStream(this.log)));
                }
                spec.setStandardOutput((OutputStream)jsonOut);
                spec.setIgnoreExitValue(true);
            });
            if (!((Boolean)parameters.getPrintOutput().getOrElse((Object)false)).booleanValue() && result.getExitValue() != 0) {
                System.out.println(errorOut);
            }
            if (result.getExitValue() != 0) {
                JSONObject json = new JSONObject(jsonOut.toString());
                String resultsUrl = json.optString("resultsUrl");
                String error = json.optString("error");
                Object message = error != null && error.length() > 0 ? "emulator.wtf test run failed: " + error : (resultsUrl != null && resultsUrl.length() > 0 ? "emulator.wtf test run failed. Details: " + resultsUrl : "emulator.wtf test run failed");
                if (((Boolean)parameters.getIgnoreFailures().getOrElse((Object)false)).booleanValue()) {
                    this.log.warn((String)message);
                    if (parameters.getOutputFailureFile().isPresent()) {
                        File failureFile = ((RegularFile)parameters.getOutputFailureFile().get()).getAsFile();
                        try {
                            StringBuilder fileMessage = new StringBuilder();
                            if (parameters.getDisplayName().isPresent()) {
                                fileMessage.append((String)parameters.getDisplayName().get()).append(": ");
                                fileMessage.append((String)message);
                            }
                            FileUtils.write((File)failureFile, (CharSequence)fileMessage.toString(), (Charset)StandardCharsets.UTF_8);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return json;
                }
                throw new GradleException((String)message);
            }
            return new JSONObject(jsonOut.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void configureCollectExec(JavaExecSpec spec, EwCollectResultsWorkParameters parameters, String runUuid, String runToken, String startTime, @Nullable File outputFolder) {
        spec.environment("EW_RUN_TOKEN", (Object)runToken);
        spec.classpath(new Object[]{parameters.getClasspath().get()});
        spec.args(new Object[]{"--collect-results"});
        spec.args(new Object[]{"--run-uuid", runUuid});
        spec.args(new Object[]{"--start-time", startTime});
        if (outputFolder != null) {
            spec.args(new Object[]{"--outputs-dir", outputFolder.getAbsolutePath()});
        }
        if (outputFolder != null && parameters.getOutputs().isPresent() && !((List)parameters.getOutputs().get()).isEmpty()) {
            String outputs = ((List)parameters.getOutputs().get()).stream().map(OutputType::getTypeName).collect(Collectors.joining(","));
            spec.args(new Object[]{"--outputs", outputs});
        }
        if (parameters.getProxyHost().isPresent()) {
            spec.args(new Object[]{"--proxy-host", parameters.getProxyHost().get()});
        }
        if (parameters.getProxyPort().isPresent()) {
            spec.args(new Object[]{"--proxy-port", ((Integer)parameters.getProxyPort().get()).toString()});
        }
        if (parameters.getProxyUser().isPresent()) {
            spec.args(new Object[]{"--proxy-user", parameters.getProxyUser().get()});
        }
        if (parameters.getProxyPassword().isPresent()) {
            spec.args(new Object[]{"--proxy-password", parameters.getProxyPassword().get()});
        }
        spec.args(new Object[]{"--json"});
    }

    protected static void configureCliExec(JavaExecSpec spec, EwWorkParameters parameters, String token) {
        List dirsToPull;
        Map env;
        Set additionalApks;
        spec.environment("EW_API_TOKEN", (Object)token);
        spec.classpath(new Object[]{parameters.getClasspath().get()});
        if (parameters.getWorkingDir().isPresent()) {
            spec.workingDir(parameters.getWorkingDir().get());
        }
        spec.args(new Object[]{"--ew-integration", "gradle-plugin 0.16.0"});
        if (parameters.getDisplayName().isPresent()) {
            spec.args(new Object[]{"--display-name", parameters.getDisplayName().get()});
        }
        if (parameters.getScmUrl().isPresent()) {
            spec.args(new Object[]{"--scm-url", parameters.getScmUrl().get()});
        }
        if (parameters.getScmCommitHash().isPresent()) {
            spec.args(new Object[]{"--scm-commit", parameters.getScmCommitHash().get()});
        }
        if (parameters.getScmRefName().isPresent()) {
            spec.args(new Object[]{"--scm-ref-name", parameters.getScmRefName().get()});
        }
        if (parameters.getScmPrUrl().isPresent()) {
            spec.args(new Object[]{"--scm-pr-url", parameters.getScmPrUrl().get()});
        }
        if (parameters.getLibraryTestApk().isPresent()) {
            spec.args(new Object[]{"--library-test", ((RegularFile)parameters.getLibraryTestApk().get()).getAsFile().getAbsolutePath()});
        } else {
            spec.args(new Object[]{"--app", ((RegularFile)parameters.getAppApk().get()).getAsFile().getAbsolutePath()});
            spec.args(new Object[]{"--test", ((RegularFile)parameters.getTestApk().get()).getAsFile().getAbsolutePath()});
        }
        if (parameters.getOutputsDir().isPresent() && !((Boolean)parameters.getAsync().getOrElse((Object)false)).booleanValue()) {
            spec.args(new Object[]{"--outputs-dir", ((Directory)parameters.getOutputsDir().get()).getAsFile().getAbsolutePath()});
        }
        if (parameters.getOutputs().isPresent() && !((List)parameters.getOutputs().get()).isEmpty()) {
            String outputs = ((List)parameters.getOutputs().get()).stream().map(OutputType::getTypeName).collect(Collectors.joining(","));
            spec.args(new Object[]{"--outputs", outputs});
        }
        if (parameters.getRecordVideo().isPresent() && ((Boolean)parameters.getRecordVideo().get()).booleanValue()) {
            spec.args(new Object[]{"--record-video"});
        }
        if (parameters.getTimeout().isPresent()) {
            spec.args(new Object[]{"--timeout", EwCliExecutor.toCliString((Duration)parameters.getTimeout().get())});
        }
        if (parameters.getDevices().isPresent()) {
            ((List)parameters.getDevices().get()).forEach(device -> {
                if (!device.isEmpty()) {
                    spec.args(new Object[]{"--device", device.entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).collect(Collectors.joining(","))});
                }
            });
        }
        if (Boolean.TRUE.equals(parameters.getUseOrchestrator().getOrNull())) {
            spec.args(new Object[]{"--use-orchestrator"});
        }
        if (Boolean.TRUE.equals(parameters.getClearPackageData().getOrNull())) {
            spec.args(new Object[]{"--clear-package-data"});
        }
        if (Boolean.TRUE.equals(parameters.getWithCoverage().getOrNull())) {
            spec.args(new Object[]{"--with-coverage"});
        }
        if (parameters.getAdditionalApks().isPresent() && !(additionalApks = ((FileCollection)parameters.getAdditionalApks().get()).getFiles()).isEmpty()) {
            spec.args(new Object[]{"--additional-apks", additionalApks.stream().map(File::getAbsolutePath).collect(Collectors.joining(","))});
        }
        if (parameters.getEnvironmentVariables().isPresent() && !(env = (Map)parameters.getEnvironmentVariables().get()).isEmpty()) {
            String envLine = env.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
            spec.args(new Object[]{"--environment-variables", envLine});
        }
        if (parameters.getShardTargetRuntime().isPresent()) {
            spec.args(new Object[]{"--shard-target-runtime", parameters.getShardTargetRuntime().get() + "m"});
        } else if (parameters.getNumBalancedShards().isPresent()) {
            spec.args(new Object[]{"--num-balanced-shards", String.valueOf(parameters.getNumBalancedShards().get())});
        } else if (parameters.getNumUniformShards().isPresent()) {
            spec.args(new Object[]{"--num-uniform-shards", String.valueOf(parameters.getNumUniformShards().get())});
        } else if (parameters.getNumShards().isPresent()) {
            spec.args(new Object[]{"--num-shards", String.valueOf(parameters.getNumShards().get())});
        }
        if (parameters.getDirectoriesToPull().isPresent() && !(dirsToPull = (List)parameters.getDirectoriesToPull().get()).isEmpty()) {
            spec.args(new Object[]{"--directories-to-pull", String.join((CharSequence)",", dirsToPull)});
        }
        if (parameters.getSideEffects().isPresent() && ((Boolean)parameters.getSideEffects().get()).booleanValue()) {
            spec.args(new Object[]{"--side-effects"});
        }
        if (parameters.getFileCacheEnabled().isPresent() && !((Boolean)parameters.getFileCacheEnabled().get()).booleanValue()) {
            spec.args(new Object[]{"--no-file-cache"});
        } else if (parameters.getFileCacheTtl().isPresent()) {
            spec.args(new Object[]{"--file-cache-ttl", EwCliExecutor.toCliString((Duration)parameters.getFileCacheTtl().get())});
        }
        if (parameters.getTestCacheEnabled().isPresent() && !((Boolean)parameters.getTestCacheEnabled().get()).booleanValue()) {
            spec.args(new Object[]{"--no-test-cache"});
        }
        if (parameters.getNumFlakyTestAttempts().isPresent()) {
            spec.args(new Object[]{"--num-flaky-test-attempts", ((Integer)parameters.getNumFlakyTestAttempts().get()).toString()});
        }
        if (parameters.getFlakyTestRepeatMode().isPresent()) {
            spec.args(new Object[]{"--flaky-test-repeat-mode", parameters.getFlakyTestRepeatMode().get()});
        }
        if (((Boolean)parameters.getAsync().getOrElse((Object)false)).booleanValue()) {
            spec.args(new Object[]{"--async"});
        }
        if (parameters.getTestTargets().isPresent()) {
            spec.args(new Object[]{"--test-targets", parameters.getTestTargets().get()});
        }
        if (parameters.getProxyHost().isPresent()) {
            spec.args(new Object[]{"--proxy-host", parameters.getProxyHost().get()});
        }
        if (parameters.getProxyPort().isPresent()) {
            spec.args(new Object[]{"--proxy-port", ((Integer)parameters.getProxyPort().get()).toString()});
        }
        if (parameters.getProxyUser().isPresent()) {
            spec.args(new Object[]{"--proxy-user", parameters.getProxyUser().get()});
        }
        if (parameters.getProxyPassword().isPresent()) {
            spec.args(new Object[]{"--proxy-password", parameters.getProxyPassword().get()});
        }
        spec.args(new Object[]{"--json"});
    }

    private static String toCliString(Duration duration) {
        return duration.getSeconds() + "s";
    }
}

