/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import java.time.Duration;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import wtf.emulator.EwWorkAction;
import wtf.emulator.OutputType;

@CacheableTask
public abstract class EwExecTask
extends DefaultTask {
    @Classpath
    @InputFiles
    public abstract Property<FileCollection> getClasspath();

    @Input
    public abstract Property<String> getToken();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getAppApk();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getTestApk();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLibraryTestApk();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getOutputsDir();

    @Optional
    @Input
    public abstract ListProperty<OutputType> getOutputTypes();

    @Optional
    @Input
    public abstract Property<Boolean> getRecordVideo();

    @Optional
    @Input
    public abstract ListProperty<Map<String, String>> getDevices();

    @Optional
    @Input
    public abstract Property<Boolean> getUseOrchestrator();

    @Optional
    @Input
    public abstract Property<Boolean> getClearPackageData();

    @Optional
    @Input
    public abstract Property<Boolean> getWithCoverage();

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract Property<FileCollection> getAdditionalApks();

    @Optional
    @Input
    public abstract MapProperty<String, String> getEnvironmentVariables();

    @Optional
    @Input
    public abstract Property<Integer> getNumUniformShards();

    @Optional
    @Input
    public abstract Property<Integer> getNumBalancedShards();

    @Optional
    @Input
    public abstract Property<Integer> getNumShards();

    @Optional
    @Input
    public abstract Property<Integer> getShardTargetRuntime();

    @Optional
    @Input
    public abstract ListProperty<String> getDirectoriesToPull();

    @Optional
    @Input
    public abstract Property<Boolean> getSideEffects();

    @Optional
    @Input
    public abstract Property<Duration> getTestTimeout();

    @Optional
    @Input
    public abstract Property<Boolean> getFileCacheEnabled();

    @Optional
    @Input
    public abstract Property<Duration> getFileCacheTtl();

    @Optional
    @Input
    public abstract Property<Boolean> getTestCacheEnabled();

    @Optional
    @Input
    public abstract Property<Integer> getNumFlakyTestAttempts();

    @Optional
    @Input
    public abstract Property<String> getFlakyTestRepeatMode();

    @Optional
    @Input
    public abstract Property<String> getDisplayName();

    @Optional
    @Input
    public abstract Property<String> getScmUrl();

    @Optional
    @Input
    public abstract Property<String> getScmCommitHash();

    @Optional
    @Input
    public abstract Property<Boolean> getIgnoreFailures();

    @Optional
    @Input
    public abstract Property<Boolean> getAsync();

    @Internal
    public abstract RegularFileProperty getWorkingDir();

    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @Internal
    public abstract RegularFileProperty getOutputFailureFile();

    @Optional
    @Input
    public abstract Property<Boolean> getPrintOutput();

    @Optional
    @Input
    public abstract Property<String> getTestTargets();

    @Optional
    @Input
    public abstract Property<String> getProxyHost();

    @Optional
    @Input
    public abstract Property<Integer> getProxyPort();

    @Optional
    @Input
    public abstract Property<String> getProxyUser();

    @Optional
    @Input
    public abstract Property<String> getProxyPassword();

    @TaskAction
    public void runTests() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(EwWorkAction.class, p -> {
            p.getClasspath().set((Iterable)((FileCollection)this.getClasspath().get()).getFiles());
            p.getToken().set(this.getToken());
            p.getAppApk().set((Provider)this.getAppApk());
            p.getTestApk().set((Provider)this.getTestApk());
            p.getLibraryTestApk().set((Provider)this.getLibraryTestApk());
            p.getOutputsDir().set((Provider)this.getOutputsDir());
            p.getOutputs().set(this.getOutputTypes());
            p.getRecordVideo().set(this.getRecordVideo());
            p.getDevices().set(this.getDevices());
            p.getUseOrchestrator().set(this.getUseOrchestrator());
            p.getClearPackageData().set(this.getClearPackageData());
            p.getWithCoverage().set(this.getWithCoverage());
            p.getAdditionalApks().set(this.getAdditionalApks());
            p.getEnvironmentVariables().set(this.getEnvironmentVariables());
            p.getNumUniformShards().set(this.getNumUniformShards());
            p.getNumBalancedShards().set(this.getNumBalancedShards());
            p.getNumShards().set(this.getNumShards());
            p.getShardTargetRuntime().set(this.getShardTargetRuntime());
            p.getDirectoriesToPull().set(this.getDirectoriesToPull());
            p.getSideEffects().set(this.getSideEffects());
            p.getTimeout().set(this.getTestTimeout());
            p.getFileCacheEnabled().set(this.getFileCacheEnabled());
            p.getFileCacheTtl().set(this.getFileCacheTtl());
            p.getTestCacheEnabled().set(this.getTestCacheEnabled());
            p.getNumFlakyTestAttempts().set(this.getNumFlakyTestAttempts());
            p.getFlakyTestRepeatMode().set(this.getFlakyTestRepeatMode());
            p.getDisplayName().set(this.getDisplayName());
            p.getScmUrl().set(this.getScmUrl());
            p.getScmCommitHash().set(this.getScmCommitHash());
            p.getWorkingDir().set((Provider)this.getWorkingDir());
            p.getIgnoreFailures().set(this.getIgnoreFailures());
            p.getOutputFailureFile().set((Provider)this.getOutputFailureFile());
            p.getAsync().set(this.getAsync());
            p.getPrintOutput().set(this.getPrintOutput());
            p.getTestTargets().set(this.getTestTargets());
            p.getProxyHost().set(this.getProxyHost());
            p.getProxyPort().set(this.getProxyPort());
            p.getProxyUser().set(this.getProxyUser());
            p.getProxyPassword().set(this.getProxyPassword());
        });
    }
}

