/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import wtf.emulator.EwInvokeConfiguration;
import wtf.emulator.EwVariantFilter;

public abstract class EwExtension
implements EwInvokeConfiguration {
    private final Property<Integer> variantCount;
    private Action<EwVariantFilter> filter = null;

    public abstract Property<Boolean> getRepositoryCheckEnabled();

    public abstract Property<String> getVersion();

    public abstract Property<String> getToken();

    public abstract DirectoryProperty getBaseOutputDir();

    public abstract ListProperty<Map<String, Object>> getDevices();

    public abstract MapProperty<String, Object> getEnvironmentVariables();

    @Inject
    public EwExtension(ObjectFactory objectFactory) {
        this.getVersion().convention((Object)"0.9.16");
        this.getSideEffects().convention((Object)false);
        this.getOutputs().convention(Collections.emptyList());
        EwExtension.sysPropConvention(this.getProxyHost(), "http.proxyHost");
        EwExtension.sysPropConvention(this.getProxyPort(), "http.proxyPort", Integer::parseInt);
        EwExtension.sysPropConvention(this.getProxyUser(), "http.proxyUser");
        EwExtension.sysPropConvention(this.getProxyPassword(), "http.proxyPassword");
        this.variantCount = objectFactory.property(Integer.class).convention((Object)0);
    }

    public void variantFilter(Action<EwVariantFilter> filter) {
        this.filter = filter;
    }

    protected Action<EwVariantFilter> getFilter() {
        return this.filter;
    }

    protected Property<Integer> getVariantCount() {
        return this.variantCount;
    }

    private static void sysPropConvention(Property<String> extProp, String key) {
        EwExtension.sysPropConvention(extProp, key, Function.identity());
    }

    private static <T> void sysPropConvention(Property<T> extProp, String key, Function<String, T> transform) {
        String sysPropValue = System.getProperty(key);
        if (sysPropValue != null && !sysPropValue.isBlank()) {
            try {
                T transformed = transform.apply(sysPropValue);
                if (transformed != null) {
                    extProp.convention(transformed);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

