/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import com.android.build.VariantOutput;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;
import wtf.emulator.EwExtension;

public class EwPlugin
implements Plugin<Project> {
    private static final String TOOL_CONFIGURATION = "emulatorWtfCli";

    public void apply(Project target) {
        EwExtension ext = (EwExtension)target.getExtensions().create("emulatorwtf", EwExtension.class, new Object[0]);
        ext.getBaseOutputDir().convention(target.getLayout().getBuildDirectory().dir("test-results"));
        target.getRepositories().maven(repo -> {
            try {
                repo.setUrl((Object)new URI("https://maven.emulator.wtf/releases/").toURL());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        });
        Configuration toolConfig = (Configuration)target.getConfigurations().maybeCreate(TOOL_CONFIGURATION);
        target.getDependencies().add(TOOL_CONFIGURATION, (Object)ext.getVersion().map(version -> "wtf.emulator:ew-cli:" + version));
        target.getPluginManager().withPlugin("com.android.application", plugin -> {
            AppExtension android = (AppExtension)target.getExtensions().getByType(AppExtension.class);
            android.getApplicationVariants().all(variant -> this.configureVariant(target, (BaseExtension)android, ext, toolConfig, variant));
        });
        target.getPluginManager().withPlugin("com.android.library", plugin -> {
            LibraryExtension android = (LibraryExtension)target.getExtensions().getByType(LibraryExtension.class);
            android.getLibraryVariants().all(variant -> this.configureVariant(target, (BaseExtension)android, ext, toolConfig, variant));
        });
    }

    public <T extends TestedVariant & BaseVariant> void configureVariant(Project target, BaseExtension android, EwExtension ext, Configuration toolConfig, T variant) {
        String taskName = "test" + EwPlugin.capitalize(((BaseVariant)variant).getName()) + "WithEmulatorWtf";
        TestVariant testVariant = variant.getTestVariant();
        if (testVariant != null) {
            target.getTasks().register(taskName, JavaExec.class, task -> {
                task.setDescription("Run " + ((BaseVariant)variant).getName() + " instrumentation tests with emulator.wtf");
                task.setGroup("Verification");
                task.dependsOn(new Object[]{testVariant.getPackageApplicationProvider()});
                task.classpath(new Object[]{toolConfig});
                BaseVariantOutput appOutput = EwPlugin.getMainOutput(testVariant.getTestedVariant());
                if (appOutput instanceof ApkVariantOutput) {
                    task.dependsOn(new Object[]{((ApkVariant)variant).getPackageApplicationProvider()});
                    String underTest = appOutput.getOutputFile().getAbsolutePath();
                    if (underTest.endsWith(".apk")) {
                        task.args(new Object[]{"--app", underTest});
                    }
                }
                BaseVariantOutput testOutput = EwPlugin.getMainOutput((BaseVariant)testVariant);
                String token = (String)ext.getToken().getOrNull();
                if (token == null) {
                    token = System.getenv("EW_API_TOKEN");
                }
                if (token == null) {
                    throw new IllegalArgumentException("Missing token for emulator.wtf.\nDid you forgot to set token in the emulatorwtf {} block?");
                }
                task.environment("EW_API_TOKEN", (Object)token);
                task.args(new Object[]{"--test", testOutput.getOutputFile().getAbsolutePath()});
                if (ext.getBaseOutputDir().isPresent()) {
                    File outputsDir = ((Directory)ext.getBaseOutputDir().map(dir -> dir.dir(((BaseVariant)variant).getName())).get()).getAsFile();
                    task.args(new Object[]{"--outputs-dir", outputsDir.getAbsolutePath()});
                }
                if (ext.getDevices().isPresent() && !((List)ext.getDevices().get()).isEmpty()) {
                    ((List)ext.getDevices().get()).forEach(device -> task.args(new Object[]{"--device", device.entrySet().stream().map(it -> (String)it.getKey() + "=" + it.getValue().toString()).collect(Collectors.joining(","))}));
                }
                if (ext.getUseOrchestrator().isPresent()) {
                    if (((Boolean)ext.getUseOrchestrator().get()).booleanValue()) {
                        task.args(new Object[]{"--use-orchestrator"});
                    }
                } else if (android.getTestOptions().getExecution().equalsIgnoreCase("ANDROIDX_TEST_ORCHESTRATOR")) {
                    task.args(new Object[]{"--use-orchestrator"});
                }
                if (Boolean.TRUE.equals(ext.getClearPackageData().getOrNull())) {
                    task.args(new Object[]{"--clear-package-data"});
                }
                if (Boolean.TRUE.equals(ext.getWithCoverage().getOrNull())) {
                    task.args(new Object[]{"--with-coverage"});
                } else if (((BaseVariant)variant).getBuildType().isTestCoverageEnabled()) {
                    task.args(new Object[]{"--with-coverage"});
                }
                if (ext.getAdditionalApks().isPresent() && !((FileCollection)ext.getAdditionalApks().get()).isEmpty()) {
                    task.args(new Object[]{"--additional-apks", ((FileCollection)ext.getAdditionalApks().get()).getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(","))});
                }
                LinkedHashMap runnerArgs = new LinkedHashMap(((BaseVariant)variant).getMergedFlavor().getTestInstrumentationRunnerArguments());
                if (ext.getEnvironmentVariables().isPresent()) {
                    ((Map)ext.getEnvironmentVariables().get()).entrySet().forEach(entry -> runnerArgs.put(entry.getKey(), entry.getValue() == null ? null : (Object)entry.getValue()));
                }
                if (!runnerArgs.isEmpty()) {
                    String envLine = runnerArgs.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(","));
                    task.args(new Object[]{"--environment-variables", envLine});
                }
                if (ext.getNumUniformShards().isPresent()) {
                    task.args(new Object[]{"--num-uniform-shards", String.valueOf(ext.getNumUniformShards().get())});
                } else if (ext.getNumShards().isPresent()) {
                    task.args(new Object[]{"--num-shards", String.valueOf(ext.getNumShards().get())});
                }
                if (ext.getDirectoriesToPull().isPresent() && !((List)ext.getDirectoriesToPull().get()).isEmpty()) {
                    task.args(new Object[]{"--directories-to-pull", String.join((CharSequence)",", (Iterable)ext.getDirectoriesToPull().get())});
                }
            });
        }
    }

    private static BaseVariantOutput getMainOutput(BaseVariant variant) {
        return variant.getOutputs().stream().filter(it -> it.getOutputType().equals(VariantOutput.MAIN)).findFirst().orElse((BaseVariantOutput)variant.getOutputs().stream().findFirst().orElseThrow(() -> new IllegalStateException("Test variant has no outputs!")));
    }

    private static String capitalize(String str) {
        if (str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toUpperCase(Locale.US) + str.substring(1);
    }
}

