/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.progress;

import java.io.PrintStream;
import ws.schild.jave.progress.VideoProgressListener;

public class EchoingProgressListener
implements VideoProgressListener {
    private String prefix = "";
    private PrintStream out = System.out;

    public EchoingProgressListener() {
    }

    public EchoingProgressListener(String prefix) {
        this();
        this.prefix = prefix;
    }

    public EchoingProgressListener(String prefix, PrintStream out) {
        this(prefix);
        this.out = out;
    }

    @Override
    public void onBegin() {
        this.out.println(this.prefix + " Beginning");
    }

    @Override
    public void onMessage(String message) {
        this.out.println(this.prefix + " Message Received: " + message);
    }

    @Override
    public void onProgress(Double progress) {
        this.out.println(this.prefix + " Progress Notification: " + progress);
    }

    @Override
    public void onError(String message) {
        this.out.println(this.prefix + " Error Encountered: " + message);
    }

    @Override
    public void onComplete() {
        this.out.println(this.prefix + " Complete!");
    }
}

