/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.ConversionOutputAnalyzer;
import ws.schild.jave.EncoderException;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.ArgType;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingArgument;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.encode.PredicateArgument;
import ws.schild.jave.encode.ValueArgument;
import ws.schild.jave.encode.VideoAttributes;
import ws.schild.jave.encode.VideoFilterArgument;
import ws.schild.jave.encode.enums.VsyncMethod;
import ws.schild.jave.encode.enums.X264_PROFILE;
import ws.schild.jave.filters.FilterGraph;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.info.VideoSize;
import ws.schild.jave.process.ProcessLocator;
import ws.schild.jave.process.ProcessWrapper;
import ws.schild.jave.process.ffmpeg.DefaultFFMPEGLocator;
import ws.schild.jave.progress.EncoderProgressListener;
import ws.schild.jave.utils.RBufferedReader;

public class Encoder {
    private static final Logger LOG = LoggerFactory.getLogger(Encoder.class);
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^\\s*([D ])([E ])\\s+([\\w,]+)\\s+.+$");
    private static final Pattern ENCODER_DECODER_PATTERN = Pattern.compile("^\\s*([AVS]).{5}\\s(\\S+).(.+)$", 2);
    private static final Pattern SUCCESS_PATTERN = Pattern.compile("^\\s*video\\:\\S+\\s+audio\\:\\S+\\s+subtitle\\:\\S+\\s+global headers\\:\\S+.*$", 2);
    private final ProcessLocator locator;
    private ProcessWrapper ffmpeg;
    private List<String> unhandledMessages = null;
    private static List<EncodingArgument> globalOptions = new ArrayList<EncodingArgument>(Arrays.asList(new ValueArgument(ArgType.GLOBAL, "--filter_thread", ea -> ea.getFilterThreads().map(Object::toString)), new ValueArgument(ArgType.GLOBAL, "-ss", ea -> ea.getOffset().map(Object::toString)), new ValueArgument(ArgType.INFILE, "-threads", ea -> ea.getDecodingThreads().map(Object::toString)), new PredicateArgument(ArgType.INFILE, "-loop", "1", ea -> ea.getLoop() && ea.getDuration().isPresent()), new ValueArgument(ArgType.INFILE, "-f", ea -> ea.getInputFormat()), new ValueArgument(ArgType.INFILE, "-safe", ea -> ea.getSafe().map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-t", ea -> ea.getDuration().map(Object::toString)), new PredicateArgument(ArgType.OUTFILE, "-vn", ea -> !ea.getVideoAttributes().isPresent()), new ValueArgument(ArgType.OUTFILE, "-vcodec", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getCodec)), new ValueArgument(ArgType.OUTFILE, "-vtag", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getTag)), new ValueArgument(ArgType.OUTFILE, "-vb", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getBitRate).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-r", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getFrameRate).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-s", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getSize).map(VideoSize::asEncoderArgument)), new PredicateArgument(ArgType.OUTFILE, "-movflags", "faststart", ea -> ea.getVideoAttributes().isPresent()), new ValueArgument(ArgType.OUTFILE, "-profile:v", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getX264Profile).map(X264_PROFILE::getModeName)), new VideoFilterArgument(ArgType.OUTFILE, ea -> ea.getVideoAttributes().map(VideoAttributes::getVideoFilters).map(Collection::stream).map(s -> s.flatMap(vf -> Stream.of(vf.getExpression()))).orElseGet(Stream::empty)), new ValueArgument(ArgType.OUTFILE, "-filter_complex", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getComplexFiltergraph).map(FilterGraph::getExpression)), new ValueArgument(ArgType.OUTFILE, "-qscale:v", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getQuality).map(Object::toString)), new PredicateArgument(ArgType.OUTFILE, "-an", ea -> !ea.getAudioAttributes().isPresent()), new ValueArgument(ArgType.OUTFILE, "-acodec", ea -> ea.getAudioAttributes().flatMap(AudioAttributes::getCodec)), new ValueArgument(ArgType.OUTFILE, "-ab", ea -> ea.getAudioAttributes().flatMap(AudioAttributes::getBitRate).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-ac", ea -> ea.getAudioAttributes().flatMap(AudioAttributes::getChannels).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-ar", ea -> ea.getAudioAttributes().flatMap(AudioAttributes::getSamplingRate).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-vol", ea -> ea.getAudioAttributes().flatMap(AudioAttributes::getVolume).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-qscale:a", ea -> ea.getAudioAttributes().flatMap(AudioAttributes::getQuality).map(Object::toString)), new ValueArgument(ArgType.OUTFILE, "-f", ea -> ea.getOutputFormat()), new ValueArgument(ArgType.OUTFILE, "-threads", ea -> ea.getEncodingThreads().map(Object::toString)), new PredicateArgument(ArgType.OUTFILE, "-map_metadata", "0", ea -> ea.isMapMetaData()), new ValueArgument(ArgType.OUTFILE, "-pix_fmt", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getPixelFormat)), new ValueArgument(ArgType.OUTFILE, "-vsync", ea -> ea.getVideoAttributes().flatMap(VideoAttributes::getVsync).map(VsyncMethod::getMethodName))));

    public Encoder() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public Encoder(ProcessLocator locator) {
        this.locator = locator;
    }

    public String[] getAudioDecoders() throws EncoderException {
        return this.getCoders(false, true);
    }

    public String[] getAudioEncoders() throws EncoderException {
        return this.getCoders(true, true);
    }

    protected String[] getCoders(boolean encoder, boolean audio) throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        ProcessWrapper localFFMPEG = this.locator.createExecutor();
        localFFMPEG.addArgument(encoder ? "-encoders" : "-decoders");
        try {
            String line;
            localFFMPEG.execute();
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(localFFMPEG.getInputStream()));
            String format = audio ? "A" : "V";
            boolean headerFound = false;
            boolean evaluateLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (headerFound) {
                    if (evaluateLine) {
                        Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            String audioVideoFlag = matcher.group(1);
                            if (!format.equals(audioVideoFlag)) continue;
                            String name = matcher.group(2);
                            res.add(name);
                            continue;
                        }
                        break;
                    }
                    evaluateLine = line.trim().equals("------");
                    continue;
                }
                if (!line.trim().equals(encoder ? "Encoders:" : "Decoders:")) continue;
                headerFound = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            localFFMPEG.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getVideoDecoders() throws EncoderException {
        return this.getCoders(false, false);
    }

    public String[] getVideoEncoders() throws EncoderException {
        return this.getCoders(true, false);
    }

    public String[] getSupportedEncodingFormats() throws EncoderException {
        return this.getSupportedCodingFormats(true);
    }

    protected String[] getSupportedCodingFormats(boolean encoding) throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        try (ProcessWrapper localFFMPEG = this.locator.createExecutor();){
            String line;
            localFFMPEG.addArgument("-formats");
            localFFMPEG.execute();
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(localFFMPEG.getInputStream()));
            String ed = encoding ? "E" : "D";
            boolean headerFound = false;
            boolean evaluateLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (headerFound) {
                    if (evaluateLine) {
                        Matcher matcher = FORMAT_PATTERN.matcher(line);
                        if (!matcher.matches()) break;
                        String encoderFlag = matcher.group(encoding ? 2 : 1);
                        if (!ed.equals(encoderFlag)) continue;
                        String aux = matcher.group(3);
                        StringTokenizer st = new StringTokenizer(aux, ",");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken().trim();
                            if (res.contains(token)) continue;
                            res.add(token);
                        }
                        continue;
                    }
                    evaluateLine = line.trim().equals("--");
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                headerFound = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getSupportedDecodingFormats() throws EncoderException {
        return this.getSupportedCodingFormats(false);
    }

    public void encode(MultimediaObject multimediaObject, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(multimediaObject, target, attributes, null);
    }

    public void encode(List<MultimediaObject> multimediaObjects, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(multimediaObjects, target, attributes, null);
    }

    public void encode(MultimediaObject multimediaObject, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        ArrayList<MultimediaObject> src = new ArrayList<MultimediaObject>();
        src.add(multimediaObject);
        this.encode(src, target, attributes, listener);
    }

    public static void addOptionAtIndex(EncodingArgument arg, Integer index) {
        globalOptions.add(index, arg);
    }

    public void encode(List<MultimediaObject> multimediaObjects, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        attributes.validate();
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        this.ffmpeg = this.locator.createExecutor();
        globalOptions.stream().filter(ea -> ArgType.GLOBAL.equals((Object)ea.getArgType())).flatMap(eArg -> eArg.getArguments(attributes)).forEach(this.ffmpeg::addArgument);
        globalOptions.stream().filter(ea -> ArgType.INFILE.equals((Object)ea.getArgType())).flatMap(eArg -> eArg.getArguments(attributes)).forEach(this.ffmpeg::addArgument);
        multimediaObjects.stream().map(Object::toString).flatMap(mmo -> Stream.of("-i", mmo)).forEach(this.ffmpeg::addArgument);
        globalOptions.stream().filter(ea -> ArgType.OUTFILE.equals((Object)ea.getArgType())).flatMap(eArg -> eArg.getArguments(attributes)).forEach(this.ffmpeg::addArgument);
        this.ffmpeg.addArgument("-y");
        this.ffmpeg.addArgument(target.getAbsolutePath());
        try {
            this.ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            String lastWarning = null;
            long duration = 0L;
            MultimediaInfo info = null;
            if (!(multimediaObjects.size() != 1 || multimediaObjects.get(0).isURL() && multimediaObjects.get(0).isReadURLOnce())) {
                info = multimediaObjects.get(0).getInfo();
            }
            Float offsetAttribute = attributes.getOffset().orElse(null);
            Float durationAttribute = attributes.getDuration().orElse(null);
            if (durationAttribute != null) {
                duration = Math.round(durationAttribute.floatValue() * 1000.0f);
            } else if (info != null) {
                duration = info.getDuration();
                if (offsetAttribute != null) {
                    duration -= (long)Math.round(offsetAttribute.floatValue() * 1000.0f);
                }
            }
            if (listener != null) {
                listener.sourceInfo(info);
            }
            ConversionOutputAnalyzer outputAnalyzer = new ConversionOutputAnalyzer(duration, listener);
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(this.ffmpeg.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                outputAnalyzer.analyzeNewLine(line);
            }
            if (outputAnalyzer.getLastWarning() != null && !SUCCESS_PATTERN.matcher(lastWarning).matches()) {
                throw new EncoderException("No match for: " + SUCCESS_PATTERN + " in " + lastWarning);
            }
            this.unhandledMessages = outputAnalyzer.getUnhandledMessages();
            int exitCode = this.ffmpeg.getProcessExitCode();
            if (exitCode != 0) {
                LOG.error("Process exit code: {}  to {}", (Object)exitCode, (Object)target.getName());
                throw new EncoderException("Exit code of ffmpeg encoding run is " + exitCode);
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            if (this.ffmpeg != null) {
                this.ffmpeg.destroy();
            }
            this.ffmpeg = null;
        }
    }

    public List<String> getUnhandledMessages() {
        return this.unhandledMessages;
    }

    public void abortEncoding() {
        if (this.ffmpeg != null) {
            this.ffmpeg.destroy();
            this.ffmpeg = null;
        }
    }
}

