/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import ws.schild.jave.filters.Filter;
import ws.schild.jave.filters.VideoFilter;

public class FilterChain
implements VideoFilter {
    private List<Filter> filters;

    public FilterChain() {
        this.filters = new ArrayList<Filter>();
    }

    public FilterChain(Filter ... filters) {
        this.filters = new ArrayList<Filter>(Arrays.asList(filters));
    }

    public FilterChain addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public FilterChain prependFilter(Filter filter) {
        this.filters.add(0, filter);
        return this;
    }

    public FilterChain setInputLabel(String label) {
        this.filters.get(0).addInputLabel(label);
        return this;
    }

    public FilterChain setOutputLabel(String label) {
        this.filters.get(this.filters.size() - 1).addOutputLabel(label);
        return this;
    }

    @Override
    public String getExpression() {
        return this.filters.stream().map(VideoFilter::getExpression).collect(Collectors.joining(","));
    }
}

