/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ws.schild.jave.AudioAttributes;
import ws.schild.jave.DefaultFFMPEGLocator;
import ws.schild.jave.EncoderException;
import ws.schild.jave.EncoderProgressListener;
import ws.schild.jave.EncodingAttributes;
import ws.schild.jave.FFMPEGExecutor;
import ws.schild.jave.FFMPEGLocator;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.MultimediaInfo;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.RBufferedReader;
import ws.schild.jave.VideoAttributes;
import ws.schild.jave.VideoFilter;
import ws.schild.jave.VideoSize;

public class Encoder {
    private static final Log LOG = LogFactory.getLog(Encoder.class);
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^\\s*([D ])([E ])\\s+([\\w,]+)\\s+.+$");
    private static final Pattern ENCODER_DECODER_PATTERN = Pattern.compile("^\\s*([AVS]).{5}\\s(\\S+).(.+)$", 2);
    private static final Pattern PROGRESS_INFO_PATTERN = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\\S+)\\s*", 2);
    private static final Pattern SUCCESS_PATTERN = Pattern.compile("^\\s*video\\:\\S+\\s+audio\\:\\S+\\s+subtitle\\:\\S+\\s+global headers\\:\\S+.*$", 2);
    private final FFMPEGLocator locator;

    public Encoder() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public Encoder(FFMPEGLocator locator) {
        this.locator = locator;
    }

    public String[] getAudioDecoders() throws EncoderException {
        return this.getCoders(false, true);
    }

    public String[] getAudioEncoders() throws EncoderException {
        return this.getCoders(true, true);
    }

    protected String[] getCoders(boolean encoder, boolean audio) throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument(encoder ? "-encoders" : "-decoders");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            String format = audio ? "A" : "V";
            boolean headerFound = false;
            boolean evaluateLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (headerFound) {
                    if (evaluateLine) {
                        Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            String audioVideoFlag = matcher.group(1);
                            if (!format.equals(audioVideoFlag)) continue;
                            String name = matcher.group(2);
                            res.add(name);
                            continue;
                        }
                        break;
                    }
                    evaluateLine = line.trim().equals("------");
                    continue;
                }
                if (!line.trim().equals(encoder ? "Encoders:" : "Decoders:")) continue;
                headerFound = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getVideoDecoders() throws EncoderException {
        return this.getCoders(false, false);
    }

    public String[] getVideoEncoders() throws EncoderException {
        return this.getCoders(true, false);
    }

    public String[] getSupportedEncodingFormats() throws EncoderException {
        return this.getSupportedCodingFormats(true);
    }

    protected String[] getSupportedCodingFormats(boolean encoding) throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            String ed = encoding ? "E" : "D";
            boolean headerFound = false;
            boolean evaluateLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (headerFound) {
                    if (evaluateLine) {
                        Matcher matcher = FORMAT_PATTERN.matcher(line);
                        if (!matcher.matches()) break;
                        String encoderFlag = matcher.group(encoding ? 2 : 1);
                        if (!ed.equals(encoderFlag)) continue;
                        String aux = matcher.group(3);
                        StringTokenizer st = new StringTokenizer(aux, ",");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken().trim();
                            if (res.contains(token)) continue;
                            res.add(token);
                        }
                        continue;
                    }
                    evaluateLine = line.trim().equals("--");
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                headerFound = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getSupportedDecodingFormats() throws EncoderException {
        return this.getSupportedCodingFormats(false);
    }

    private HashMap<String, String> parseProgressInfoLine(String line) {
        HashMap<String, String> table = null;
        Matcher m = PROGRESS_INFO_PATTERN.matcher(line);
        while (m.find()) {
            if (table == null) {
                table = new HashMap<String, String>();
            }
            String key = m.group(1);
            String value = m.group(2);
            table.put(key, value);
        }
        return table;
    }

    public void encode(MultimediaObject multimediaObject, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(multimediaObject, target, attributes, null);
    }

    public void encode(MultimediaObject multimediaObject, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String codec;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(multimediaObject.getFile().getAbsolutePath());
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (videoAttributes == null) {
            ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            codec = videoAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-vcodec");
                ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                ffmpeg.addArgument("-vtag");
                ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-vb");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                ffmpeg.addArgument("-r");
                ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                ffmpeg.addArgument("-s");
                ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + String.valueOf(size.getHeight()));
            }
            if (videoAttributes.isFaststart()) {
                ffmpeg.addArgument("-movflags");
                ffmpeg.addArgument("faststart");
            }
            if (videoAttributes.getX264Profile() != null) {
                ffmpeg.addArgument("-profile:v");
                ffmpeg.addArgument(videoAttributes.getX264Profile().getModeName());
            }
            if (videoAttributes.getVideoFilters().size() > 0) {
                for (VideoFilter videoFilter : videoAttributes.getVideoFilters()) {
                    ffmpeg.addArgument("-vf");
                    ffmpeg.addArgument(videoFilter.getExpression());
                }
            }
        }
        if (audioAttributes == null) {
            ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            codec = audioAttributes.getCodec();
            if (codec != null) {
                if (codec.equals("aac")) {
                    codec = "libvo_aacenc";
                }
                ffmpeg.addArgument("-acodec");
                ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-ab");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                ffmpeg.addArgument("-ac");
                ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                ffmpeg.addArgument("-ar");
                ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                ffmpeg.addArgument("-vol");
                ffmpeg.addArgument(String.valueOf(volume));
            }
        }
        if (formatAttribute != null) {
            ffmpeg.addArgument("-f");
            ffmpeg.addArgument(formatAttribute);
        }
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            String line;
            long duration;
            String lastWarning = null;
            long progress = 0L;
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            MultimediaInfo info = multimediaObject.getInfo();
            if (durationAttribute != null) {
                duration = Math.round(durationAttribute.floatValue() * 1000.0f);
            } else {
                duration = info.getDuration();
                if (offsetAttribute != null) {
                    duration -= (long)Math.round(offsetAttribute.floatValue() * 1000.0f);
                }
            }
            if (listener != null) {
                listener.sourceInfo(info);
            }
            int step = 0;
            int lineNR = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNR;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Input Line (" + lineNR + "): " + line));
                }
                if (line.startsWith("WARNING: ") && listener != null) {
                    listener.message(line);
                }
                switch (step) {
                    case 0: {
                        if (!line.startsWith("Input #0")) break;
                        step = 1;
                        break;
                    }
                    case 1: {
                        if (line.startsWith("Stream mapping:")) {
                            step = 2;
                            break;
                        }
                        if (line.startsWith("  ")) break;
                        throw new EncoderException(line);
                    }
                    case 2: {
                        if (line.startsWith("Output #0")) {
                            step = 3;
                            break;
                        }
                        if (line.startsWith("  ") || line.startsWith("Press [q]")) break;
                        throw new EncoderException(line);
                    }
                    case 3: {
                        if (line.startsWith("  ")) break;
                        if (line.startsWith("video:")) {
                            step = 4;
                            break;
                        }
                        if (line.startsWith("frame=") || line.startsWith("size=")) break;
                        throw new EncoderException(line);
                    }
                }
                if (!line.startsWith("frame=") && !line.startsWith("size=")) continue;
                try {
                    String time;
                    if ((line = line.trim()).length() <= 0) continue;
                    HashMap<String, String> table = this.parseProgressInfoLine(line);
                    if (table == null) {
                        if (listener != null) {
                            listener.message(line);
                        }
                        lastWarning = line;
                        continue;
                    }
                    if (listener != null && (time = table.get("time")) != null) {
                        int perm;
                        String[] dParts = time.split(":");
                        Double seconds = Double.parseDouble(dParts[dParts.length - 1]);
                        if (dParts.length > 1) {
                            seconds = seconds + Double.parseDouble(dParts[dParts.length - 2]) * 60.0;
                            if (dParts.length > 2) {
                                seconds = seconds + Double.parseDouble(dParts[dParts.length - 3]) * 60.0 * 60.0;
                            }
                        }
                        if ((perm = (int)Math.round(seconds * 1000.0 * 1000.0 / (double)duration)) > 1000) {
                            perm = 1000;
                        }
                        listener.progress(perm);
                    }
                    lastWarning = null;
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Error in progress parsing for line: " + line));
                }
            }
            if (lastWarning != null && !SUCCESS_PATTERN.matcher(lastWarning).matches()) {
                throw new EncoderException("No match for: " + SUCCESS_PATTERN + " in " + lastWarning);
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }
}

