/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.attachment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.DOMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyRegistry;
import org.w3c.dom.Document;

public class WSDLPolicyProcessor {
    private static final QName POLICY = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
    private static final QName POLICY_REF = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference");
    Definition wsdl4jDefinition = null;
    PolicyRegistry registry = null;
    DOMPolicyReader prdr = null;

    public WSDLPolicyProcessor(InputStream in) throws WSDLException {
        this(in, null);
    }

    public WSDLPolicyProcessor(InputStream in, PolicyRegistry registry) throws WSDLException {
        if (registry != null) {
            this.registry = registry;
        }
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            Document doc = builderFactory.newDocumentBuilder().parse(in);
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader reader = wsdlFactory.newWSDLReader();
            this.wsdl4jDefinition = reader.readWSDL(null, doc);
            registry = new PolicyRegistry();
            this.prdr = (DOMPolicyReader)PolicyFactory.getPolicyReader(3);
            this.processDefinition(this.wsdl4jDefinition);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Policy getEffectiveServicePolicy(QName service) {
        Service wsdl4jService = this.wsdl4jDefinition.getService(service);
        List policyList = this.getPoliciesAsExtElements(wsdl4jService.getExtensibilityElements());
        return this.getEffectivePolicy(policyList);
    }

    public Policy getEffectiveEndpointPolicy(QName service, String port) {
        Service wsdl4jService = this.wsdl4jDefinition.getService(service);
        if (wsdl4jService == null) {
            throw new IllegalArgumentException("invalid service name");
        }
        Port wsdl4jPort = wsdl4jService.getPort(port);
        if (wsdl4jPort == null) {
            throw new RuntimeException("invalid port name");
        }
        ArrayList policyList = new ArrayList();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jPort.getExtensibilityElements()));
        Binding wsdl4jBinding = wsdl4jPort.getBinding();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jBinding.getExtensibilityElements()));
        PortType wsdl4jPortType = wsdl4jBinding.getPortType();
        policyList.addAll(this.getPoliciesAsExtAttributes(wsdl4jPortType.getExtensionAttributes()));
        return this.getEffectivePolicy(policyList);
    }

    public Policy getEffectiveOperationPolicy(QName service, String portName, String opName) {
        Service wsdl4jService = this.wsdl4jDefinition.getService(service);
        if (wsdl4jService == null) {
            throw new IllegalArgumentException("invalid service name");
        }
        Port wsdl4jPort = wsdl4jService.getPort(portName);
        if (wsdl4jPort == null) {
            throw new IllegalArgumentException("invalid port name");
        }
        Binding wsdl4jBinding = wsdl4jPort.getBinding();
        BindingOperation wsdl4jBindingOperation = wsdl4jBinding.getBindingOperation(opName, null, null);
        if (wsdl4jBindingOperation == null) {
            throw new IllegalArgumentException("invalid binding name");
        }
        ArrayList policyList = new ArrayList();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jBindingOperation.getExtensibilityElements()));
        Operation wsdl4jOperation = wsdl4jBindingOperation.getOperation();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jOperation.getExtensibilityElements()));
        return this.getEffectivePolicy(policyList);
    }

    public Policy getEffectiveInputPolicy(QName service, String portName, String opName) {
        Service wsdl4jService = this.wsdl4jDefinition.getService(service);
        if (wsdl4jService == null) {
            throw new IllegalArgumentException("invalid service name");
        }
        Port wsdl4jPort = wsdl4jService.getPort(portName);
        if (wsdl4jPort == null) {
            throw new IllegalArgumentException("invalid port name");
        }
        Binding wsdl4jBinding = wsdl4jPort.getBinding();
        BindingOperation wsdl4jBindingOperation = wsdl4jBinding.getBindingOperation(opName, null, null);
        if (wsdl4jBindingOperation == null) {
            throw new IllegalArgumentException("invalid binding name");
        }
        ArrayList policyList = new ArrayList();
        BindingInput wsdl4jBindingInput = wsdl4jBindingOperation.getBindingInput();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jBindingInput.getExtensibilityElements()));
        Operation wsdl4jOperation = wsdl4jBindingOperation.getOperation();
        Input wsdl4jInput = wsdl4jOperation.getInput();
        policyList.addAll(this.getPoliciesAsExtAttributes(wsdl4jInput.getExtensionAttributes()));
        Message wsdl4jMessage = wsdl4jInput.getMessage();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jMessage.getExtensibilityElements()));
        return this.getEffectivePolicy(policyList);
    }

    public Policy getEffectiveOutputPolicy(QName service, String portName, String opName) {
        Service wsdl4jService = this.wsdl4jDefinition.getService(service);
        if (wsdl4jService == null) {
            throw new IllegalArgumentException("invalid service name");
        }
        Port wsdl4jPort = wsdl4jService.getPort(portName);
        if (wsdl4jPort == null) {
            throw new IllegalArgumentException("invalid port name");
        }
        Binding wsdl4jBinding = wsdl4jPort.getBinding();
        BindingOperation wsdl4jBindingOperation = wsdl4jBinding.getBindingOperation(opName, null, null);
        if (wsdl4jBindingOperation == null) {
            throw new IllegalArgumentException("invalid binding name");
        }
        ArrayList policyList = new ArrayList();
        BindingOutput wsdl4jBindingOutput = wsdl4jBindingOperation.getBindingOutput();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jBindingOutput.getExtensibilityElements()));
        Operation wsdl4jOperation = wsdl4jBindingOperation.getOperation();
        Output wsdl4jOutput = wsdl4jOperation.getOutput();
        policyList.addAll(this.getPoliciesAsExtAttributes(wsdl4jOutput.getExtensionAttributes()));
        Message wsdl4jMessage = wsdl4jOutput.getMessage();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jMessage.getExtensibilityElements()));
        return this.getEffectivePolicy(policyList);
    }

    public Policy getEffectiveFaultPolicy(QName service, String portName, String opName) {
        Service wsdl4jService = this.wsdl4jDefinition.getService(service);
        if (wsdl4jService == null) {
            throw new IllegalArgumentException("invalid service name");
        }
        Port wsdl4jPort = wsdl4jService.getPort(portName);
        if (wsdl4jPort == null) {
            throw new IllegalArgumentException("invalid port name");
        }
        Binding wsdl4jBinding = wsdl4jPort.getBinding();
        BindingOperation wsdl4jBindingOperation = wsdl4jBinding.getBindingOperation(opName, null, null);
        if (wsdl4jBindingOperation == null) {
            throw new IllegalArgumentException("invalid binding name");
        }
        ArrayList policyList = new ArrayList();
        Map wsdl4jBindingFaults = wsdl4jBindingOperation.getBindingFaults();
        Iterator iterator = wsdl4jBindingFaults.values().iterator();
        if (!iterator.hasNext()) {
            throw new RuntimeException("can't find any faults");
        }
        BindingFault wsdl4jBindingFault = (BindingFault)iterator.next();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jBindingFault.getExtensibilityElements()));
        Operation wsdl4jOperation = wsdl4jBindingOperation.getOperation();
        Fault wsdl4jFault = wsdl4jOperation.getFault(wsdl4jBindingFault.getName());
        policyList.addAll(this.getPoliciesAsExtAttributes(wsdl4jFault.getExtensionAttributes()));
        Message wsdl4jMessage = wsdl4jFault.getMessage();
        policyList.addAll(this.getPoliciesAsExtElements(wsdl4jMessage.getExtensibilityElements()));
        return this.getEffectivePolicy(policyList);
    }

    private Policy getEffectivePolicy(List policyList) {
        AbstractAssertion policy = null;
        Iterator iterator = policyList.iterator();
        while (iterator.hasNext()) {
            Object policyElement = iterator.next();
            if (policyElement instanceof Policy) {
                policy = policy == null ? (Policy)policyElement : (Policy)((Policy)policy).merge((Policy)policyElement, this.registry);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            policy = policy == null ? (Policy)((PolicyReference)policyElement).normalize(this.registry) : (Policy)((Policy)policy).merge((PolicyReference)policyElement, this.registry);
        }
        if (!policy.isNormalized()) {
            policy = (Policy)((Policy)policy).normalize(this.registry);
        }
        return policy;
    }

    private void processDefinition(Definition wsdl4jDefinition) {
        this.registerPoliciesAsExtElements(wsdl4jDefinition.getExtensibilityElements());
    }

    private void registerPoliciesAsExtElements(List extElements) {
        Iterator iterator = extElements.iterator();
        while (iterator.hasNext()) {
            Policy p;
            UnknownExtensibilityElement unknown;
            Object extElement = iterator.next();
            if (!(extElement instanceof UnknownExtensibilityElement) || !POLICY.equals((unknown = (UnknownExtensibilityElement)extElement).getElementType()) || (p = this.prdr.readPolicy(unknown.getElement())).getPolicyURI() == null) continue;
            this.registry.register(p.getPolicyURI(), p);
        }
    }

    private List getPoliciesAsExtElements(List extElements) {
        ArrayList<Assertion> policyList = new ArrayList<Assertion>();
        Iterator iterator = extElements.iterator();
        while (iterator.hasNext()) {
            Object extElement = iterator.next();
            if (!(extElement instanceof UnknownExtensibilityElement)) continue;
            UnknownExtensibilityElement unknown = (UnknownExtensibilityElement)extElement;
            if (POLICY.equals(unknown.getElementType())) {
                Policy p = this.prdr.readPolicy(unknown.getElement());
                policyList.add(p);
                continue;
            }
            if (!POLICY_REF.equals(unknown.getElementType())) continue;
            PolicyReference ref = this.prdr.readPolicyReference(unknown.getElement());
            policyList.add(ref);
        }
        return policyList;
    }

    private List getPoliciesAsExtAttributes(Map extAttributes) {
        ArrayList<Policy> policyList = new ArrayList<Policy>();
        QName PolicyURIs = (QName)extAttributes.get(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyURIs"));
        if (PolicyURIs != null) {
            String[] URIs = PolicyURIs.getLocalPart().split(" ");
            for (int i = 0; i < URIs.length; ++i) {
                Policy policy = this.registry.lookup(URIs[i]);
                if (policy == null) {
                    throw new RuntimeException("cannot resolve : " + URIs[i]);
                }
                policyList.add(policy);
            }
        }
        return policyList;
    }
}

