/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.CompositeAssertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.util.PolicyRegistry;

public class XorCompositeAssertion
extends AbstractAssertion
implements CompositeAssertion {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public void addTerm(Assertion assertion) {
        if (!(this.isNormalized() && assertion instanceof AndCompositeAssertion && ((AndCompositeAssertion)assertion).isNormalized())) {
            this.setNormalized(false);
        }
        super.addTerm(assertion);
    }

    public Assertion normalize(PolicyRegistry reg) {
        this.log.debug((Object)"Enter: XorCompositeAssertion::normalize");
        if (this.isNormalized()) {
            return this;
        }
        XorCompositeAssertion XOR = new XorCompositeAssertion();
        if (this.isEmpty()) {
            XOR.setNormalized(true);
            return XOR;
        }
        Iterator terms = this.getTerms().iterator();
        while (terms.hasNext()) {
            Assertion wrapper;
            Assertion term = (Assertion)terms.next();
            Assertion assertion = term = term instanceof Policy ? term : term.normalize(reg);
            if (term instanceof Policy) {
                wrapper = new AndCompositeAssertion();
                wrapper.addTerms(((Policy)term).getTerms());
                wrapper = wrapper.normalize(reg);
                if (wrapper instanceof AndCompositeAssertion) {
                    XOR.addTerm(wrapper);
                    continue;
                }
                XOR.addTerms(((XorCompositeAssertion)wrapper).getTerms());
                continue;
            }
            if (term instanceof PrimitiveAssertion) {
                wrapper = new AndCompositeAssertion();
                wrapper.addTerm(term);
                XOR.addTerm(wrapper);
                continue;
            }
            if (term instanceof XorCompositeAssertion) {
                XOR.addTerms(((XorCompositeAssertion)term).getTerms());
                continue;
            }
            if (!(term instanceof AndCompositeAssertion)) continue;
            XOR.addTerm(term);
        }
        XOR.setNormalized(true);
        return XOR;
    }

    public Assertion intersect(Assertion assertion, PolicyRegistry reg) {
        XorCompositeAssertion normalizedMe;
        this.log.debug((Object)"Enter: XorCompositeAssertion::intersect");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof XorCompositeAssertion)) {
            return normalizedMe.intersect(assertion, reg);
        }
        Assertion target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        short type = target.getType();
        switch (type) {
            case 4: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).intersect(target));
                return nPOLICY;
            }
            case 3: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    AndCompositeAssertion AND = (AndCompositeAssertion)iterator.next();
                    Iterator iterator2 = target.getTerms().iterator();
                    while (iterator2.hasNext()) {
                        Assertion asser = AND.intersect((AndCompositeAssertion)iterator2.next());
                        if (!(asser instanceof AndCompositeAssertion)) continue;
                        nXOR.addTerm(asser);
                    }
                }
                return nXOR;
            }
            case 2: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    Assertion asser = ((AndCompositeAssertion)iterator.next()).intersect(target);
                    if (!(asser instanceof AndCompositeAssertion)) continue;
                    nXOR.addTerm(asser);
                }
                return nXOR;
            }
            case 1: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    Assertion asser = ((AndCompositeAssertion)iterator.next()).intersect(target);
                    if (!(asser instanceof AndCompositeAssertion)) continue;
                    nXOR.addTerm(asser);
                }
                return nXOR;
            }
        }
        throw new IllegalArgumentException("intersect for assertion type " + target.getClass().getName() + " not defined");
    }

    public Assertion merge(Assertion assertion, PolicyRegistry reg) {
        XorCompositeAssertion normalizedMe;
        this.log.debug((Object)"Enter: XorCompositeAssertion::merge");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof XorCompositeAssertion)) {
            return normalizedMe.merge(assertion, reg);
        }
        Assertion target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        short type = target.getType();
        switch (type) {
            case 4: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(normalizedMe.merge((Assertion)target.getTerms().get(0)));
                return nPOLICY;
            }
            case 3: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    AndCompositeAssertion AND = (AndCompositeAssertion)iterator.next();
                    Iterator iterator2 = target.getTerms().iterator();
                    while (iterator2.hasNext()) {
                        nXOR.addTerm(AND.merge((Assertion)iterator2.next()));
                    }
                }
                return nXOR;
            }
            case 2: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    nXOR.addTerm(((AndCompositeAssertion)iterator.next()).merge(target));
                }
                return nXOR;
            }
            case 1: {
                XorCompositeAssertion nXOR = new XorCompositeAssertion();
                Iterator iterator = normalizedMe.getTerms().iterator();
                while (iterator.hasNext()) {
                    nXOR.addTerm(((AndCompositeAssertion)iterator.next()).merge(target));
                }
                return nXOR;
            }
        }
        throw new IllegalArgumentException("merge is not defined for " + target.getClass().getName() + " type assertions");
    }

    public final short getType() {
        return 3;
    }
}

