/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.util.StAXUtils;

public abstract class OMNodeImpl
implements OMNode,
OMNodeEx {
    protected OMContainerEx parent;
    protected OMNodeImpl nextSibling;
    protected OMNodeImpl previousSibling;
    protected OMXMLParserWrapper builder;
    protected boolean done = false;
    protected int nodeType;
    protected OMFactory factory;

    public OMNodeImpl(OMFactory factory) {
        this.factory = factory;
    }

    public OMNodeImpl(OMContainer parent, OMFactory factory) {
        if (parent != null) {
            this.parent = (OMContainerEx)parent;
            parent.addChild((OMNode)this);
        }
        this.factory = factory;
    }

    public OMContainer getParent() {
        return this.parent;
    }

    public void setParent(OMContainer element) {
        if (this.parent == element) {
            return;
        }
        if (element != null) {
            if (this.parent != null) {
                this.detach();
            }
            this.parent = (OMContainerEx)element;
        } else {
            this.parent = null;
        }
    }

    public OMNode getNextOMSibling() throws OMException {
        if (this.nextSibling == null && this.parent != null && !this.parent.isComplete()) {
            this.parent.buildNext();
        }
        return this.nextSibling;
    }

    public void setNextOMSibling(OMNode node) {
        this.nextSibling = (OMNodeImpl)node;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void setComplete(boolean state) {
        this.done = state;
    }

    public OMNode detach() throws OMException {
        if (this.parent == null) {
            throw new OMException("Elements that doesn't have a parent can not be detached");
        }
        OMNodeImpl nextSibling = (OMNodeImpl)this.getNextOMSibling();
        if (this.previousSibling == null) {
            this.parent.setFirstChild((OMNode)nextSibling);
        } else {
            ((OMNodeEx)this.getPreviousOMSibling()).setNextOMSibling((OMNode)nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousOMSibling(this.getPreviousOMSibling());
        }
        if (this.parent instanceof OMElementImpl && ((OMElementImpl)this.parent).lastChild == this) {
            ((OMElementImpl)this.parent).lastChild = this.getPreviousOMSibling();
        }
        this.parent = null;
        return this;
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException();
        }
        ((OMNodeEx)sibling).setParent((OMContainer)this.parent);
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            if (this.nextSibling == null) {
                this.getNextOMSibling();
            }
            siblingImpl.setPreviousOMSibling(this);
            if (this.nextSibling != null) {
                this.nextSibling.setPreviousOMSibling(sibling);
            }
            ((OMNodeEx)sibling).setNextOMSibling((OMNode)this.nextSibling);
            this.nextSibling = siblingImpl;
        }
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException();
        }
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            siblingImpl.nextSibling = this;
            if (this.previousSibling == null) {
                this.parent.setFirstChild((OMNode)siblingImpl);
                siblingImpl.previousSibling = null;
            } else {
                siblingImpl.setParent((OMContainer)this.parent);
                this.previousSibling.setNextOMSibling(siblingImpl);
                siblingImpl.setPreviousOMSibling(this.previousSibling);
            }
            this.previousSibling = siblingImpl;
        }
    }

    public int getType() {
        return this.nodeType;
    }

    public void setType(int nodeType) throws OMException {
        this.nodeType = nodeType;
    }

    public OMNode getPreviousOMSibling() {
        return this.previousSibling;
    }

    public void setPreviousOMSibling(OMNode previousSibling) {
        this.previousSibling = (OMNodeImpl)previousSibling;
    }

    public void build() throws OMException {
        while (!this.done) {
            this.builder.next();
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerialize((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerializeAndConsume((XMLStreamWriter)writer);
        writer.flush();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        throw new RuntimeException("Not implemented yet!");
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        throw new RuntimeException("Not implemented yet!");
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        this.serialize(StAXUtils.createXMLStreamWriter((OutputStream)output));
    }

    public void serialize(Writer writer) throws XMLStreamException {
        this.serialize(StAXUtils.createXMLStreamWriter((Writer)writer));
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(StAXUtils.createXMLStreamWriter((OutputStream)output));
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        this.serializeAndConsume(StAXUtils.createXMLStreamWriter((Writer)writer));
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        writer.setOutputFormat(format);
        this.internalSerialize((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerializeAndConsume((XMLStreamWriter)writer);
        writer.flush();
    }

    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        writer.setOutputFormat(format);
        this.internalSerializeAndConsume((XMLStreamWriter)writer);
        writer.flush();
    }

    public OMFactory getOMFactory() {
        return this.factory;
    }
}

