/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.impl.llom;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.commons.attachments.DataHandlerUtils;
import org.apache.ws.commons.om.OMAttribute;
import org.apache.ws.commons.om.OMConstants;
import org.apache.ws.commons.om.OMContainer;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMException;
import org.apache.ws.commons.om.OMFactory;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMText;
import org.apache.ws.commons.om.OMXMLParserWrapper;
import org.apache.ws.commons.om.impl.OMOutputImpl;
import org.apache.ws.commons.om.impl.llom.OMAttributeImpl;
import org.apache.ws.commons.om.impl.llom.OMNamespaceImpl;
import org.apache.ws.commons.om.impl.llom.OMNodeImpl;
import org.apache.ws.commons.om.impl.mtom.MTOMStAXSOAPModelBuilder;
import org.apache.ws.commons.om.util.Base64;
import org.apache.ws.commons.om.util.UUIDGenerator;

public class OMTextImpl
extends OMNodeImpl
implements OMText,
OMConstants {
    protected String value = null;
    protected String mimeType;
    protected boolean optimize = false;
    protected boolean isBinary = false;
    private String contentID = null;
    private Object dataHandlerObject = null;
    protected OMNamespace ns = null;
    protected String localName = "Include";
    protected OMAttribute attribute;

    public OMTextImpl(String s, OMFactory factory) {
        super(factory);
        this.value = s;
        this.nodeType = 4;
        this.ns = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop", factory);
    }

    public OMTextImpl(String s, int nodeType, OMFactory factory) {
        super(factory);
        this.value = s;
        this.nodeType = nodeType;
        this.ns = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop", factory);
    }

    public OMTextImpl(OMElement parent, String text, OMFactory factory) {
        super((OMContainer)parent, factory);
        this.value = text;
        this.done = true;
        this.nodeType = 4;
        this.ns = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop", factory);
    }

    public OMTextImpl(OMElement parent, String text, int nodeType, OMFactory factory) {
        super((OMContainer)parent, factory);
        this.value = text;
        this.done = true;
        this.nodeType = nodeType;
        this.ns = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop", factory);
    }

    public OMTextImpl(String s, String mimeType, boolean optimize, OMFactory factory) {
        this(null, s, mimeType, optimize, factory);
    }

    public OMTextImpl(OMElement parent, String s, String mimeType, boolean optimize, OMFactory factory) {
        this(parent, s, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = true;
        this.done = true;
        this.nodeType = 4;
    }

    public OMTextImpl(Object dataHandler, OMFactory factory) {
        this(dataHandler, true, factory);
    }

    public OMTextImpl(Object dataHandler, boolean optimize, OMFactory factory) {
        super(factory);
        this.dataHandlerObject = dataHandler;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
        this.nodeType = 4;
        this.ns = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop", factory);
    }

    public OMTextImpl(String contentID, OMElement parent, OMXMLParserWrapper builder, OMFactory factory) {
        super((OMContainer)parent, factory);
        this.contentID = contentID;
        this.optimize = true;
        this.isBinary = true;
        this.builder = builder;
        this.nodeType = 4;
        this.ns = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop", factory);
    }

    public void serialize(OMOutputImpl omOutput) throws XMLStreamException {
        this.serializeLocal(omOutput);
    }

    private void writeOutput(OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        int type = this.getType();
        if (type == 4 || type == 6) {
            writer.writeCharacters(this.getText());
        } else if (type == 12) {
            writer.writeCData(this.getText());
        } else if (type == 9) {
            writer.writeEntityRef(this.getText());
        }
    }

    public String getText() throws OMException {
        if (this.value != null) {
            return this.value;
        }
        try {
            InputStream inStream = this.getInputStream();
            StringBuffer text = new StringBuffer();
            do {
                int len;
                byte[] data = new byte[1024];
                while ((len = inStream.read(data)) > 0) {
                    byte[] temp = new byte[len];
                    System.arraycopy(data, 0, temp, 0, len);
                    text.append(Base64.encode((byte[])temp));
                }
            } while (inStream.available() > 0);
            return text.toString();
        }
        catch (Exception e) {
            throw new OMException((Throwable)e);
        }
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimize(boolean value) {
        this.optimize = value;
        if (value) {
            this.isBinary = true;
        }
    }

    public Object getDataHandler() {
        if (this.value != null & this.isBinary) {
            return DataHandlerUtils.getDataHandlerFromText((String)this.value, (String)this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            if (this.contentID == null) {
                throw new RuntimeException("ContentID is null");
            }
            this.dataHandlerObject = ((MTOMStAXSOAPModelBuilder)this.builder).getDataHandler(this.contentID);
        }
        return this.dataHandlerObject;
    }

    public String getLocalName() {
        return this.localName;
    }

    public InputStream getInputStream() throws OMException {
        if (this.isBinary) {
            InputStream inStream;
            if (this.dataHandlerObject == null) {
                this.getDataHandler();
            }
            DataHandler dataHandler = (DataHandler)this.dataHandlerObject;
            try {
                inStream = dataHandler.getDataSource().getInputStream();
            }
            catch (IOException e) {
                throw new OMException("Cannot get InputStream from DataHandler." + e);
            }
            return inStream;
        }
        throw new OMException("Unsupported Operation");
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UUIDGenerator.getUUID() + "@apache.org";
        }
        return this.contentID;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void serializeAndConsume(OMOutputImpl omOutput) throws XMLStreamException {
        this.serializeLocal(omOutput);
    }

    private void serializeLocal(OMOutputImpl omOutput) throws XMLStreamException {
        if (!this.isBinary) {
            this.writeOutput(omOutput);
        } else if (omOutput.isOptimized()) {
            if (this.contentID == null) {
                this.contentID = omOutput.getNextContentId();
            }
            this.attribute = new OMAttributeImpl("href", new OMNamespaceImpl("", "", this.factory), "cid:" + this.getContentID(), this.factory);
            this.serializeStartpart(omOutput);
            omOutput.writeOptimized((OMText)this);
            omOutput.getXmlStreamWriter().writeEndElement();
        } else {
            omOutput.getXmlStreamWriter().writeCharacters(this.getText());
        }
    }

    private void serializeStartpart(OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        if (this.ns != null) {
            String nameSpaceName = this.ns.getName();
            String writer_prefix = writer.getPrefix(nameSpaceName);
            String prefix = this.ns.getPrefix();
            if (nameSpaceName != null) {
                if (writer_prefix != null) {
                    writer.writeStartElement(nameSpaceName, this.getLocalName());
                } else if (prefix != null) {
                    writer.writeStartElement(prefix, this.getLocalName(), nameSpaceName);
                    writer.setPrefix(prefix, nameSpaceName);
                } else {
                    writer.writeStartElement(nameSpaceName, this.getLocalName());
                    writer.writeDefaultNamespace(nameSpaceName);
                    writer.setDefaultNamespace(nameSpaceName);
                }
            } else {
                writer.writeStartElement(this.getLocalName());
            }
        } else {
            writer.writeStartElement(this.getLocalName());
        }
        OMTextImpl.serializeAttribute(this.attribute, omOutput);
        OMTextImpl.serializeNamespace(this.ns, omOutput);
    }

    static void serializeAttribute(OMAttribute attr, OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        OMNamespace ns = attr.getNamespace();
        if (ns != null) {
            String prefix = ns.getPrefix();
            String namespaceName = ns.getName();
            if (prefix != null) {
                writer.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            writer.writeAttribute(attr.getLocalName(), attr.getAttributeValue());
        }
    }

    static void serializeNamespace(OMNamespace namespace, OMOutputImpl omOutput) throws XMLStreamException {
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        if (namespace != null) {
            String uri = namespace.getName();
            String ns_prefix = namespace.getPrefix();
            writer.writeNamespace(ns_prefix, namespace.getName());
            writer.setPrefix(ns_prefix, uri);
        }
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        } else {
            this.builder.discard((OMElement)this.parent);
        }
    }
}

