/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.impl.llom;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.commons.om.OMAttribute;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMNode;
import org.apache.ws.commons.om.impl.OMNodeEx;
import org.apache.ws.commons.om.impl.OMOutputImpl;
import org.apache.ws.commons.om.impl.serialize.StreamingOMSerializer;

public class OMSerializerUtil {
    static long nsCounter = 0L;

    public static void serializeEndpart(OMOutputImpl omOutput) throws XMLStreamException {
        omOutput.getXmlStreamWriter().writeEndElement();
    }

    public static void serializeAttribute(OMAttribute attr, OMOutputImpl omOutput) throws XMLStreamException {
        OMNamespace ns = attr.getNamespace();
        String prefix = null;
        String namespaceName = null;
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        if (ns != null) {
            prefix = ns.getPrefix();
            namespaceName = ns.getName();
            if (prefix != null) {
                writer.writeAttribute(prefix, namespaceName, attr.getLocalName(), attr.getAttributeValue());
            } else {
                writer.writeAttribute(namespaceName, attr.getLocalName(), attr.getAttributeValue());
            }
        } else {
            writer.writeAttribute(attr.getLocalName(), attr.getAttributeValue());
        }
    }

    public static void serializeNamespace(OMNamespace namespace, OMOutputImpl omOutput) throws XMLStreamException {
        if (namespace != null) {
            XMLStreamWriter writer = omOutput.getXmlStreamWriter();
            String uri = namespace.getName();
            String prefix = writer.getPrefix(uri);
            String ns_prefix = namespace.getPrefix();
            if (uri != null && !"".equals(uri)) {
                if (prefix == null) {
                    ns_prefix = ns_prefix == null ? OMSerializerUtil.getNextNSPrefix() : ns_prefix;
                    writer.writeNamespace(ns_prefix, uri);
                } else if (ns_prefix != null && !ns_prefix.equals(prefix)) {
                    writer.writeNamespace(ns_prefix, uri);
                }
            }
        }
    }

    public static void serializeStartpart(OMElement element, OMOutputImpl omOutput) throws XMLStreamException {
        String nameSpaceName = null;
        String writer_prefix = null;
        String prefix = null;
        XMLStreamWriter writer = omOutput.getXmlStreamWriter();
        if (element.getNamespace() != null) {
            nameSpaceName = element.getNamespace().getName();
            writer_prefix = writer.getPrefix(nameSpaceName);
            prefix = element.getNamespace().getPrefix();
            if (nameSpaceName != null) {
                if (writer_prefix != null) {
                    writer.writeStartElement(nameSpaceName, element.getLocalName());
                } else {
                    prefix = prefix == null ? "" : prefix;
                    writer.writeStartElement(prefix, element.getLocalName(), nameSpaceName);
                    writer.writeNamespace(prefix, nameSpaceName);
                    writer.setPrefix(prefix, nameSpaceName);
                }
            } else {
                writer.writeStartElement(element.getLocalName());
            }
        } else {
            writer.writeStartElement(element.getLocalName());
            if (writer.getNamespaceContext().getNamespaceURI("") != null) {
                writer.writeDefaultNamespace("");
            }
        }
        OMSerializerUtil.serializeNamespaces(element, omOutput);
        OMSerializerUtil.serializeAttributes(element, omOutput);
    }

    public static void serializeNamespaces(OMElement element, OMOutputImpl omOutput) throws XMLStreamException {
        Iterator namespaces = element.getAllDeclaredNamespaces();
        if (namespaces != null) {
            while (namespaces.hasNext()) {
                OMSerializerUtil.serializeNamespace((OMNamespace)namespaces.next(), omOutput);
            }
        }
    }

    public static void serializeAttributes(OMElement element, OMOutputImpl omOutput) throws XMLStreamException {
        if (element.getAllAttributes() != null) {
            Iterator attributesList = element.getAllAttributes();
            while (attributesList.hasNext()) {
                OMSerializerUtil.serializeAttribute((OMAttribute)attributesList.next(), omOutput);
            }
        }
    }

    public static void serializeNormal(OMElement element, OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        if (cache) {
            element.build();
        }
        OMSerializerUtil.serializeStartpart(element, omOutput);
        OMNode firstChild = element.getFirstOMChild();
        if (firstChild != null) {
            if (cache) {
                ((OMNodeEx)firstChild).serialize(omOutput);
            } else {
                ((OMNodeEx)firstChild).serializeAndConsume(omOutput);
            }
        }
        OMSerializerUtil.serializeEndpart(omOutput);
    }

    public static void serializeByPullStream(OMElement element, OMOutputImpl omOutput) throws XMLStreamException {
        OMSerializerUtil.serializeByPullStream(element, omOutput, false);
    }

    public static void serializeByPullStream(OMElement element, OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        StreamingOMSerializer streamingOMSerializer = new StreamingOMSerializer();
        if (cache) {
            streamingOMSerializer.serialize(element.getXMLStreamReader(), omOutput);
        } else {
            XMLStreamReader xmlStreamReaderWithoutCaching = element.getXMLStreamReaderWithoutCaching();
            streamingOMSerializer.serialize(xmlStreamReaderWithoutCaching, omOutput);
        }
    }

    public static String getNextNSPrefix() {
        return "axis2ns" + ++nsCounter % Long.MAX_VALUE;
    }
}

