/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.impl.builder;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.ws.commons.om.OMAbstractFactory;
import org.apache.ws.commons.om.OMComment;
import org.apache.ws.commons.om.OMContainer;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMException;
import org.apache.ws.commons.om.OMFactory;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMNode;
import org.apache.ws.commons.om.OMProcessingInstruction;
import org.apache.ws.commons.om.OMText;
import org.apache.ws.commons.om.impl.OMContainerEx;
import org.apache.ws.commons.om.impl.OMNodeEx;
import org.apache.ws.commons.om.impl.builder.StAXBuilder;

public class StAXOMBuilder
extends StAXBuilder {
    private boolean doDebug = false;
    private static int nsCount = 0;

    public StAXOMBuilder(OMFactory ombuilderFactory, XMLStreamReader parser) {
        super(ombuilderFactory, parser);
        this.document = ombuilderFactory.createOMDocument(this);
    }

    public StAXOMBuilder(String filePath) throws XMLStreamException, FileNotFoundException {
        this(XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(filePath)));
    }

    public StAXOMBuilder(InputStream inStream) throws XMLStreamException {
        this(XMLInputFactory.newInstance().createXMLStreamReader(inStream));
    }

    public StAXOMBuilder(XMLStreamReader parser) {
        super(parser);
        this.omfactory = OMAbstractFactory.getOMFactory();
        this.document = this.omfactory.createOMDocument(this);
    }

    protected OMNode createOMElement() throws OMException {
        OMElement node;
        String elementName = this.parser.getLocalName();
        if (this.lastNode == null) {
            node = this.omfactory.createOMElement(elementName, null, this.document, this);
        } else if (this.lastNode.isComplete()) {
            node = this.omfactory.createOMElement(elementName, null, this.lastNode.getParent(), this);
            ((OMNodeEx)this.lastNode).setNextOMSibling(node);
            ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
        } else {
            OMElement e = (OMElement)this.lastNode;
            node = this.omfactory.createOMElement(elementName, null, (OMElement)this.lastNode, this);
            e.setFirstChild(node);
        }
        this.processNamespaceData(node, false);
        this.processAttributes(node);
        node.setLineNumber(this.parser.getLocation().getLineNumber());
        return node;
    }

    protected OMNode createComment() throws OMException {
        OMComment node = this.lastNode == null ? this.omfactory.createOMComment(this.document, this.parser.getText()) : (this.lastNode.isComplete() ? this.omfactory.createOMComment(this.lastNode.getParent(), this.parser.getText()) : this.omfactory.createOMComment((OMElement)this.lastNode, this.parser.getText()));
        return node;
    }

    protected OMNode createDTD() throws OMException {
        if (!this.parser.hasText()) {
            return null;
        }
        return this.omfactory.createOMDocType(this.document, this.parser.getText());
    }

    protected OMNode createPI() throws OMException {
        String target = this.parser.getPITarget();
        String data = this.parser.getPIData();
        OMProcessingInstruction node = this.lastNode == null ? this.omfactory.createOMProcessingInstruction(this.document, target, data) : (this.lastNode.isComplete() ? this.omfactory.createOMProcessingInstruction(this.lastNode.getParent(), target, data) : (this.lastNode instanceof OMText ? this.omfactory.createOMProcessingInstruction(this.lastNode.getParent(), target, data) : this.omfactory.createOMProcessingInstruction((OMContainer)((Object)this.lastNode), target, data)));
        return node;
    }

    protected void endElement() {
        if (this.lastNode.isComplete()) {
            OMElement parent = (OMElement)this.lastNode.getParent();
            ((OMNodeEx)((Object)parent)).setComplete(true);
            this.lastNode = parent;
        } else {
            OMElement e = (OMElement)this.lastNode;
            ((OMNodeEx)((Object)e)).setComplete(true);
        }
    }

    public int next() throws OMException {
        try {
            if (this.done) {
                throw new OMException();
            }
            int token = this.parser.next();
            if (!this.cache) {
                return token;
            }
            switch (token) {
                case 1: {
                    if (this.doDebug) {
                        System.out.println("START_ELEMENT: " + this.parser.getName() + ":" + this.parser.getLocalName());
                    }
                    this.lastNode = this.createOMElement();
                    break;
                }
                case 7: {
                    this.document.setXMLVersion(this.parser.getVersion());
                    this.document.setCharsetEncoding(this.parser.getEncoding());
                    this.document.setStandalone(this.parser.isStandalone() ? "yes" : "no");
                    if (!this.doDebug) break;
                    System.out.println("START_DOCUMENT: ");
                    break;
                }
                case 4: {
                    if (this.doDebug) {
                        System.out.println("CHARACTERS: [" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(4);
                    break;
                }
                case 12: {
                    if (this.doDebug) {
                        System.out.println("CDATA: [" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(12);
                    break;
                }
                case 2: {
                    if (this.doDebug) {
                        System.out.println("END_ELEMENT: " + this.parser.getName() + ":" + this.parser.getLocalName());
                    }
                    this.endElement();
                    break;
                }
                case 8: {
                    if (this.doDebug) {
                        System.out.println("END_DOCUMENT: ");
                    }
                    this.done = true;
                    ((OMContainerEx)((Object)this.document)).setComplete(true);
                    break;
                }
                case 6: {
                    if (this.doDebug) {
                        System.out.println("SPACE: [" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(6);
                    break;
                }
                case 5: {
                    if (this.doDebug) {
                        System.out.println("COMMENT: [" + this.parser.getText() + "]");
                    }
                    this.createComment();
                    break;
                }
                case 11: {
                    if (this.doDebug) {
                        System.out.println("DTD: [" + this.parser.getText() + "]");
                    }
                    this.createDTD();
                    break;
                }
                case 3: {
                    if (this.doDebug) {
                        System.out.println("PROCESSING_INSTRUCTION: [" + this.parser.getPITarget() + "][" + this.parser.getPIData() + "]");
                    }
                    this.createPI();
                    break;
                }
                case 9: {
                    if (this.doDebug) {
                        System.out.println("ENTITY_REFERENCE: " + this.parser.getLocalName() + "[" + this.parser.getText() + "]");
                    }
                    this.lastNode = this.createOMText(9);
                    break;
                }
                default: {
                    throw new OMException();
                }
            }
            return token;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OMException(e);
        }
    }

    public OMElement getDocumentElement() {
        return this.document.getOMDocumentElement();
    }

    protected void processNamespaceData(OMElement node, boolean isSOAPElement) {
        String namespaceURI = this.parser.getNamespaceURI();
        String prefix = this.parser.getPrefix();
        OMNamespace namespace = null;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            namespace = node.findNamespace(namespaceURI, prefix = prefix == null ? "" : prefix);
            if (namespace == null) {
                namespace = node.declareNamespace(namespaceURI, prefix);
            }
            node.setNamespace(namespace);
        }
        int namespaceCount = this.parser.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String nsprefix = this.parser.getNamespacePrefix(i);
            String string = nsprefix = nsprefix == null ? "" : nsprefix;
            if (nsprefix.equals(prefix)) continue;
            node.declareNamespace(this.parser.getNamespaceURI(i), this.parser.getNamespacePrefix(i));
        }
    }

    public void setDoDebug(boolean doDebug) {
        this.doDebug = doDebug;
    }

    protected String createPrefix() {
        return "ns" + nsCount++;
    }
}

