/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.impl;

import java.io.OutputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.commons.om.OMOutputFormat;
import org.apache.ws.commons.om.OMText;
import org.apache.ws.commons.om.impl.MIMEOutputUtils;

public class OMOutputImpl {
    private XMLStreamWriter xmlWriter;
    private OutputStream outStream;
    private LinkedList binaryNodeList = new LinkedList();
    private StringWriter bufferedSOAPBody;
    private OMOutputFormat format = new OMOutputFormat();

    public OMOutputImpl(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public OMOutputImpl(OutputStream outStream, OMOutputFormat format) throws XMLStreamException, FactoryConfigurationError {
        this.format = format;
        this.outStream = outStream;
        if (format.getCharSetEncoding() == null) {
            format.setCharSetEncoding("utf-8");
        }
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (format.isOptimized()) {
            this.bufferedSOAPBody = new StringWriter();
            this.xmlWriter = factory.createXMLStreamWriter(this.bufferedSOAPBody);
        } else {
            this.xmlWriter = factory.createXMLStreamWriter(outStream, format.getCharSetEncoding());
        }
    }

    public void flush() throws XMLStreamException {
        this.xmlWriter.flush();
        if (this.format.isOptimized()) {
            String SOAPContentType = this.format.isSOAP11() ? "text/xml" : "application/soap+xml";
            MIMEOutputUtils.complete(this.outStream, this.bufferedSOAPBody, this.binaryNodeList, this.format.getMimeBoundary(), this.format.getRootContentId(), this.format.getCharSetEncoding(), SOAPContentType);
        }
    }

    public boolean isOptimized() {
        return this.format.isOptimized();
    }

    public String getContentType() {
        return this.format.getContentType();
    }

    public void writeOptimized(OMText node) {
        this.binaryNodeList.add(node);
    }

    public void setXmlStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public XMLStreamWriter getXmlStreamWriter() {
        return this.xmlWriter;
    }

    public String getMimeBoundary() {
        return this.format.getMimeBoundary();
    }

    public String getRootContentId() {
        return this.format.getRootContentId();
    }

    public String getNextContentId() {
        return this.format.getNextContentId();
    }

    public String getCharSetEncoding() {
        return this.format.getCharSetEncoding();
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.format.setCharSetEncoding(charSetEncoding);
    }

    public String getXmlVersion() {
        return this.format.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) {
        this.format.setXmlVersion(xmlVersion);
    }

    public void setSoap11(boolean b) {
        this.format.setSOAP11(b);
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.format.isIgnoreXMLDeclaration();
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.format.setIgnoreXMLDeclaration(ignoreXMLDeclaration);
    }

    public void setDoOptimize(boolean b) {
        this.format.setDoOptimize(b);
    }

    public void setOutputFormat(OMOutputFormat format) {
        this.format = format;
    }
}

