/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om;

import org.apache.ws.commons.om.impl.MIMEOutputUtils;
import org.apache.ws.commons.om.util.UUIDGenerator;

public class OMOutputFormat {
    private String mimeBoundary = null;
    private String rootContentId = null;
    private int nextid = 0;
    private boolean doOptimize;
    private boolean isSoap11 = true;
    public static final String DEFAULT_CHAR_SET_ENCODING = "utf-8";
    private String charSetEncoding;
    private String xmlVersion;
    private boolean ignoreXMLDeclaration = false;

    public boolean isOptimized() {
        return this.doOptimize;
    }

    public String getContentType() {
        if (this.isOptimized()) {
            String SOAPContentType = this.isSoap11 ? "text/xml" : "application/soap+xml";
            return MIMEOutputUtils.getContentTypeForMime(this.getMimeBoundary(), this.getRootContentId(), this.getCharSetEncoding(), SOAPContentType);
        }
        if (!this.isSoap11) {
            return "application/soap+xml";
        }
        return "text/xml";
    }

    public String getMimeBoundary() {
        if (this.mimeBoundary == null) {
            this.mimeBoundary = "MIMEBoundary" + UUIDGenerator.getUUID();
        }
        return this.mimeBoundary;
    }

    public String getRootContentId() {
        if (this.rootContentId == null) {
            this.rootContentId = "0." + UUIDGenerator.getUUID() + "@apache.org";
        }
        return this.rootContentId;
    }

    public String getNextContentId() {
        ++this.nextid;
        return this.nextid + "." + UUIDGenerator.getUUID() + "@apache.org";
    }

    public String getCharSetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.charSetEncoding = charSetEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public void setSOAP11(boolean b) {
        this.isSoap11 = b;
    }

    public boolean isSOAP11() {
        return this.isSoap11;
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.ignoreXMLDeclaration;
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.ignoreXMLDeclaration = ignoreXMLDeclaration;
    }

    public void setDoOptimize(boolean b) {
        this.doOptimize = b;
    }
}

