/*
 * Decompiled with CFR 0.152.
 */
package world.komq.paralleluniverse.api.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import world.komq.paralleluniverse.api.DatabaseManager;
import world.komq.paralleluniverse.api.internal.DatabaseManagerImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u000fH\u0016R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lworld/komq/paralleluniverse/api/internal/DatabaseManagerImpl;", "Lworld/komq/paralleluniverse/api/DatabaseManager;", "()V", "databaseMap", "Ljava/util/HashMap;", "", "Lorg/jetbrains/exposed/sql/Database;", "Lkotlin/collections/HashMap;", "komworldDatabaseConf", "Ljava/io/File;", "komworldDbPassword", "komworldDbURL", "komworldDbUsername", "otherDb", "boolToInt", "", "bool", "", "checkConfig", "commit", "", "connectDatabase", "dbURL", "dbDriver", "username", "password", "databaseName", "getDatabase", "getGameServerDatabase", "getPlayerGameDatabase", "getUniversalDatabase", "intToBool", "integer", "parallel-universe-core"})
public final class DatabaseManagerImpl
implements DatabaseManager {
    @NotNull
    private final File komworldDatabaseConf = new File("komworldDatabaseConf.txt");
    @NotNull
    private String komworldDbURL = "";
    @NotNull
    private String komworldDbUsername = "";
    @NotNull
    private String komworldDbPassword = "";
    @Nullable
    private Database otherDb;
    @NotNull
    private final HashMap<String, Database> databaseMap = new HashMap();

    private final boolean checkConfig() {
        Charset charset;
        boolean bl;
        if (!this.komworldDatabaseConf.exists()) {
            this.komworldDatabaseConf.createNewFile();
            bl = false;
        } else {
            charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            if (!((Collection)FilesKt.readLines((File)this.komworldDatabaseConf, (Charset)charset)).isEmpty()) {
                // empty if block
            }
            bl = true;
        }
        boolean result = bl;
        charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        if (FilesKt.readLines((File)this.komworldDatabaseConf, (Charset)charset).size() == 3) {
            charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            this.komworldDbURL = (String)FilesKt.readLines((File)this.komworldDatabaseConf, (Charset)charset).get(0);
            charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            this.komworldDbUsername = (String)FilesKt.readLines((File)this.komworldDatabaseConf, (Charset)charset).get(1);
            charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            this.komworldDbPassword = (String)FilesKt.readLines((File)this.komworldDatabaseConf, (Charset)charset).get(2);
        }
        return result;
    }

    @Nullable
    public Database getGameServerDatabase() {
        Database db = null;
        if (this.checkConfig()) {
            db = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)Intrinsics.stringPlus((String)(StringsKt.endsWith$default((String)this.komworldDbURL, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)this.komworldDbURL, (CharSequence)"/") : this.komworldDbURL), (Object)"GameServerData"), (String)"com.mysql.cj.jdbc.Driver", (String)this.komworldDbUsername, (String)this.komworldDbPassword, null, null, null, (int)112, null);
        }
        return db;
    }

    @Nullable
    public Database getUniversalDatabase() {
        Database db = null;
        if (this.checkConfig()) {
            db = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)Intrinsics.stringPlus((String)(StringsKt.endsWith$default((String)this.komworldDbURL, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)this.komworldDbURL, (CharSequence)"/") : this.komworldDbURL), (Object)"UniversalData"), (String)"com.mysql.cj.jdbc.Driver", (String)this.komworldDbUsername, (String)this.komworldDbPassword, null, null, null, (int)112, null);
        }
        return db;
    }

    @Nullable
    public Database getPlayerGameDatabase() {
        Database db = null;
        if (this.checkConfig()) {
            db = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)Intrinsics.stringPlus((String)(StringsKt.endsWith$default((String)this.komworldDbURL, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)this.komworldDbURL, (CharSequence)"/") : this.komworldDbURL), (Object)"PlayerGameData"), (String)"com.mysql.cj.jdbc.Driver", (String)this.komworldDbUsername, (String)this.komworldDbPassword, null, null, null, (int)112, null);
        }
        return db;
    }

    public void connectDatabase(@NotNull String dbURL, @NotNull String dbDriver, @NotNull String username, @NotNull String password, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)dbURL, (String)"dbURL");
        Intrinsics.checkNotNullParameter((Object)dbDriver, (String)"dbDriver");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        if (StringsKt.endsWith$default((String)dbURL, (String)"/", (boolean)false, (int)2, null)) {
            StringsKt.removeSuffix((String)dbURL, (CharSequence)"/");
        }
        this.otherDb = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)(dbURL + '/' + databaseName), (String)dbDriver, (String)username, (String)password, null, null, null, (int)112, null);
        Object object = '\"' + databaseName + "\" database connected successfully!";
        System.out.println(object);
        object = this.databaseMap;
        Database database = this.otherDb;
        object.put(databaseName, database);
    }

    @Nullable
    public Database getDatabase(@Nullable String databaseName) {
        return (Database)((Map)this.databaseMap).get(databaseName);
    }

    public int boolToInt(boolean bool) {
        int n;
        boolean bl = bool;
        if (bl) {
            n = 1;
        } else if (!bl) {
            n = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public boolean intToBool(int integer) {
        boolean bl;
        switch (integer) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void commit() {
        ThreadLocalTransactionManagerKt.transaction((Database)this.getGameServerDatabase(), (Function1)commit.1.INSTANCE);
        ThreadLocalTransactionManagerKt.transaction((Database)this.getUniversalDatabase(), (Function1)commit.2.INSTANCE);
        ThreadLocalTransactionManagerKt.transaction((Database)this.getPlayerGameDatabase(), (Function1)commit.3.INSTANCE);
        Collection<Database> collection = this.databaseMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"databaseMap.values");
        if (!collection.isEmpty()) {
            collection = this.databaseMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"databaseMap.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Database it = (Database)element$iv;
                boolean bl = false;
                ThreadLocalTransactionManagerKt.transaction((Database)it, (Function1)commit.4.1.INSTANCE);
            }
        }
    }
}

