/*
 * Decompiled with CFR 0.152.
 */
package world.komq.paralleluniverse.api.logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lworld/komq/paralleluniverse/api/logger/CustomLogger;", "Ljava/util/logging/Formatter;", "()V", "calcDate", "", "millisecs", "", "format", "rec", "Ljava/util/logging/LogRecord;", "parallel-universe-api"})
public final class CustomLogger
extends Formatter {
    @Override
    @NotNull
    public String format(@NotNull LogRecord rec) {
        Intrinsics.checkNotNullParameter((Object)rec, (String)"rec");
        StringBuffer buf = new StringBuffer(1000);
        buf.append("[");
        buf.append(this.calcDate(rec.getMillis()));
        buf.append("] ");
        buf.append("[");
        buf.append(rec.getLevel());
        buf.append("]");
        buf.append(Intrinsics.stringPlus((String)" ", (Object)rec.getMessage()));
        buf.append("\n");
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }

    private final String calcDate(long millisecs) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Date resultdate = new Date(millisecs);
        String string = dateFormat.format(resultdate);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(resultdate)");
        return string;
    }
}

