/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

public final class CharTable {
    private final long b0;
    private final long b1;
    private final boolean nonAscii;

    public static CharTable forRange(String range, boolean nonAscii) {
        long b0 = 0L;
        long b1 = 0L;
        int len = range.length();
        for (int pos = 0; pos < len; ++pos) {
            char lo;
            char hi = lo = range.charAt(pos);
            if (pos + 2 < len && range.charAt(pos + 1) == '-') {
                hi = range.charAt(pos + 2);
                pos += 2;
            }
            for (char ch = lo; ch <= hi; ch = (char)(ch + '\u0001')) {
                if (ch < '@') {
                    b0 |= 1L << ch;
                    continue;
                }
                if (ch < '\u0080') {
                    b1 |= 1L << (ch & 0x3F);
                    continue;
                }
                throw new UnsupportedOperationException("Range string contains non-ascii characters: " + range);
            }
        }
        return new CharTable(b0, b1, nonAscii);
    }

    private CharTable(long b0, long b1, boolean nonAscii) {
        this.b0 = b0;
        this.b1 = b1;
        this.nonAscii = nonAscii;
    }

    public CharTable invert() {
        return new CharTable(this.b0 ^ 0xFFFFFFFFFFFFFFFFL, this.b1 ^ 0xFFFFFFFFFFFFFFFFL, !this.nonAscii);
    }

    public boolean contains(char ch) {
        return ch < '\u0080' ? ((ch < '@' ? this.b0 : this.b1) & 1L << (ch & 0x3F)) != 0L : this.nonAscii;
    }

    public boolean matchesAll(String s) {
        return this.matchesAll(s, 0, s.length());
    }

    public boolean matchesAll(String s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (this.contains(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append('[');
        for (char ch = '\u0000'; ch < '\u0080'; ch = (char)(ch + '\u0001')) {
            if (!this.contains(ch)) continue;
            buf.append(ch);
        }
        if (this.nonAscii) {
            buf.append("+non-ascii");
        }
        buf.append(']');
        return buf.toString();
    }
}

