/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.statements;

import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.logging.Logger;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.DataWorldStatement;
import world.data.jdbc.JdbcCompatibility;
import world.data.jdbc.internal.query.QueryEngine;
import world.data.jdbc.internal.statements.ReadOnlyStatement;
import world.data.jdbc.internal.util.Conditions;
import world.data.jdbc.internal.util.Optionals;
import world.data.jdbc.internal.util.ResourceContainer;
import world.data.jdbc.internal.util.ResourceManager;
import world.data.jdbc.model.Node;

public class StatementImpl
implements DataWorldStatement,
ReadOnlyStatement,
ResourceContainer {
    private static final Logger log = Logger.getLogger(StatementImpl.class.getName());
    private static final int NO_LIMIT = 0;
    private int timeout = 0;
    private JdbcCompatibility compatibilityLevel;
    private SQLWarning warnings = null;
    final QueryEngine queryEngine;
    private final DataWorldConnection connection;
    private final ResourceManager resources = new ResourceManager();
    private final List<BatchItem> commands = new ArrayList<BatchItem>();
    private final Queue<ResultSet> batchResults = new LinkedList<ResultSet>();
    private final List<ResultSet> openResults = new ArrayList<ResultSet>();
    private ResultSet currResults;
    private boolean closed;

    public StatementImpl(QueryEngine queryEngine, DataWorldConnection connection) {
        this.queryEngine = Objects.requireNonNull(queryEngine, "queryEngine");
        this.connection = Objects.requireNonNull(connection, "connection");
        ((ResourceContainer)((Object)connection)).getResources().register(this);
    }

    @Override
    public ResourceManager getResources() {
        return this.resources;
    }

    @Override
    public final JdbcCompatibility getJdbcCompatibilityLevel() throws SQLException {
        this.checkClosed();
        return Optionals.or(this.compatibilityLevel, this.connection.getJdbcCompatibilityLevel());
    }

    @Override
    public final void setJdbcCompatibilityLevel(JdbcCompatibility compatibilityLevel) throws SQLException {
        this.checkClosed();
        this.compatibilityLevel = compatibilityLevel;
    }

    @Override
    public final DataWorldConnection getConnection() {
        return this.connection;
    }

    @Override
    public final void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public final int getFetchDirection() {
        return 1000;
    }

    @Override
    public final int getFetchSize() {
        return 0;
    }

    @Override
    public final int getMaxFieldSize() {
        return 0;
    }

    @Override
    public final int getMaxRows() {
        return 0;
    }

    @Override
    public final int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public final int getResultSetHoldability() {
        return 2;
    }

    @Override
    public final int getResultSetType() {
        return 1003;
    }

    @Override
    public final SQLWarning getWarnings() {
        return this.warnings;
    }

    private void setWarning(SQLWarning warning) {
        log.warning("SQL Warning was issued: " + warning);
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            warning.setNextWarning(this.warnings);
            this.warnings = warning;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return DataWorldStatement.class.equals(iface);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        Conditions.check(this.isWrapperFor(iface), "Not a wrapper for the desired interface");
        return iface.cast(this);
    }

    @Override
    public final void addBatch(String query) throws SQLException {
        this.checkClosed();
        this.doAddBatch(query, Collections.emptyMap());
    }

    void doAddBatch(String query, Map<String, Node> params) throws SQLException {
        this.commands.add(new BatchItem(query, params));
    }

    @Override
    public final void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean execute(String query, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        Conditions.checkSupported(autoGeneratedKeys == 2, "Does not support auto-generated keys");
        return this.execute(query);
    }

    @Override
    public final boolean execute(String query, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean execute(String query, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        this.checkClosed();
        int[] rets = new int[this.commands.size()];
        ResultSet curr = this.currResults;
        for (int i = 0; i < this.commands.size(); ++i) {
            BatchItem batchItem = this.commands.get(i);
            if (this.doExecuteQuery(batchItem.query, batchItem.params)) {
                this.batchResults.add(this.getResultSet());
                this.currResults = null;
                rets[i] = -2;
                continue;
            }
            this.batchResults.add(null);
            rets[i] = -1;
        }
        this.currResults = curr;
        if (this.currResults == null && !this.batchResults.isEmpty()) {
            this.currResults = this.batchResults.poll();
        }
        return rets;
    }

    @Override
    public final void clearBatch() {
        this.commands.clear();
    }

    @Override
    public final void close() throws SQLException {
        if (this.closed) {
            return;
        }
        log.fine("Closing statement");
        ((ResourceContainer)((Object)this.connection)).getResources().remove(this);
        try {
            this.resources.close();
        }
        catch (Exception e) {
            log.warning("Unexpected trying to close resources: " + e);
        }
        finally {
            this.closed = true;
            log.fine("Statement was closed");
        }
    }

    private void setWarning(String warning) {
        this.setWarning(new SQLWarning(warning));
    }

    @Override
    public final void setEscapeProcessing(boolean enable) {
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        Conditions.checkSupported(direction == 1000, "Only ResultSet.FETCH_FORWARD is supported as a fetch direction");
    }

    @Override
    public final void setFetchSize(int rows) {
        this.setWarning("setMaxFieldSize() was called but there is no fetch size control for data.world JDBC connections");
    }

    @Override
    public final void setMaxFieldSize(int max) {
        this.setWarning("setMaxFieldSize() was called but there is no field size limit for data.world JDBC connections");
    }

    @Override
    public final void setMaxRows(int max) {
        this.setWarning("setMaxRows() was called but there is no row size limit for data.world JDBC connections");
    }

    @Override
    public final void setPoolable(boolean poolable) {
        this.setWarning("setPoolable() was called but data.world JDBC statements are always considered poolable");
    }

    @Override
    public final void setQueryTimeout(int seconds) {
        this.timeout = Math.max(seconds, 0);
    }

    @Override
    public final boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public final void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean isPoolable() {
        return true;
    }

    @Override
    public final boolean execute(String query) throws SQLException {
        this.checkClosed();
        return this.doExecuteQuery(query, Collections.emptyMap());
    }

    @Override
    public final ResultSet executeQuery(String query) throws SQLException {
        this.checkClosed();
        boolean hasResultSet = this.doExecuteQuery(query, Collections.emptyMap());
        Conditions.check(hasResultSet, "Query did not produce a result set");
        return this.getResultSet();
    }

    boolean doExecuteQuery(String query, Map<String, Node> parameters) throws SQLException {
        log.fine(() -> "Received input command text:\n " + query);
        try {
            this.currResults = this.queryEngine.execute(this, query, parameters, this.timeout != 0 ? Integer.valueOf(this.timeout) : null);
            return true;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException("Error occurred during query evaluation", e);
        }
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        this.checkClosed();
        if (this.currResults != null) {
            this.currResults.close();
            this.currResults = null;
        }
        if (!this.batchResults.isEmpty()) {
            this.currResults = this.batchResults.poll();
            return true;
        }
        return false;
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        switch (current) {
            case 1: {
                return this.getMoreResults();
            }
            case 3: {
                for (ResultSet rset : this.openResults) {
                    rset.close();
                }
                this.openResults.clear();
                return this.getMoreResults();
            }
            case 2: {
                if (this.currResults != null) {
                    this.openResults.add(this.currResults);
                    this.currResults = null;
                }
                return this.getMoreResults();
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported mode for dealing with current results, only Statement.CLOSE_CURRENT_RESULT, Statement.CLOSE_ALL_RESULTS and Statement.KEEP_CURRENT_RESULT are supported");
    }

    @Override
    public final int getQueryTimeout() {
        return this.timeout;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.currResults;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    void checkClosed() throws SQLException {
        Conditions.check(!this.closed, "Statement is closed");
    }

    private static class BatchItem {
        private final String query;
        private final Map<String, Node> params;

        @ConstructorProperties(value={"query", "params"})
        public BatchItem(String query, Map<String, Node> params) {
            this.query = query;
            this.params = params;
        }
    }
}

