/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.JdbcCompatibility;
import world.data.jdbc.internal.connections.ConnectionImpl;
import world.data.jdbc.internal.query.QueryEngine;
import world.data.jdbc.internal.query.SparqlEngine;
import world.data.jdbc.internal.query.SqlEngine;
import world.data.jdbc.internal.transport.HttpQueryApi;
import world.data.jdbc.internal.util.Conditions;
import world.data.jdbc.internal.util.Versions;

public final class Driver
implements java.sql.Driver {
    private static final Logger log = Logger.getLogger(Driver.class.getName());
    public static final String SQL_PREFIX = "jdbc:data:world:sql:";
    public static final String SPARQL_PREFIX = "jdbc:data:world:sparql:";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_JDBC_COMPATIBILITY = "jdbcCompatibility";
    public static final String VERSION = Versions.findVersionString();
    private static final int[] VERSION_NUMBERS = Versions.parseVersionNumbers(VERSION);

    public static synchronized void register() throws SQLException {
        DriverManager.registerDriver(new Driver());
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(SQL_PREFIX) || url.startsWith(SPARQL_PREFIX);
    }

    @Override
    public DataWorldConnection connect(String url, Properties props) throws SQLException {
        QueryEngine queryEngine;
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties effectiveProps = new Properties();
        String[] urlParts = url.split(";");
        String[] urlFields = urlParts[0].split(":", 6);
        Conditions.check(urlFields.length == 6, "Invalid jdbc url, expected 'jdbc:data:world:<language>:<account>:<dataset>': %s", url);
        effectiveProps.setProperty("lang", urlFields[3]);
        effectiveProps.setProperty("agentid", urlFields[4]);
        effectiveProps.setProperty("datasetid", urlFields[5]);
        effectiveProps.setProperty("querybaseurl", "https://query.data.world");
        if (props != null) {
            for (String key : props.stringPropertyNames()) {
                String value = props.getProperty(key);
                effectiveProps.setProperty(key.toLowerCase(), value);
            }
        }
        for (int i = 1; i < urlParts.length; ++i) {
            String[] pair = urlParts[i].split("=", 2);
            Conditions.check(pair.length == 2, "Invalid jdbc url, expected ';name=value' pairs in suffix: %s", url);
            effectiveProps.setProperty(pair[0].toLowerCase(), Driver.urlDecode(pair[1]));
        }
        String queryBaseUrl = effectiveProps.getProperty("querybaseurl");
        String lang = effectiveProps.getProperty("lang");
        String agentId = effectiveProps.getProperty("agentid");
        String datasetId = effectiveProps.getProperty("datasetid");
        String password = effectiveProps.getProperty(PARAM_PASSWORD);
        JdbcCompatibility jdbcCompatibility = Driver.getProperty(effectiveProps, PARAM_JDBC_COMPATIBILITY, JdbcCompatibility.class);
        URL queryEndpoint = Driver.getQueryEndpoint(queryBaseUrl, lang, agentId, datasetId);
        String userAgent = String.format("DwJdbc-%s/%s", lang, VERSION);
        HttpQueryApi queryApi = new HttpQueryApi(queryEndpoint, userAgent, password);
        if ("sparql".equals(lang)) {
            queryEngine = new SparqlEngine(queryApi, agentId, datasetId);
        } else if ("sql".equals(lang)) {
            queryEngine = new SqlEngine(queryApi, agentId, datasetId);
        } else {
            throw new SQLException("Unknown query language: " + lang);
        }
        return new ConnectionImpl(queryEngine, jdbcCompatibility);
    }

    private static URL getQueryEndpoint(String queryBaseUrl, String lang, String agentId, String datasetId) throws SQLException {
        String queryUrl = String.format("%s/%s/%s/%s", queryBaseUrl, lang, agentId, datasetId);
        try {
            return new URL(queryUrl);
        }
        catch (MalformedURLException e) {
            throw new SQLException("Bad query service url: " + queryUrl, e);
        }
    }

    private static <E extends Enum<E>> E getProperty(Properties props, String key, Class<E> enumClass) {
        String value = props.getProperty(key.toLowerCase());
        return value != null && !value.isEmpty() ? (E)Enum.valueOf(enumClass, value.toUpperCase()) : null;
    }

    private static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getMajorVersion() {
        return VERSION_NUMBERS[0];
    }

    @Override
    public int getMinorVersion() {
        return VERSION_NUMBERS[1];
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getPackage().getName());
    }

    static {
        try {
            Driver.register();
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Unable to register data.world JDBC driver", e);
        }
    }
}

