/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;
import world.data.jdbc.internal.util.Like;

public final class Optionals {
    public static <T> T or(T a, T b) {
        return a != null ? a : b;
    }

    public static <T, U> U mapIfPresent(T a, Function<T, U> ifPresentFn) {
        return a != null ? (U)ifPresentFn.apply(a) : null;
    }

    public static <T> boolean nullOrEquals(@Nullable T a, T b) {
        return a == null || a.equals(b);
    }

    public static boolean nullOrMatches(@Nullable String pattern, String string) {
        return pattern == null || Like.matches(string, pattern);
    }

    public static <T> boolean nullOrContains(@Nullable T[] b, T a) {
        return b == null || Arrays.asList(b).contains(a);
    }

    private Optionals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

