/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public final class Conditions {
    public static void check(boolean flag, String message) throws SQLException {
        if (!flag) {
            throw new SQLException(message);
        }
    }

    public static void check(boolean flag, String format, Object ... args) throws SQLException {
        if (!flag) {
            throw new SQLException(String.format(format, args));
        }
    }

    public static void checkSupported(boolean flag) throws SQLException {
        if (!flag) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    public static void checkSupported(boolean flag, String message) throws SQLException {
        if (!flag) {
            throw new SQLFeatureNotSupportedException(message);
        }
    }

    public static void checkConnectionTransactionIsolation(int level) throws SQLException {
        if (level != 0 && level != 1 && level != 2 && level != 4 && level != 8) {
            throw new SQLException(String.format("%d is not a valid transaction isolation level", level));
        }
    }

    public static void checkStatementGeneratedKeys(int generatedKeys) throws SQLException {
        if (generatedKeys != 2 && generatedKeys != 1) {
            throw new SQLException(String.format("%d is not a valid generated keys value", generatedKeys));
        }
    }

    public static void checkResultSetConcurrency(int concurrency) throws SQLException {
        if (concurrency != 1007 && concurrency != 1008) {
            throw new SQLException(String.format("%d is not a valid result set concurrency", concurrency));
        }
    }

    public static void checkResultSetDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException(String.format("%d is not a valid result set fetch direction", direction));
        }
    }

    public static void checkResultSetHoldability(int holdability) throws SQLException {
        if (holdability != 1 && holdability != 2) {
            throw new SQLException(String.format("%d is not a valid result set holdability", holdability));
        }
    }

    public static void checkResultSetType(int type) throws SQLException {
        if (type != 1003 && type != 1004 && type != 1005) {
            throw new SQLException(String.format("%d is not a valid result set type", type));
        }
    }

    private Conditions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

