/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import world.data.jdbc.internal.types.TypeMapping;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Rdfs;
import world.data.jdbc.vocab.Xsd;

public class TypeMap {
    private static final TypeMapping STRING = TypeMapping.simple(Xsd.STRING, JDBCType.NVARCHAR, String.class, Integer.MAX_VALUE);
    public static final Iri DATATYPE_RAW_NODE = TypeMap.javaIri(Node.class);
    private static final Iri DATATYPE_JAVA_OBJECT = TypeMap.javaIri(Object.class);
    public static final TypeMap INSTANCE = new TypeMap();
    private final Map<Iri, TypeMapping> standardByDatatype = new HashMap<Iri, TypeMapping>();
    private final Map<Iri, TypeMapping> byDatatype = new HashMap<Iri, TypeMapping>();
    private final Map<Integer, TypeMapping> standardByJdbcType = new HashMap<Integer, TypeMapping>();

    private TypeMap() {
        int max = Integer.MAX_VALUE;
        this.standard(STRING, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.LONGVARCHAR, JDBCType.NCHAR, JDBCType.LONGNVARCHAR);
        this.standard(TypeMapping.simple(Xsd.BOOLEAN, JDBCType.BOOLEAN, Boolean.class, "false".length()), JDBCType.BIT);
        this.standard(TypeMapping.simple(Xsd.DATE, JDBCType.DATE, Date.class, 15), new JDBCType[0]);
        this.standard(TypeMapping.simple(Xsd.TIME, JDBCType.TIME, Time.class, 24), new JDBCType[0]);
        this.standard(TypeMapping.simple(Xsd.DATETIME, JDBCType.TIMESTAMP, Timestamp.class, 40), new JDBCType[0]);
        this.standard(TypeMapping.simple(TypeMap.javaIri(OffsetTime.class), JDBCType.TIME_WITH_TIMEZONE, OffsetTime.class, 24), new JDBCType[0]);
        this.standard(TypeMapping.simple(Xsd.DATETIMESTAMP, JDBCType.TIMESTAMP_WITH_TIMEZONE, OffsetDateTime.class, 40), new JDBCType[0]);
        this.standard(TypeMapping.numeric(Xsd.BYTE, JDBCType.TINYINT, Byte.class, 3, 0, 0, true, true), new JDBCType[0]);
        this.standard(TypeMapping.numeric(Xsd.SHORT, JDBCType.SMALLINT, Short.class, 5, 0, 0, true, true), new JDBCType[0]);
        this.standard(TypeMapping.numeric(Xsd.INT, JDBCType.INTEGER, Integer.class, 10, 0, 0, true, true), new JDBCType[0]);
        this.standard(TypeMapping.numeric(Xsd.LONG, JDBCType.BIGINT, Long.class, 19, 0, 0, true, true), new JDBCType[0]);
        this.standard(TypeMapping.numeric(Xsd.FLOAT, JDBCType.REAL, Float.class, 9, 6, 9, true, false), new JDBCType[0]);
        this.standard(TypeMapping.numeric(Xsd.DOUBLE, JDBCType.DOUBLE, Double.class, 17, 15, 17, true, false), JDBCType.FLOAT);
        this.standard(TypeMapping.numeric(Xsd.DECIMAL, JDBCType.DECIMAL, BigDecimal.class, 38, 38, 38, true, true), JDBCType.NUMERIC);
        this.standard(TypeMapping.simple(DATATYPE_JAVA_OBJECT, JDBCType.JAVA_OBJECT, Object.class, max), new JDBCType[0]);
        this.standard(TypeMapping.simple(DATATYPE_RAW_NODE, JDBCType.OTHER, Node.class, max), new JDBCType[0]);
        this.custom(TypeMapping.simple(Rdfs.RESOURCE, JDBCType.NVARCHAR, URI.class, max));
        this.custom(TypeMapping.simple(Xsd.ANYURI, JDBCType.NVARCHAR, URI.class, max));
        this.custom(TypeMapping.simple(Xsd.DAYTIMEDURATION, JDBCType.NVARCHAR, Duration.class, 36));
        this.custom(TypeMapping.numeric(Xsd.GDAY, JDBCType.INTEGER, Integer.class, 2, 0, 0, false, true));
        this.custom(TypeMapping.numeric(Xsd.GMONTH, JDBCType.INTEGER, Month.class, 2, 0, 0, false, true));
        this.custom(TypeMapping.simple(Xsd.GMONTHDAY, JDBCType.NVARCHAR, MonthDay.class, 7));
        this.custom(TypeMapping.numeric(Xsd.GYEAR, JDBCType.INTEGER, Year.class, 9, 0, 0, true, true));
        this.custom(TypeMapping.simple(Xsd.GYEARMONTH, JDBCType.NVARCHAR, YearMonth.class, 12));
        this.custom(TypeMapping.numeric(Xsd.INTEGER, JDBCType.NUMERIC, BigInteger.class, 38, 0, 0, true, true));
        this.custom(TypeMapping.numeric(Xsd.NEGATIVEINTEGER, JDBCType.NUMERIC, BigInteger.class, 38, 0, 0, true, true));
        this.custom(TypeMapping.numeric(Xsd.NONNEGATIVEINTEGER, JDBCType.NUMERIC, BigInteger.class, 38, 0, 0, false, true));
        this.custom(TypeMapping.numeric(Xsd.NONPOSITIVEINTEGER, JDBCType.NUMERIC, BigInteger.class, 38, 0, 0, true, true));
        this.custom(TypeMapping.numeric(Xsd.POSITIVEINTEGER, JDBCType.NUMERIC, BigInteger.class, 38, 0, 0, false, true));
        this.custom(TypeMapping.numeric(Xsd.UNSIGNEDBYTE, JDBCType.SMALLINT, Short.class, 3, 0, 0, false, true));
        this.custom(TypeMapping.numeric(Xsd.UNSIGNEDINT, JDBCType.BIGINT, Long.class, 10, 0, 0, false, true));
        this.custom(TypeMapping.numeric(Xsd.UNSIGNEDLONG, JDBCType.NUMERIC, BigInteger.class, 20, 0, 0, false, true));
        this.custom(TypeMapping.numeric(Xsd.UNSIGNEDSHORT, JDBCType.INTEGER, Integer.class, 6, 0, 0, false, true));
        this.custom(TypeMapping.simple(Xsd.YEARMONTHDURATION, JDBCType.NVARCHAR, Period.class, 24));
        this.unmap(JDBCType.BINARY);
        this.unmap(JDBCType.VARBINARY);
        this.unmap(JDBCType.LONGVARBINARY);
        this.unmap(JDBCType.DISTINCT);
        this.unmap(JDBCType.CLOB);
        this.unmap(JDBCType.BLOB);
        this.unmap(JDBCType.ARRAY);
        this.unmap(JDBCType.STRUCT);
        this.unmap(JDBCType.REF);
        this.unmap(JDBCType.DATALINK);
        this.unmap(JDBCType.ROWID);
        this.unmap(JDBCType.NCLOB);
        this.unmap(JDBCType.SQLXML);
        this.unmap(JDBCType.REF_CURSOR);
        this.unmap(JDBCType.NULL);
    }

    public TypeMapping getStandard(Iri datatype) {
        return this.standardByDatatype.getOrDefault(datatype, STRING);
    }

    public TypeMapping getStandard(int jdbcType) {
        return this.standardByJdbcType.get(jdbcType);
    }

    public TypeMapping getStandardOrCustom(Iri datatype) {
        return this.byDatatype.getOrDefault(datatype, STRING);
    }

    public Collection<TypeMapping> getAll() {
        return this.byDatatype.values();
    }

    private void standard(TypeMapping mapping, JDBCType ... additionalTypes) {
        this.put(this.byDatatype, mapping.getDatatype(), mapping);
        this.put(this.standardByDatatype, mapping.getDatatype(), mapping);
        this.put(this.standardByJdbcType, mapping.getJdbcType().getVendorTypeNumber(), mapping);
        for (JDBCType additionalType : additionalTypes) {
            this.put(this.standardByJdbcType, additionalType.getVendorTypeNumber(), mapping);
        }
    }

    private void custom(TypeMapping mapping) {
        TypeMapping standard = Objects.requireNonNull(this.getStandard(mapping.getTypeNumber()));
        this.put(this.byDatatype, mapping.getDatatype(), mapping);
        this.put(this.standardByDatatype, mapping.getDatatype(), standard);
    }

    private void unmap(JDBCType jdbcType) {
        this.put(this.standardByJdbcType, jdbcType.getVendorTypeNumber(), null);
    }

    Collection<Integer> getMappedJdbcTypes() {
        return Collections.unmodifiableSet(this.standardByJdbcType.keySet());
    }

    private static Iri javaIri(Class<?> clazz) {
        return new Iri("java:" + clazz.getName());
    }

    private <K, V> void put(Map<K, V> map, K key, V value) {
        V old = map.put(key, value);
        this.checkState(old == null, "Duplicate key definition: %s -> %s conflicts with %s", key, old, value);
    }

    private void checkState(boolean flag, String format, Object ... args) {
        if (!flag) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }
}

