/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.types;

import java.util.regex.Pattern;
import world.data.jdbc.internal.util.CharTable;
import world.data.jdbc.model.Iri;
import world.data.jdbc.vocab.Xsd;

public final class NTriplesFormat {
    private static final Pattern PATTERN_LANGTAG = Pattern.compile("[a-zA-Z]+(-[a-zA-Z0-9]+)*");
    private static final CharTable BLANK_FIRST = CharTable.forRange("A-Za-z0-9_:", true);
    private static final CharTable BLANK_MIDDLE = CharTable.forRange("-A-Za-z0-9_:.", true);
    private static final CharTable BLANK_LAST = CharTable.forRange("-A-Za-z0-9_:", true);
    private static final CharTable IRI_UNESCAPED = CharTable.forRange("\u0000- <>\"{}|^`\\", false).invert();

    public static boolean isWellFormedLanguage(String language) {
        return PATTERN_LANGTAG.matcher(language).matches();
    }

    public static boolean isWellFormedLabel(String label) {
        return !(label.length() == 0 || !BLANK_FIRST.contains(label.charAt(0)) || label.length() > 2 && !BLANK_MIDDLE.matchesAll(label, 1, label.length() - 1) || label.length() > 1 && !BLANK_LAST.contains(label.charAt(label.length() - 1)));
    }

    public static String formatLiteral(String lexicalForm, Iri datatype, String language) {
        int padding = 5;
        if (language != null && !language.isEmpty()) {
            StringBuilder buf = new StringBuilder(lexicalForm.length() + language.length() + 1 + padding);
            NTriplesFormat.appendQuoted(buf, lexicalForm);
            buf.append('@');
            buf.append(language);
            return buf.toString();
        }
        if (Xsd.STRING.equals(datatype)) {
            StringBuilder buf = new StringBuilder(lexicalForm.length() + padding);
            NTriplesFormat.appendQuoted(buf, lexicalForm);
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder(lexicalForm.length() + datatype.getIri().length() + 4 + padding);
        NTriplesFormat.appendQuoted(buf, lexicalForm);
        buf.append("^^").append(datatype);
        return buf.toString();
    }

    private static void appendQuoted(StringBuilder buf, String string) {
        buf.append('\"');
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                    buf.append('\\');
                    break;
                }
                case '\t': {
                    c = 't';
                    buf.append('\\');
                    break;
                }
                case '\r': {
                    c = 'r';
                    buf.append('\\');
                    break;
                }
                case '\b': {
                    c = 'b';
                    buf.append('\\');
                    break;
                }
                case '\f': {
                    c = 'f';
                    buf.append('\\');
                    break;
                }
                case '\"': 
                case '\\': {
                    buf.append('\\');
                }
            }
            buf.append(c);
        }
        buf.append('\"');
    }

    public static String formatIri(String iri) {
        if (IRI_UNESCAPED.matchesAll(iri)) {
            return '<' + iri + '>';
        }
        StringBuilder buf = new StringBuilder(iri.length() + 14);
        buf.append('<');
        int len = iri.length();
        for (int i = 0; i < len; ++i) {
            char ch = iri.charAt(i);
            if (IRI_UNESCAPED.contains(ch)) {
                buf.append(ch);
                continue;
            }
            buf.append(String.format("\\u%04x", ch));
        }
        buf.append('>');
        return buf.toString();
    }

    public static String formatBlank(String label) {
        return "_:" + label;
    }

    private NTriplesFormat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

