/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import world.data.jdbc.model.Node;

public final class Response {
    private final Boolean booleanResult;
    private final List<Column> columns;
    private final Iterator<Node[]> rows;
    private final AutoCloseable cleanup;

    Response(Boolean booleanResult, List<Column> columns, Iterator<Node[]> rows, AutoCloseable cleanup) {
        this.booleanResult = booleanResult;
        this.columns = columns;
        this.rows = rows;
        this.cleanup = cleanup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Boolean getBooleanResult() {
        return this.booleanResult;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Iterator<Node[]> getRows() {
        return this.rows;
    }

    public AutoCloseable getCleanup() {
        return this.cleanup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        Boolean this$booleanResult = this.getBooleanResult();
        Boolean other$booleanResult = other.getBooleanResult();
        if (this$booleanResult == null ? other$booleanResult != null : !((Object)this$booleanResult).equals(other$booleanResult)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Iterator<Node[]> this$rows = this.getRows();
        Iterator<Node[]> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !this$rows.equals(other$rows)) {
            return false;
        }
        AutoCloseable this$cleanup = this.getCleanup();
        AutoCloseable other$cleanup = other.getCleanup();
        return !(this$cleanup == null ? other$cleanup != null : !this$cleanup.equals(other$cleanup));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $booleanResult = this.getBooleanResult();
        result = result * 59 + ($booleanResult == null ? 43 : ((Object)$booleanResult).hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Iterator<Node[]> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : $rows.hashCode());
        AutoCloseable $cleanup = this.getCleanup();
        result = result * 59 + ($cleanup == null ? 43 : $cleanup.hashCode());
        return result;
    }

    public String toString() {
        return "Response(booleanResult=" + this.getBooleanResult() + ", columns=" + this.getColumns() + ", rows=" + this.getRows() + ", cleanup=" + this.getCleanup() + ")";
    }

    public static class Builder {
        private Boolean booleanResult;
        private List<Column> columns;
        private Iterator<Node[]> rows;
        private AutoCloseable cleanup;

        Builder() {
        }

        public Builder booleanResult(Boolean booleanResult) {
            this.booleanResult = booleanResult;
            return this;
        }

        public Builder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder rows(Iterator<Node[]> rows) {
            this.rows = rows;
            return this;
        }

        public Builder cleanup(AutoCloseable cleanup) {
            this.cleanup = cleanup;
            return this;
        }

        public Response build() {
            return new Response(this.booleanResult, this.columns, this.rows, this.cleanup);
        }

        public String toString() {
            return "Response.Builder(booleanResult=" + this.booleanResult + ", columns=" + this.columns + ", rows=" + this.rows + ", cleanup=" + this.cleanup + ")";
        }
    }

    public static final class Column {
        private final int index;
        @Nonnull
        private final String name;
        private final String description;
        private final String datatypeIri;
        private final String formatString;
        private final String units;
        private final Double scalingFactor;
        private final boolean required;

        Column(int index, @Nonnull String name, String description, String datatypeIri, String formatString, String units, Double scalingFactor, boolean required) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.index = index;
            this.name = name;
            this.description = description;
            this.datatypeIri = datatypeIri;
            this.formatString = formatString;
            this.units = units;
            this.scalingFactor = scalingFactor;
            this.required = required;
        }

        public static Builder builder() {
            return new Builder();
        }

        public int getIndex() {
            return this.index;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDatatypeIri() {
            return this.datatypeIri;
        }

        public String getFormatString() {
            return this.formatString;
        }

        public String getUnits() {
            return this.units;
        }

        public Double getScalingFactor() {
            return this.scalingFactor;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$datatypeIri = this.getDatatypeIri();
            String other$datatypeIri = other.getDatatypeIri();
            if (this$datatypeIri == null ? other$datatypeIri != null : !this$datatypeIri.equals(other$datatypeIri)) {
                return false;
            }
            String this$formatString = this.getFormatString();
            String other$formatString = other.getFormatString();
            if (this$formatString == null ? other$formatString != null : !this$formatString.equals(other$formatString)) {
                return false;
            }
            String this$units = this.getUnits();
            String other$units = other.getUnits();
            if (this$units == null ? other$units != null : !this$units.equals(other$units)) {
                return false;
            }
            Double this$scalingFactor = this.getScalingFactor();
            Double other$scalingFactor = other.getScalingFactor();
            if (this$scalingFactor == null ? other$scalingFactor != null : !((Object)this$scalingFactor).equals(other$scalingFactor)) {
                return false;
            }
            return this.isRequired() == other.isRequired();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $datatypeIri = this.getDatatypeIri();
            result = result * 59 + ($datatypeIri == null ? 43 : $datatypeIri.hashCode());
            String $formatString = this.getFormatString();
            result = result * 59 + ($formatString == null ? 43 : $formatString.hashCode());
            String $units = this.getUnits();
            result = result * 59 + ($units == null ? 43 : $units.hashCode());
            Double $scalingFactor = this.getScalingFactor();
            result = result * 59 + ($scalingFactor == null ? 43 : ((Object)$scalingFactor).hashCode());
            result = result * 59 + (this.isRequired() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Response.Column(index=" + this.getIndex() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", datatypeIri=" + this.getDatatypeIri() + ", formatString=" + this.getFormatString() + ", units=" + this.getUnits() + ", scalingFactor=" + this.getScalingFactor() + ", required=" + this.isRequired() + ")";
        }

        public static class Builder {
            private int index;
            private String name;
            private String description;
            private String datatypeIri;
            private String formatString;
            private String units;
            private Double scalingFactor;
            private boolean required;

            Builder() {
            }

            public Builder index(int index) {
                this.index = index;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder datatypeIri(String datatypeIri) {
                this.datatypeIri = datatypeIri;
                return this;
            }

            public Builder formatString(String formatString) {
                this.formatString = formatString;
                return this;
            }

            public Builder units(String units) {
                this.units = units;
                return this;
            }

            public Builder scalingFactor(Double scalingFactor) {
                this.scalingFactor = scalingFactor;
                return this;
            }

            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            public Column build() {
                return new Column(this.index, this.name, this.description, this.datatypeIri, this.formatString, this.units, this.scalingFactor, this.required);
            }

            public String toString() {
                return "Response.Column.Builder(index=" + this.index + ", name=" + this.name + ", description=" + this.description + ", datatypeIri=" + this.datatypeIri + ", formatString=" + this.formatString + ", units=" + this.units + ", scalingFactor=" + this.scalingFactor + ", required=" + this.required + ")";
            }
        }
    }
}

