/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.results;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import world.data.jdbc.internal.util.Conditions;

interface ReadOnlyResultSet
extends ResultSet {
    @Override
    default public int getConcurrency() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        return 1007;
    }

    @Override
    default public void insertRow() throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateRow() throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void deleteRow() throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public boolean rowDeleted() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        return false;
    }

    @Override
    default public boolean rowInserted() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        return false;
    }

    @Override
    default public boolean rowUpdated() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        return false;
    }

    @Override
    default public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void moveToInsertRow() throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }

    @Override
    default public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("Result set is read-only");
    }
}

