/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import javax.annotation.Nonnull;

public final class ColumnInfo {
    @Nonnull
    private final String catalogName;
    @Nonnull
    private final String schemaName;
    @Nonnull
    private final String tableName;
    @Nonnull
    private final String label;
    @Nonnull
    private final String className;
    private final String typeName;
    private final int displaySize;
    private final int type;
    private final int precision;
    private final int scale;
    private final boolean signed;
    private final int nullable;

    boolean isCaseSensitive() {
        return true;
    }

    boolean isCurrency() {
        return false;
    }

    boolean isAutoIncrement() {
        return false;
    }

    boolean isWritable() {
        return false;
    }

    boolean isReadOnly() {
        return true;
    }

    boolean isSearchable() {
        return true;
    }

    ColumnInfo(@Nonnull String catalogName, @Nonnull String schemaName, @Nonnull String tableName, @Nonnull String label, @Nonnull String className, String typeName, int displaySize, int type, int precision, int scale, boolean signed, int nullable) {
        if (catalogName == null) {
            throw new NullPointerException("catalogName is marked @NonNull but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked @NonNull but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked @NonNull but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked @NonNull but is null");
        }
        if (className == null) {
            throw new NullPointerException("className is marked @NonNull but is null");
        }
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.label = label;
        this.className = className;
        this.typeName = typeName;
        this.displaySize = displaySize;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
        this.signed = signed;
        this.nullable = nullable;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public String getCatalogName() {
        return this.catalogName;
    }

    @Nonnull
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public int getType() {
        return this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getNullable() {
        return this.nullable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo other = (ColumnInfo)o;
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        if (this.getDisplaySize() != other.getDisplaySize()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getPrecision() != other.getPrecision()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        if (this.isSigned() != other.isSigned()) {
            return false;
        }
        return this.getNullable() == other.getNullable();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        result = result * 59 + this.getDisplaySize();
        result = result * 59 + this.getType();
        result = result * 59 + this.getPrecision();
        result = result * 59 + this.getScale();
        result = result * 59 + (this.isSigned() ? 79 : 97);
        result = result * 59 + this.getNullable();
        return result;
    }

    public String toString() {
        return "ColumnInfo(catalogName=" + this.getCatalogName() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", label=" + this.getLabel() + ", className=" + this.getClassName() + ", typeName=" + this.getTypeName() + ", displaySize=" + this.getDisplaySize() + ", type=" + this.getType() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", signed=" + this.isSigned() + ", nullable=" + this.getNullable() + ")";
    }

    public static class Builder {
        private String label;
        private String className;
        private String typeName;
        private int type;
        private int precision;
        private int scale;
        private boolean signed;
        private String catalogName = "";
        private String schemaName = "";
        private String tableName = "";
        private int displaySize = Integer.MAX_VALUE;
        private int nullable = 1;

        Builder() {
        }

        public Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder displaySize(int displaySize) {
            this.displaySize = displaySize;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder scale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder signed(boolean signed) {
            this.signed = signed;
            return this;
        }

        public Builder nullable(int nullable) {
            this.nullable = nullable;
            return this;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this.catalogName, this.schemaName, this.tableName, this.label, this.className, this.typeName, this.displaySize, this.type, this.precision, this.scale, this.signed, this.nullable);
        }

        public String toString() {
            return "ColumnInfo.Builder(catalogName=" + this.catalogName + ", schemaName=" + this.schemaName + ", tableName=" + this.tableName + ", label=" + this.label + ", className=" + this.className + ", typeName=" + this.typeName + ", displaySize=" + this.displaySize + ", type=" + this.type + ", precision=" + this.precision + ", scale=" + this.scale + ", signed=" + this.signed + ", nullable=" + this.nullable + ")";
        }
    }
}

