/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import world.data.jdbc.internal.types.NodeValues;
import world.data.jdbc.internal.types.TypeMap;
import world.data.jdbc.internal.types.TypeMapping;
import world.data.jdbc.model.Blank;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Literal;
import world.data.jdbc.model.LiteralFactory;
import world.data.jdbc.model.Node;

public final class NodeConversions {
    private static final Map<Class<?>, ValueFunction<?>> VALUE_FUNCTIONS_BY_CLASS = new HashMap();
    private static final Map<Class<?>, NodeFunction<?>> NODE_FUNCTIONS_BY_CLASS = new HashMap();

    private static <T> void map(Class<T> clazz, ValueFunction<T> valueFn, NodeFunction<T> nodeFn) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(valueFn, "valueFn");
        if (VALUE_FUNCTIONS_BY_CLASS.put(clazz, valueFn) != null) {
            throw new IllegalStateException("ValueFunction already mapped for class");
        }
        if (nodeFn != null) {
            if ((clazz.getModifiers() & 0x600) != 0) {
                throw new IllegalStateException("NodeFunction doesn't make sense for abstract classes");
            }
            if (NODE_FUNCTIONS_BY_CLASS.put(clazz, nodeFn) != null) {
                throw new IllegalStateException("NodeFunction already mapped for class");
            }
        }
    }

    private static Object toObject(Node node) throws SQLException {
        if (node == null) {
            return null;
        }
        if (node instanceof Literal) {
            Literal literal = (Literal)node;
            TypeMapping mapping = TypeMap.INSTANCE.getStandardOrCustom(literal.getDatatype());
            return NodeConversions.toObject(node, mapping.getJavaType());
        }
        if (node instanceof Iri) {
            Iri iri = (Iri)node;
            return iri.toURI();
        }
        if (node instanceof Blank) {
            return node.toString();
        }
        throw new UnsupportedOperationException("Unknown node type");
    }

    public static <T> T toObject(Node node, Class<T> target) throws SQLException {
        if (node != null && target == node.getClass()) {
            return target.cast(node);
        }
        ValueFunction<?> valueFn = VALUE_FUNCTIONS_BY_CLASS.get(target);
        if (valueFn == null) {
            throw new SQLException(NodeValues.parseErrorMessage(node, target));
        }
        return target.cast(valueFn.toObject(node));
    }

    public static Object toObject(Node node, int jdbcType) throws SQLException {
        if (node == null) {
            return null;
        }
        TypeMapping mapping = TypeMap.INSTANCE.getStandard(jdbcType);
        if (mapping == null) {
            throw new SQLException("Unable to marshal to the declared column type: " + jdbcType);
        }
        Class<Object> javaType = mapping.getJavaType();
        if (jdbcType == -6 || jdbcType == 5) {
            javaType = Integer.class;
        }
        return NodeConversions.toObject(node, javaType);
    }

    public static String toString(Node node) throws SQLException {
        if (node == null) {
            return null;
        }
        if (node instanceof Literal) {
            return ((Literal)node).getLexicalForm();
        }
        if (node instanceof Iri) {
            return ((Iri)node).getIri();
        }
        if (node instanceof Blank) {
            return node.toString();
        }
        throw new SQLException("Unable to marshal unknown node types to a string");
    }

    public static Node toNode(Object obj) throws SQLException {
        if (obj == null || obj instanceof Node) {
            return (Node)obj;
        }
        try {
            NodeFunction<?> nodeFn = NODE_FUNCTIONS_BY_CLASS.get(obj.getClass());
            if (nodeFn != null) {
                return nodeFn.toNode(obj);
            }
            throw new SQLException("setObject() received a value that could not be converted to a RDF node for use in a SPARQL query");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException("Unexpected error trying to marshal a value to the desired target type", e);
        }
    }

    public static Node toNode(Object obj, int jdbcType) throws SQLException {
        try {
            if (obj == null) {
                return null;
            }
            switch (jdbcType) {
                case -8: 
                case -4: 
                case -3: 
                case -2: 
                case 0: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2009: 
                case 2011: {
                    throw new SQLException("The provided SQL Target Type cannot be translated into an appropriate RDF term type");
                }
                case 1111: 
                case 2000: {
                    return NodeConversions.toNode(obj);
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    if (obj instanceof String) {
                        return LiteralFactory.createString((String)obj);
                    }
                    return LiteralFactory.createString(NodeConversions.toString(NodeConversions.toNode(obj)));
                }
                case -7: 
                case 16: {
                    if (obj instanceof Boolean) {
                        return LiteralFactory.createBoolean((Boolean)obj);
                    }
                    return LiteralFactory.createBoolean(NodeValues.parseBoolean(NodeConversions.toNode(obj)));
                }
                case -6: 
                case -5: 
                case 2: 
                case 4: 
                case 5: {
                    if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
                        return LiteralFactory.createInteger(((Number)obj).longValue());
                    }
                    if (obj instanceof BigInteger) {
                        return LiteralFactory.createInteger((BigInteger)obj);
                    }
                    return LiteralFactory.createInteger(NodeValues.parseBigInteger(NodeConversions.toNode(obj)));
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    if (obj instanceof Double || obj instanceof Float) {
                        return LiteralFactory.createDecimal(BigDecimal.valueOf(((Number)obj).doubleValue()));
                    }
                    if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
                        return LiteralFactory.createDecimal(BigDecimal.valueOf(((Number)obj).longValue()));
                    }
                    if (obj instanceof BigDecimal) {
                        return LiteralFactory.createDecimal((BigDecimal)obj);
                    }
                    if (obj instanceof BigInteger) {
                        return LiteralFactory.createDecimal(new BigDecimal((BigInteger)obj));
                    }
                    return LiteralFactory.createDecimal(NodeValues.parseBigDecimal(NodeConversions.toNode(obj)));
                }
                case 91: {
                    if (obj instanceof TemporalAccessor) {
                        return LiteralFactory.createDate((TemporalAccessor)obj);
                    }
                    if (obj instanceof Date) {
                        return LiteralFactory.createDate((Date)obj);
                    }
                    return LiteralFactory.createDate(NodeValues.parseLocalDate(NodeConversions.toNode(obj)));
                }
                case 92: 
                case 2013: {
                    if (obj instanceof TemporalAccessor) {
                        return LiteralFactory.createTime((TemporalAccessor)obj);
                    }
                    if (obj instanceof Time) {
                        return LiteralFactory.createTime((Time)obj);
                    }
                    return LiteralFactory.createTime(NodeValues.parseBestTime(NodeConversions.toNode(obj)));
                }
                case 93: 
                case 2014: {
                    if (obj instanceof TemporalAccessor) {
                        return LiteralFactory.createDateTime((TemporalAccessor)obj);
                    }
                    if (obj instanceof Timestamp) {
                        return LiteralFactory.createDateTime((Timestamp)obj);
                    }
                    return LiteralFactory.createDateTime(NodeValues.parseBestDateTime(NodeConversions.toNode(obj)));
                }
            }
            throw new SQLException("Cannot translate an unknown SQL Target Type into an appropriate RDF term type");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException("Unexpected error trying to marshal a value to the desired target type", e);
        }
    }

    private NodeConversions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NodeConversions.map(Node.class, n -> n, null);
        NodeConversions.map(String.class, NodeConversions::toString, LiteralFactory::createString);
        NodeConversions.map(Object.class, NodeConversions::toObject, NodeConversions::toNode);
        NodeConversions.map(Boolean.TYPE, n -> NodeValues.parseBoolean(n, false), null);
        NodeConversions.map(Byte.TYPE, n -> NodeValues.parseByte(n, (byte)0), null);
        NodeConversions.map(Double.TYPE, n -> NodeValues.parseDouble(n, 0.0), null);
        NodeConversions.map(Float.TYPE, n -> Float.valueOf(NodeValues.parseFloat(n, 0.0f)), null);
        NodeConversions.map(Integer.TYPE, n -> NodeValues.parseInteger(n, 0), null);
        NodeConversions.map(Long.TYPE, n -> NodeValues.parseLong(n, 0L), null);
        NodeConversions.map(Short.TYPE, n -> NodeValues.parseShort(n, (short)0), null);
        NodeConversions.map(BigDecimal.class, NodeValues::parseBigDecimal, LiteralFactory::createDecimal);
        NodeConversions.map(BigInteger.class, NodeValues::parseBigInteger, LiteralFactory::createInteger);
        NodeConversions.map(Boolean.class, NodeValues::parseBoolean, LiteralFactory::createBoolean);
        NodeConversions.map(Byte.class, NodeValues::parseByte, LiteralFactory::createInteger);
        NodeConversions.map(Double.class, NodeValues::parseDouble, LiteralFactory::createDecimal);
        NodeConversions.map(Duration.class, NodeValues::parseDuration, LiteralFactory::createDayTimeDuration);
        NodeConversions.map(Float.class, NodeValues::parseFloat, LiteralFactory::createDecimal);
        NodeConversions.map(Integer.class, NodeValues::parseInteger, LiteralFactory::createInteger);
        NodeConversions.map(Instant.class, NodeValues::parseInstant, LiteralFactory::createDateTime);
        NodeConversions.map(LocalDate.class, NodeValues::parseLocalDate, LiteralFactory::createDate);
        NodeConversions.map(LocalDateTime.class, NodeValues::parseLocalDateTime, LiteralFactory::createDateTime);
        NodeConversions.map(LocalTime.class, NodeValues::parseLocalTime, LiteralFactory::createTime);
        NodeConversions.map(Long.class, NodeValues::parseLong, LiteralFactory::createInteger);
        NodeConversions.map(Month.class, NodeValues::parseMonth, LiteralFactory::createMonth);
        NodeConversions.map(MonthDay.class, NodeValues::parseMonthDay, LiteralFactory::createMonthDay);
        NodeConversions.map(Number.class, NodeValues::parseBestNumber, null);
        NodeConversions.map(OffsetDateTime.class, NodeValues::parseOffsetDateTime, LiteralFactory::createDateTime);
        NodeConversions.map(OffsetTime.class, NodeValues::parseOffsetTime, LiteralFactory::createTime);
        NodeConversions.map(Period.class, NodeValues::parsePeriod, LiteralFactory::createYearMonthDuration);
        NodeConversions.map(Short.class, NodeValues::parseShort, LiteralFactory::createInteger);
        NodeConversions.map(URI.class, NodeValues::parseUri, Iri::new);
        NodeConversions.map(Year.class, NodeValues::parseYear, LiteralFactory::createYear);
        NodeConversions.map(YearMonth.class, NodeValues::parseYearMonth, LiteralFactory::createYearMonth);
        NodeConversions.map(ZonedDateTime.class, NodeValues::parseZonedDateTime, LiteralFactory::createDateTime);
        NodeConversions.map(URL.class, NodeValues::parseUrl, Iri::new);
        NodeConversions.map(Date.class, NodeValues::parseSqlDate, LiteralFactory::createDate);
        NodeConversions.map(Time.class, NodeValues::parseSqlTime, LiteralFactory::createTime);
        NodeConversions.map(Timestamp.class, NodeValues::parseSqlTimestamp, LiteralFactory::createDateTime);
        NodeConversions.map(java.util.Date.class, NodeValues::parseUtilDate, LiteralFactory::createDate);
    }

    @FunctionalInterface
    private static interface NodeFunction<T> {
        public Node toNode(T var1) throws SQLException;
    }

    @FunctionalInterface
    private static interface ValueFunction<T> {
        public T toObject(Node var1) throws SQLException;
    }
}

