/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import javax.annotation.Nonnull;

class FileBackedInputStream
extends InputStream {
    private InputStream memIn;
    private final Sync sync;
    private File file;
    private final InputStream fileIn;
    private volatile boolean fileInClosed;
    private volatile Throwable throwable;

    FileBackedInputStream(InputStream in, int memLimit, Executor cachedThreadPool) throws IOException {
        int count;
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(cachedThreadPool, "cachedThreadPool");
        byte[] buf = new byte[memLimit];
        int length = 0;
        for (int remaining = memLimit; remaining > 0 && (count = in.read(buf, length, remaining)) != -1; remaining -= count) {
            length += count;
        }
        this.memIn = new ByteArrayInputStream(buf, 0, length);
        if (length < memLimit) {
            in.close();
            this.sync = null;
            this.fileIn = null;
            this.fileInClosed = true;
        } else {
            this.sync = new Sync();
            this.file = File.createTempFile("dw-jdbc", ".tmp");
            this.fileIn = new FileInputStream(this.file);
            FileOutputStream fileOut = new FileOutputStream(this.file);
            cachedThreadPool.execute(() -> this.copyAsync(in, fileOut));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAsync(InputStream source, OutputStream target) {
        try (InputStream in = source;
             OutputStream out = target;){
            int count;
            byte[] buf = new byte[4096];
            while (!this.fileInClosed && (count = in.read(buf)) != -1) {
                out.write(buf, 0, count);
                this.sync.releaseShared(count);
            }
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        finally {
            this.sync.releaseShared(Long.MAX_VALUE);
            this.deleteTempFile();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.memIn != null) {
            int b = this.memIn.read();
            if (b != -1) {
                return b;
            }
            this.memIn = null;
        }
        if (this.fileIn != null) {
            this.acquire(1);
            return this.fileIn.read();
        }
        return -1;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        if (this.memIn != null) {
            int count = this.memIn.read(b, off, len);
            if (count != -1) {
                return count;
            }
            this.memIn = null;
        }
        if (this.fileIn != null) {
            this.acquire(len);
            return this.fileIn.read(b, off, len);
        }
        return -1;
    }

    private void acquire(int len) throws IOException {
        try {
            this.sync.acquireSharedInterruptibly(len);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while reading from file.", e);
        }
        if (this.throwable != null) {
            throw new IOException(this.throwable.getMessage(), this.throwable);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.fileInClosed) {
            this.fileInClosed = true;
            this.fileIn.close();
            this.deleteTempFile();
        }
    }

    private synchronized void deleteTempFile() {
        if (this.fileInClosed && this.file != null && this.file.delete()) {
            this.file = null;
        }
    }

    private static class Sync
    extends AbstractQueuedLongSynchronizer {
        private Sync() {
        }

        @Override
        protected long tryAcquireShared(long acquires) {
            long current;
            long next;
            while ((next = (current = this.getState()) - acquires) >= 0L && !this.compareAndSetState(current, next)) {
            }
            return next;
        }

        @Override
        protected boolean tryReleaseShared(long releases) {
            long next;
            long current;
            do {
                current = this.getState();
                if (releases == Long.MAX_VALUE) {
                    next = Long.MAX_VALUE;
                    continue;
                }
                next = current + releases;
                if (next >= current) continue;
                throw new Error("Maximum count exceeded");
            } while (!this.compareAndSetState(current, next));
            return true;
        }
    }
}

