/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.results;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import world.data.jdbc.DataWorldStatement;
import world.data.jdbc.internal.results.ForwardOnlyResultSet;
import world.data.jdbc.internal.results.IndexBasedResultSet;
import world.data.jdbc.internal.results.ReadOnlyResultSet;
import world.data.jdbc.internal.types.NodeConversions;
import world.data.jdbc.internal.types.NodeValues;
import world.data.jdbc.internal.util.Conditions;
import world.data.jdbc.internal.util.ResourceContainer;
import world.data.jdbc.model.Node;

public final class ResultSetImpl
implements ResultSet,
ReadOnlyResultSet,
ForwardOnlyResultSet,
IndexBasedResultSet {
    private final DataWorldStatement statement;
    private final ResultSetMetaData metaData;
    private final Iterator<Node[]> rowIter;
    private AutoCloseable cleanup;
    private final Map<String, Integer> columnIndexByLabel;
    private SQLWarning warnings;
    private Node[] row;
    private boolean wasNull;
    private boolean closed;

    public ResultSetImpl(@Nullable DataWorldStatement statement, ResultSetMetaData metaData, List<Node[]> rows) throws SQLException {
        this(statement, metaData, rows.iterator(), null);
    }

    public ResultSetImpl(@Nullable DataWorldStatement statement, ResultSetMetaData metaData, Iterator<Node[]> rowIter, @Nullable AutoCloseable cleanup) throws SQLException {
        this.statement = statement;
        this.metaData = Objects.requireNonNull(metaData, "metaData");
        this.rowIter = Objects.requireNonNull(rowIter, "rowIter");
        this.cleanup = cleanup;
        if (statement != null) {
            ((ResourceContainer)((Object)statement)).getResources().register(this);
        }
        LinkedHashMap<String, Integer> columnIndexByLabel = new LinkedHashMap<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            columnIndexByLabel.put(metaData.getColumnLabel(i), i);
        }
        this.columnIndexByLabel = columnIndexByLabel;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Conditions.check(this.isWrapperFor(iface), "Not a wrapper for the desired interface");
        return iface.cast(this);
    }

    @Override
    public DataWorldStatement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.metaData;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        Conditions.check(rows >= 0, "Fetch size must be non-negative");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            this.cleanup();
        }
        finally {
            this.closed = true;
        }
    }

    private void cleanup() throws SQLException {
        if (this.statement != null) {
            ((ResourceContainer)((Object)this.statement)).getResources().remove(this);
        }
        if (this.cleanup != null) {
            try {
                this.cleanup.close();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Unexpected error closing the result set", e);
            }
            finally {
                this.cleanup = null;
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.rowIter.hasNext()) {
            this.row = this.rowIter.next();
            return true;
        }
        this.cleanup();
        this.row = null;
        return false;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        Integer index = this.columnIndexByLabel.get(columnLabel);
        Conditions.check(index != null, "The given column does not exist in the result set");
        return index;
    }

    @Nullable
    private Node getNode(int columnIndex) throws SQLException {
        this.checkClosed();
        Conditions.check(this.row != null, "Not currently at a row");
        Conditions.check(columnIndex >= 1 && columnIndex <= this.row.length, "Column index out-of-bounds");
        Node node = this.row[columnIndex - 1];
        this.wasNull = node == null;
        return node;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    private void checkClosed() throws SQLException {
        Conditions.check(!this.closed, "Result Set is closed");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return NodeValues.parseBigDecimal(this.getNode(columnIndex));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return NodeValues.parseBoolean(this.getNode(columnIndex), false);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return NodeValues.parseByte(this.getNode(columnIndex), (byte)0);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return NodeValues.parseSqlDate(this.getNode(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return NodeValues.parseSqlDate(this.getNode(columnIndex), calendar);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return NodeValues.parseDouble(this.getNode(columnIndex), 0.0);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return NodeValues.parseFloat(this.getNode(columnIndex), 0.0f);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return NodeValues.parseInteger(this.getNode(columnIndex), 0);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return NodeValues.parseLong(this.getNode(columnIndex), 0L);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return NodeConversions.toString(this.getNode(columnIndex));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int jdbcType = this.getMetaData().getColumnType(columnIndex);
        return NodeConversions.toObject(this.getNode(columnIndex), jdbcType);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Conditions.check(type != null, "Type argument may not be null");
        return NodeConversions.toObject(this.getNode(columnIndex), type);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return NodeValues.parseShort(this.getNode(columnIndex), (short)0);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return NodeConversions.toString(this.getNode(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return NodeValues.parseSqlTime(this.getNode(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return NodeValues.parseSqlTime(this.getNode(columnIndex), calendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return NodeValues.parseSqlTimestamp(this.getNode(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return NodeValues.parseSqlTimestamp(this.getNode(columnIndex), calendar);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return NodeValues.parseUrl(this.getNode(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getBigDecimal() is supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getDate() is supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getObject() is supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

