/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import world.data.jdbc.internal.metadata.ColumnInfo;
import world.data.jdbc.internal.util.Conditions;

public final class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private final List<ColumnInfo> columns;

    public ResultSetMetaDataImpl(ColumnInfo ... columns) {
        this(Arrays.asList(columns));
    }

    public ResultSetMetaDataImpl(List<ColumnInfo> columns) {
        this.columns = Objects.requireNonNull(columns, "columns");
        for (ColumnInfo column : columns) {
            Objects.requireNonNull(column, "column");
        }
    }

    private ColumnInfo getColumnInfo(int column) throws SQLException {
        Conditions.check(column >= 1 && column <= this.columns.size(), "Column Index is out of bounds");
        return this.columns.get(column - 1);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Conditions.check(this.isWrapperFor(iface), "Not a wrapper for the desired interface");
        return iface.cast(this);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnInfo(column).getCatalogName();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnInfo(column).getClassName();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnInfo(column).getDisplaySize();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnInfo(column).getLabel();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInfo(column).getLabel();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumnInfo(column).getType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnInfo(column).getTypeName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumnInfo(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInfo(column).getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumnInfo(column).getSchemaName();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumnInfo(column).getTableName();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumnInfo(column).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumnInfo(column).isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getColumnInfo(column).isCurrency();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumnInfo(column).getNullable();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getColumnInfo(column).isReadOnly();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumnInfo(column).isSearchable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInfo(column).isSigned();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getColumnInfo(column).isWritable();
    }
}

