/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import world.data.jdbc.internal.util.Optionals;
import world.data.jdbc.model.Blank;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Literal;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Rdfs;
import world.data.jdbc.vocab.Xsd;

public final class NodeValues {
    private static final Iri[] INTEGER_TYPES = new Iri[]{Xsd.INTEGER, Xsd.BYTE, Xsd.INT, Xsd.SHORT, Xsd.LONG, Xsd.UNSIGNEDBYTE, Xsd.UNSIGNEDINT, Xsd.UNSIGNEDSHORT, Xsd.UNSIGNEDLONG, Xsd.POSITIVEINTEGER, Xsd.NEGATIVEINTEGER, Xsd.NONPOSITIVEINTEGER, Xsd.NONNEGATIVEINTEGER};
    private static final Iri[] BOOLEAN_AND_NUMBER_TYPES = NodeValues.append(INTEGER_TYPES, Xsd.BOOLEAN, Xsd.DECIMAL, Xsd.DOUBLE, Xsd.FLOAT);
    private static final Iri[] BOOLEAN_AND_NUMERIC_TYPES = NodeValues.append(BOOLEAN_AND_NUMBER_TYPES, Xsd.GYEAR, Xsd.GMONTH, Xsd.GDAY);
    private static final DateTimeFormatter ISO_MONTH = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter();
    private static final DateTimeFormatter ISO_DAY = new DateTimeFormatterBuilder().appendLiteral("---").appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).toFormatter();
    private static final long LONG_PRECISION = Long.toString(Long.MAX_VALUE).length();

    public static TemporalAccessor parseBestTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, TemporalAccessor.class, (String s) -> DateTimeFormatter.ISO_TIME.parseBest(s, OffsetTime::from, LocalTime::from), Xsd.TIME, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static TemporalAccessor parseBestDateTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, TemporalAccessor.class, (String s) -> DateTimeFormatter.ISO_DATE_TIME.parseBest(s, OffsetDateTime::from, LocalDateTime::from), Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static Number parseBestNumber(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Number.class, lexicalForm -> {
            if (lexicalForm.indexOf(46) != -1) {
                return NodeValues.parseDouble(lexicalForm);
            }
            if ((long)lexicalForm.length() < LONG_PRECISION + (long)(lexicalForm.startsWith("-") ? 1 : 0)) {
                return Long.parseLong(lexicalForm);
            }
            BigInteger n = new BigInteger(lexicalForm);
            long l = n.longValue();
            return n.equals(BigInteger.valueOf(l)) ? Long.valueOf(l) : n;
        });
    }

    public static BigDecimal parseBigDecimal(Node node) throws SQLException {
        return NodeValues.parseNumber(node, BigDecimal.class, BigDecimal::new);
    }

    public static BigInteger parseBigInteger(Node node) throws SQLException {
        return NodeValues.parseNumber(node, BigInteger.class, BigInteger::new);
    }

    public static Boolean parseBoolean(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Boolean.class, (String lexicalForm, Iri datatype, String language) -> {
            if (Xsd.BOOLEAN.equals(datatype)) {
                return Boolean.parseBoolean(lexicalForm);
            }
            if (Xsd.STRING.equals(datatype)) {
                return NodeValues.parseStringAsBoolean(lexicalForm);
            }
            return NodeValues.parseNumberAsBoolean(lexicalForm);
        }, BOOLEAN_AND_NUMBER_TYPES);
    }

    private static Boolean parseStringAsBoolean(String lexicalForm) {
        char ch = lexicalForm.isEmpty() ? (char)'\u0000' : Character.toLowerCase(lexicalForm.charAt(0));
        return ch == 't' || ch == 'y' || ch == '1' || "-1".equals(lexicalForm);
    }

    private static Boolean parseNumberAsBoolean(String lexicalForm) {
        String lex = lexicalForm;
        int dot = lex.indexOf(46);
        if (dot != -1) {
            lex = lex.substring(0, dot);
        }
        try {
            return Long.parseLong(lex) != 0L;
        }
        catch (NumberFormatException e) {
            double d = NodeValues.parseDouble(lex);
            return d != 0.0 && !Double.isNaN(d);
        }
    }

    public static boolean parseBoolean(Node node, boolean defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseBoolean(node), defaultValue);
    }

    private static <V> V parseNumber(Node node, Class<V> clazz, Parser<V> parser) throws SQLException {
        return (V)NodeValues.parseLiteral(node, clazz, (String lexicalForm, Iri datatype, String language) -> {
            if (Xsd.BOOLEAN.equals(datatype)) {
                lexicalForm = Boolean.parseBoolean(lexicalForm) ? "1" : "0";
            } else if (Xsd.GYEAR.equals(datatype)) {
                lexicalForm = Integer.toString(Year.parse(lexicalForm).getValue());
            } else if (Xsd.GMONTH.equals(datatype)) {
                lexicalForm = Integer.toString(NodeValues.parseMonth(lexicalForm).getValue());
            } else if (Xsd.GDAY.equals(datatype)) {
                lexicalForm = Integer.toString(NodeValues.parseDay(lexicalForm));
            }
            return parser.parse(lexicalForm);
        }, BOOLEAN_AND_NUMERIC_TYPES);
    }

    public static Byte parseByte(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Byte.class, Byte::decode);
    }

    public static byte parseByte(Node node, byte defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseByte(node), defaultValue);
    }

    public static Integer parseDay(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Integer.class, (String lexicalForm, Iri datatype, String language) -> {
            if (Xsd.GDAY.equals(datatype)) {
                return NodeValues.parseDay(lexicalForm);
            }
            return ChronoField.DAY_OF_MONTH.checkValidIntValue(Integer.parseInt(lexicalForm));
        }, NodeValues.append(INTEGER_TYPES, Xsd.GDAY));
    }

    private static int parseDay(String string) {
        return ISO_DAY.parse(string).get(ChronoField.DAY_OF_MONTH);
    }

    public static Double parseDouble(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Double.class, NodeValues::parseDouble);
    }

    private static Double parseDouble(String lexicalForm) {
        if ("INF".equals(lexicalForm)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(lexicalForm)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(lexicalForm);
    }

    public static double parseDouble(Node node, double defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseDouble(node), defaultValue);
    }

    public static Duration parseDuration(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Duration.class, Duration::parse, Xsd.DAYTIMEDURATION);
    }

    public static Float parseFloat(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Float.class, NodeValues::parseFloat);
    }

    private static Float parseFloat(String lexicalForm) {
        if ("INF".equals(lexicalForm)) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        if ("-INF".equals(lexicalForm)) {
            return Float.valueOf(Float.NEGATIVE_INFINITY);
        }
        return Float.valueOf(Float.parseFloat(lexicalForm));
    }

    public static float parseFloat(Node node, float defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseFloat(node), Float.valueOf(defaultValue)).floatValue();
    }

    public static Integer parseInteger(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Integer.class, Integer::parseInt);
    }

    public static int parseInteger(Node node, int defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseInteger(node), defaultValue);
    }

    public static Instant parseInstant(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Instant.class, Instant::parse, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static LocalDate parseLocalDate(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, LocalDate.class, LocalDate::parse, Xsd.DATE, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static LocalDateTime parseLocalDateTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, LocalDateTime.class, LocalDateTime::parse, Xsd.DATE, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static LocalTime parseLocalTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, LocalTime.class, LocalTime::parse, Xsd.TIME, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static Long parseLong(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Long.class, Long::parseLong);
    }

    public static long parseLong(Node node, long defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseLong(node), defaultValue);
    }

    public static Month parseMonth(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Month.class, (String lexicalForm, Iri datatype, String language) -> {
            if (Xsd.GMONTH.equals(datatype)) {
                return NodeValues.parseMonth(lexicalForm);
            }
            return Month.of(Integer.parseInt(lexicalForm));
        }, NodeValues.append(INTEGER_TYPES, Xsd.GMONTH));
    }

    private static Month parseMonth(String s) {
        return ISO_MONTH.parse((CharSequence)s, Month::from);
    }

    public static MonthDay parseMonthDay(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, MonthDay.class, MonthDay::parse, Xsd.GMONTHDAY);
    }

    public static OffsetDateTime parseOffsetDateTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, OffsetDateTime.class, OffsetDateTime::parse, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static OffsetTime parseOffsetTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, OffsetTime.class, OffsetTime::parse, Xsd.TIME, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static Period parsePeriod(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Period.class, Period::parse, Xsd.YEARMONTHDURATION);
    }

    public static Short parseShort(Node node) throws SQLException {
        return NodeValues.parseNumber(node, Short.class, Short::parseShort);
    }

    public static short parseShort(Node node, short defaultValue) throws SQLException {
        return Optionals.or(NodeValues.parseShort(node), defaultValue);
    }

    public static ZonedDateTime parseZonedDateTime(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, ZonedDateTime.class, ZonedDateTime::parse, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    @Deprecated
    public static java.util.Date parseUtilDate(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, java.util.Date.class, (String s) -> new java.util.Date(NodeValues.parseCalendar(s, Calendar.getInstance()).getTimeInMillis()), Xsd.DATE, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    @Deprecated
    public static Date parseSqlDate(Node node) throws SQLException {
        return NodeValues.parseSqlDate(node, Calendar.getInstance());
    }

    @Deprecated
    public static Date parseSqlDate(Node node, Calendar calendar) throws SQLException {
        return NodeValues.parseLiteral(node, Date.class, (String s) -> new Date(NodeValues.parseCalendar(s, calendar).getTimeInMillis()), Xsd.DATE, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    @Deprecated
    public static Time parseSqlTime(Node node) throws SQLException {
        return NodeValues.parseSqlTime(node, Calendar.getInstance());
    }

    @Deprecated
    public static Time parseSqlTime(Node node, Calendar calendar) throws SQLException {
        return NodeValues.parseLiteral(node, Time.class, (String s) -> new Time(NodeValues.parseCalendar(s, calendar).getTimeInMillis()), Xsd.TIME, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    @Deprecated
    public static Timestamp parseSqlTimestamp(Node node) throws SQLException {
        return NodeValues.parseSqlTimestamp(node, Calendar.getInstance());
    }

    @Deprecated
    public static Timestamp parseSqlTimestamp(Node node, Calendar calendar) throws SQLException {
        return NodeValues.parseLiteral(node, Timestamp.class, (String s) -> new Timestamp(NodeValues.parseCalendar(s, calendar).getTimeInMillis()), Xsd.DATE, Xsd.TIME, Xsd.DATETIME, Xsd.DATETIMESTAMP);
    }

    public static URI parseUri(Node node) throws SQLException {
        return NodeValues.parseLiteralOrIri(node, URI.class, URI::new, Rdfs.RESOURCE, Xsd.ANYURI);
    }

    @Deprecated
    public static URL parseUrl(Node node) throws SQLException {
        return NodeValues.parseLiteralOrIri(node, URL.class, s -> new URI(s).toURL(), Rdfs.RESOURCE, Xsd.ANYURI);
    }

    public static Year parseYear(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, Year.class, (String lexicalForm, Iri datatype, String language) -> {
            if (Xsd.GYEAR.equals(datatype)) {
                return Year.parse(lexicalForm);
            }
            return Year.of(Integer.parseInt(lexicalForm));
        }, NodeValues.append(INTEGER_TYPES, Xsd.GYEAR));
    }

    public static YearMonth parseYearMonth(Node node) throws SQLException {
        return NodeValues.parseLiteral(node, YearMonth.class, YearMonth::parse, Xsd.GYEARMONTH);
    }

    private static Calendar parseCalendar(String lexicalForm, Calendar calendar) {
        XMLGregorianCalendar xmlCalendar = XmlHolder.DATATYPE_FACTORY.newXMLGregorianCalendar(lexicalForm);
        if (xmlCalendar.getTimezone() != Integer.MIN_VALUE) {
            calendar.setTimeZone(xmlCalendar.getTimeZone(Integer.MIN_VALUE));
        }
        NodeValues.setWithDefault(calendar, 1, xmlCalendar.getYear(), 1970, 0);
        NodeValues.setWithDefault(calendar, 2, xmlCalendar.getMonth(), 1, -1);
        NodeValues.setWithDefault(calendar, 5, xmlCalendar.getDay(), 1, 0);
        NodeValues.setWithDefault(calendar, 11, xmlCalendar.getHour(), 0, 0);
        NodeValues.setWithDefault(calendar, 12, xmlCalendar.getMinute(), 0, 0);
        NodeValues.setWithDefault(calendar, 13, xmlCalendar.getSecond(), 0, 0);
        NodeValues.setWithDefault(calendar, 14, xmlCalendar.getMillisecond(), 0, 0);
        return calendar;
    }

    private static void setWithDefault(Calendar calendar, int field, int value, int defaultValue, int adjust) {
        calendar.set(field, (value != Integer.MIN_VALUE ? value : defaultValue) + adjust);
    }

    private static <V> V parseLiteral(Node node, Class<V> clazz, Parser<V> parser, Iri ... allowedTypes) throws SQLException {
        return (V)NodeValues.parseLiteral(node, clazz, (String lexicalForm, Iri datatype, String language) -> parser.parse(lexicalForm), allowedTypes);
    }

    private static <V> V parseLiteral(Node node, Class<V> clazz, LiteralParser<V> parser, Iri ... allowedTypes) throws SQLException {
        if (node == null) {
            return null;
        }
        if (!(node instanceof Literal)) {
            throw new SQLException(NodeValues.parseErrorMessage(node, clazz));
        }
        Literal literal = (Literal)node;
        if (!(Arrays.asList(allowedTypes).contains(literal.getDatatype()) || literal.getDatatype().equals(Xsd.STRING) && literal.getLanguage() == null)) {
            throw new SQLException(NodeValues.parseErrorMessage(node, clazz));
        }
        try {
            return parser.parse(literal.getLexicalForm(), literal.getDatatype(), literal.getLanguage());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(NodeValues.parseErrorMessage(node, clazz), e);
        }
    }

    private static <V> V parseIri(Node node, Class<V> clazz, Parser<V> parser) throws SQLException {
        if (node == null) {
            return null;
        }
        if (!(node instanceof Iri)) {
            throw new SQLException(NodeValues.parseErrorMessage(node, clazz));
        }
        Iri iri = (Iri)node;
        try {
            return parser.parse(iri.getIri());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(NodeValues.parseErrorMessage(node, clazz), e);
        }
    }

    private static <V> V parseLiteralOrIri(Node node, Class<V> clazz, Parser<V> parser, Iri ... allowedLiteralTypes) throws SQLException {
        if (node == null) {
            return null;
        }
        if (node instanceof Literal) {
            return NodeValues.parseLiteral(node, clazz, parser, allowedLiteralTypes);
        }
        if (node instanceof Iri) {
            return NodeValues.parseIri(node, clazz, parser);
        }
        throw new SQLException(NodeValues.parseErrorMessage(node, clazz));
    }

    static <V> String parseErrorMessage(Node source, Class<V> target) {
        return String.format("Unable to marshal %s to %s", NodeValues.typeName(source), target.getName());
    }

    private static String typeName(Node node) {
        if (node instanceof Literal) {
            String string = ((Literal)node).getDatatype().getIri();
            switch (NodeValues.getNamespace(string)) {
                case "http://www.w3.org/2000/01/rdf-schema#": {
                    return "rdfs:" + NodeValues.getFragment(string);
                }
                case "http://www.w3.org/2001/XMLSchema#": {
                    return "xsd:" + NodeValues.getFragment(string);
                }
            }
            return string;
        }
        if (node instanceof Iri) {
            return "iri";
        }
        if (node instanceof Blank) {
            return "blank node";
        }
        return "unknown node";
    }

    private static String getNamespace(String uri) {
        return uri.substring(0, uri.indexOf(35) + 1);
    }

    private static String getFragment(String uri) {
        return uri.substring(uri.indexOf(35) + 1);
    }

    @SafeVarargs
    private static <T> T[] append(T[] a, T ... b) {
        T[] t = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, t, a.length, b.length);
        return t;
    }

    private NodeValues() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    private static interface LiteralParser<V> {
        public V parse(String var1, Iri var2, String var3) throws Exception;
    }

    @FunctionalInterface
    private static interface Parser<V> {
        public V parse(String var1) throws Exception;
    }

    private static class XmlHolder {
        static final DatatypeFactory DATATYPE_FACTORY = XmlHolder.newDatatypeFactory();

        private XmlHolder() {
        }

        private static DatatypeFactory newDatatypeFactory() {
            try {
                return DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                throw new IllegalStateException("Can't create a javax.xml.datatype.DatatypeFactory", ex);
            }
        }
    }
}

