/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.internal.metadata.AbstractDatabaseMetaData;
import world.data.jdbc.internal.metadata.MetaDataSchema;
import world.data.jdbc.internal.util.Optionals;

public final class SparqlDatabaseMetaData
extends AbstractDatabaseMetaData {
    public SparqlDatabaseMetaData(DataWorldConnection connection, String catalog, String schema) {
        super(connection, catalog, schema);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return MetaDataSchema.newResultSet(MetaDataSchema.COLUMN_COLUMNS, new Object[0][]);
    }

    @Override
    public String getIdentifierQuoteString() {
        return " ";
    }

    @Override
    String getLiteralQuoteString() {
        return "\"";
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 3;
    }

    @Override
    public String getNumericFunctions() {
        return String.join((CharSequence)",", "ABS", "CEIL", "FLOOR", "RAND", "ROUND");
    }

    @Override
    public String getSQLKeywords() {
        return String.join((CharSequence)",", "ABS", "ADD", "ALL", "AS", "ASC", "ASK", "AVG", "BASE", "BIND", "BNODE", "BOUND", "BY", "CEIL", "CLEAR", "COALESCE", "CONCAT", "CONSTRUCT", "CONTAINS", "COPY", "COUNT", "CREATE", "DATATYPE", "DAY", "DEFAULT", "DELETEDATA", "DELETEWHERE", "DESC", "DESCRIBE", "DISTINCT", "DROP", "ENCODE_FOR_URI", "EXISTS", "FILTER", "FLOOR", "FROM", "GRAPH", "GROUP", "GROUP_CONCAT", "HAVING", "HOURS", "IF", "IN", "INSERT", "INSERTDATA", "INTO", "IRI", "ISBLANK", "ISIRI", "ISURI", "LANG", "LANGMATCHES", "LCASE", "LIMIT", "LOAD", "MAX", "MD5", "MIN", "MINUS", "MINUTES", "MONTH", "MOVE", "NAMED", "NOTEXISTS", "NOTIN", "NOW", "OFFSET", "OPTIONAL", "ORDER", "PREFIX", "RAND", "REDUCED", "REGEX", "REPLACE", "ROUND", "SAMETERM", "SAMPLE", "SECONDS", "SELECT", "SEPARATOR", "SERVICE", "SHA1", "SHA256", "SHA384", "SHA512", "SILENT", "STR", "STRAFTER", "STRBEFORE", "STRDT", "STRENDS", "STRLANG", "STRLEN", "STRSTARTS", "STRUUID", "SUBSTR", "SUM", "TIMEZONE", "TZ", "UCASE", "UNDEF", "UNION", "URI", "USING", "UUID", "VALUES", "WHERE", "WITH", "YEAR", "a", "false", "true");
    }

    @Override
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public String getStringFunctions() {
        return String.join((CharSequence)",", "CONCAT", "CONTAINS", "ENCODE_FOR_URI", "LANG", "LANGMATCHES", "LCASE", "REGEX", "REPLACE", "STR", "STRAFTER", "STRBEFORE", "STRENDS", "STRLEN", "STRSTARTS", "SUBSTR", "UCASE");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Object[][] rows = new Object[][]{{"TABLE"}};
        return MetaDataSchema.newResultSet(MetaDataSchema.TABLE_TYPE_COLUMNS, rows);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (Optionals.nullOrEquals(catalog, this.catalog) && Optionals.nullOrMatches(schemaPattern, this.schema) && Optionals.nullOrMatches(tableNamePattern, "RDF") && Optionals.nullOrContains(types, "TABLE")) {
            rows.add(new Object[]{this.catalog, this.schema, "RDF", "TABLE", "", null, null, null, null, null});
        }
        return MetaDataSchema.newResultSet(MetaDataSchema.TABLE_COLUMNS, rows);
    }

    @Override
    public String getTimeDateFunctions() {
        return String.join((CharSequence)",", "DAY", "HOURS", "MINUTES", "MONTH", "NOW", "SECONDS", "TIMEZONE", "TZ", "YEAR");
    }

    @Override
    public String getURL() throws SQLException {
        return "jdbc:data:world:sparql:" + this.catalog + ":" + this.schema;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }
}

