/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import world.data.jdbc.internal.util.Conditions;

public class ParameterMetaDataImpl
implements ParameterMetaData {
    private final int paramCount;

    public ParameterMetaDataImpl(int paramCount) throws SQLException {
        this.paramCount = paramCount;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Conditions.check(this.isWrapperFor(iface), "Not a wrapper for the desired interface");
        return iface.cast(this);
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return Object.class.getCanonicalName();
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2000;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return Object.class.getCanonicalName();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return false;
    }

    private void checkParamIndex(int param) throws SQLException {
        Conditions.check(param >= 1 && param <= this.paramCount, "Parameter Index is out of bounds");
    }
}

