/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.connections;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import world.data.jdbc.DataWorldCallableStatement;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.DataWorldPreparedStatement;
import world.data.jdbc.DataWorldStatement;
import world.data.jdbc.JdbcCompatibility;
import world.data.jdbc.internal.query.QueryEngine;
import world.data.jdbc.internal.statements.CallableStatementImpl;
import world.data.jdbc.internal.statements.PreparedStatementImpl;
import world.data.jdbc.internal.statements.StatementImpl;
import world.data.jdbc.internal.util.Conditions;
import world.data.jdbc.internal.util.Optionals;
import world.data.jdbc.internal.util.ResourceContainer;
import world.data.jdbc.internal.util.ResourceManager;

public final class ConnectionImpl
implements DataWorldConnection,
ResourceContainer {
    private static final Logger log = Logger.getLogger(ConnectionImpl.class.getName());
    private final QueryEngine queryEngine;
    private final DatabaseMetaData metadata;
    private final ResourceManager resources = new ResourceManager();
    private Properties clientInfo = new Properties();
    private SQLWarning warnings;
    private JdbcCompatibility compatibilityLevel;
    private boolean closed;

    public ConnectionImpl(QueryEngine queryEngine, JdbcCompatibility compatibilityLevel) throws SQLException {
        this.queryEngine = Objects.requireNonNull(queryEngine, "queryEngine");
        this.compatibilityLevel = Optionals.or(compatibilityLevel, queryEngine.getDefaultCompatibilityLevel());
        this.metadata = queryEngine.getDatabaseMetaData(this);
    }

    @Override
    public ResourceManager getResources() {
        return this.resources;
    }

    @Override
    public JdbcCompatibility getJdbcCompatibilityLevel() throws SQLException {
        this.checkClosed();
        return this.compatibilityLevel;
    }

    @Override
    public void setJdbcCompatibilityLevel(JdbcCompatibility compatibilityLevel) throws SQLException {
        this.checkClosed();
        this.compatibilityLevel = Objects.requireNonNull(compatibilityLevel, "compatibilityLevel");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return DataWorldConnection.class.equals(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Conditions.check(this.isWrapperFor(iface), "Not a wrapper for the desired interface");
        return iface.cast(this);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public final void close() throws SQLException {
        if (this.closed) {
            return;
        }
        log.fine("Closing connection...");
        try {
            this.resources.close();
        }
        catch (Exception e) {
            log.warning("Unexpected trying to close resources: " + e);
        }
        finally {
            this.closed = true;
            log.fine("Connection was closed");
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DataWorldStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public DataWorldStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        Conditions.checkSupported(resultSetType == 1003, "data.world connections only support forward-scrolling result sets");
        Conditions.checkSupported(resultSetConcurrency == 1007, "Remote endpoint backed connections only support read-only result sets");
        return new StatementImpl(this.queryEngine, this);
    }

    @Override
    public final DataWorldStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.queryEngine.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return this.clientInfo.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.metadata;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public boolean isValid(int timeout) {
        return !this.closed;
    }

    @Override
    public String nativeSQL(String query) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DataWorldCallableStatement prepareCall(String query) throws SQLException {
        return this.prepareCall(query, 1003, 1007);
    }

    @Override
    public DataWorldCallableStatement prepareCall(String query, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        Conditions.checkSupported(resultSetType == 1003, "Does not support scroll sensitive result sets");
        Conditions.checkSupported(resultSetConcurrency == 1007, "Only support read-only result sets");
        return new CallableStatementImpl(query, this.queryEngine, this);
    }

    @Override
    public DataWorldCallableStatement prepareCall(String query, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(query, resultSetType, resultSetConcurrency);
    }

    @Override
    public DataWorldPreparedStatement prepareStatement(String query) throws SQLException {
        return this.prepareStatement(query, 1003, 1007);
    }

    @Override
    public DataWorldPreparedStatement prepareStatement(String query, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        Conditions.checkSupported(autoGeneratedKeys == 2, "Does not support auto-generated keys");
        return this.prepareStatement(query, 1003, 1007);
    }

    @Override
    public DataWorldPreparedStatement prepareStatement(String query, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DataWorldPreparedStatement prepareStatement(String query, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DataWorldPreparedStatement prepareStatement(String query, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        Conditions.checkSupported(resultSetType == 1003, "Does not support scroll sensitive result sets");
        Conditions.checkSupported(resultSetConcurrency == 1007, "Only supports read-only result sets");
        return new PreparedStatementImpl(query, this.queryEngine, this);
    }

    @Override
    public DataWorldPreparedStatement prepareStatement(String query, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(query, resultSetType, resultSetConcurrency);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        Conditions.check(this.queryEngine.getCatalog().equals(catalog), "Catalog property is read-only");
    }

    @Override
    public void setClientInfo(Properties properties) {
        this.clientInfo = properties;
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.put(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (holdability != 2) {
            throw new SQLRecoverableException(String.format("%d is not a valid holdability setting", holdability));
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        Conditions.check(readOnly, "data.world does not support read/write connections");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        Conditions.checkSupported(level == 0, "Transactions are not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        Conditions.check(this.queryEngine.getSchema().equals(schema), "Schema property is read-only");
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.queryEngine.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void checkClosed() throws SQLException {
        Conditions.check(!this.closed, "Connection is closed");
    }
}

