/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.statements;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jena.jdbc.statements.metadata.JenaParameterMetadata;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import world.data.jdbc.results.AskResults;
import world.data.jdbc.results.SelectResults;
import world.data.jdbc.results.TripleIteratorResults;
import world.data.jdbc.statements.DataWorldStatement;
import world.data.jdbc.statements.QueryBuilder;

public class SparqlStatementQueryBuilder
implements QueryBuilder {
    @Override
    public Query buildQuery(String sql) throws SQLException {
        try {
            return QueryFactory.create(sql);
        }
        catch (Exception e2) {
            throw new SQLException("Not a valid SPARQL query", e2);
        }
    }

    @Override
    public ParameterMetaData buildParameterMetadata(String query) throws SQLException {
        return new JenaParameterMetadata(new ParameterizedSparqlString(query));
    }

    @Override
    public ResultSet buildResults(DataWorldStatement statement, Query q, QueryExecution qe) throws SQLException {
        if (q.isSelectType()) {
            return new SelectResults(statement, qe, qe.execSelect());
        }
        if (q.isAskType()) {
            boolean askRes = qe.execAsk();
            qe.close();
            return new AskResults(statement, askRes);
        }
        if (q.isDescribeType()) {
            return new TripleIteratorResults(statement, qe, qe.execDescribeTriples());
        }
        return new TripleIteratorResults(statement, qe, qe.execDescribeTriples());
    }
}

