/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.results;

import java.sql.SQLException;
import org.apache.jena.query.QueryExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.data.jdbc.results.DataWorldResultsSet;
import world.data.jdbc.statements.DataWorldStatement;

public abstract class QueryExecutionResults
extends DataWorldResultsSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExecutionResults.class);
    private QueryExecution qe;

    public QueryExecutionResults(DataWorldStatement statement, QueryExecution qe) throws SQLException {
        super(statement);
        if (qe == null) {
            throw new SQLException("Query Execution cannot be null");
        }
        this.qe = qe;
    }

    @Override
    public final void close() throws SQLException {
        if (this.qe != null) {
            try {
                this.qe.close();
            }
            catch (Exception e2) {
                LOGGER.error("Unexpected error closing underlying query execution", e2);
                throw new SQLException("Unexpected error closing the query execution", e2);
            }
            finally {
                this.qe = null;
            }
        }
        this.closeInternal();
    }

    protected abstract void closeInternal() throws SQLException;

    @Override
    public final boolean isClosed() {
        return this.qe == null;
    }
}

