/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.GLib;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterStreamRDFBatched;
import org.apache.jena.sparql.core.Quad;

public class WriterStreamRDFBlocks
extends WriterStreamRDFBatched {
    protected static final boolean NL_GDFT_START = false;
    protected static final boolean NL_GNMD_START = true;
    protected static final boolean NL_GDFT_END = true;
    protected static final boolean NL_GNMD_END = true;
    protected static final int INDENT_PREDICATE = 8;
    protected static final int MIN_PREDICATE = 6;
    protected static final int LONG_PREDICATE = 30;
    protected static final int LONG_SUBJECT = 20;
    protected static final int INDENT_MIN_S = 6;
    protected static final int INDENT_MAX_S = 14;
    protected static final int GAP_S_P = 2;
    protected static final int GAP_P_O = 2;
    protected static final int INDENT_GDFT = 2;
    protected static final int INDENT_GNMD = 4;
    protected Node lastGraph = null;
    protected Node lastSubject = null;
    protected boolean firstGraph = true;
    protected int currentGraphIndent = 0;

    public WriterStreamRDFBlocks(OutputStream output) {
        super(output);
    }

    public WriterStreamRDFBlocks(Writer output) {
        super(output);
    }

    public WriterStreamRDFBlocks(IndentedWriter output) {
        super(output);
    }

    @Override
    protected void printBatchQuads(Node g, Node s, List<Quad> quads) {
        if (g == null) {
            g = Quad.defaultGraphNodeGenerated;
        }
        if (Objects.equals(g, this.lastGraph)) {
            this.out.println(" .");
            this.out.println();
        } else {
            this.endGraph(g);
            this.startGraph(g);
            this.lastGraph = g;
        }
        List<Triple> triples = GLib.quads2triples(quads.iterator()).toList();
        this.printBatch(s, triples);
        this.lastSubject = s;
    }

    private void gap(int gap) {
        this.out.print(' ', gap);
    }

    @Override
    protected void printBatchTriples(Node s, List<Triple> triples) {
        if (this.out.getRow() > 1) {
            this.out.println();
        }
        this.printBatch(s, triples);
        this.out.print(" .");
        this.out.println();
    }

    private void printBatch(Node s, List<Triple> triples) {
        this.outputNode(s);
        if (this.out.getCol() > 20) {
            this.out.println();
        } else {
            this.gap(2);
        }
        this.out.incIndent(8);
        this.out.pad();
        this.writePredicateObjectList(triples);
        this.out.decIndent(8);
    }

    private void writePredicateObjectList(Collection<Triple> triples) {
        int predicateMaxWidth = RiotLib.calcWidthTriples(this.pMap, this.baseURI, triples, 6, 30);
        boolean first = true;
        for (Triple triple : triples) {
            if (!first) {
                this.out.println(" ;");
            } else {
                first = false;
            }
            Node p = triple.getPredicate();
            this.outputNode(p);
            this.out.pad(predicateMaxWidth);
            this.out.print(' ', 2);
            Node o = triple.getObject();
            this.outputNode(o);
        }
    }

    @Override
    protected void finalizeRun() {
        if (this.lastGraph != null) {
            this.endGraph(null);
        }
    }

    protected boolean dftGraph() {
        return this.lastGraph == Quad.defaultGraphNodeGenerated;
    }

    protected boolean dftGraph(Node g) {
        return g == Quad.defaultGraphNodeGenerated;
    }

    protected void startGraph(Node g) {
        if (this.lastGraph == null) {
            boolean NL_START;
            boolean bl = NL_START = !this.dftGraph(g);
            if (!this.firstGraph) {
                this.out.println();
            }
            this.firstGraph = false;
            this.lastSubject = null;
            if (!this.dftGraph(g)) {
                this.outputNode(g);
                this.out.print(" ");
            }
            if (NL_START) {
                this.out.println("{");
            } else {
                this.out.print("{ ");
            }
            if (this.dftGraph()) {
                this.setGraphIndent(2);
            } else {
                int x = NL_START ? 4 : this.out.getCol();
                this.setGraphIndent(x);
            }
            this.out.incIndent(this.graphIndent());
        }
        this.lastGraph = g;
    }

    protected void endGraph(Node g) {
        if (this.lastGraph == null) {
            return;
        }
        if (!Objects.equals(this.lastGraph, g)) {
            boolean NL_END;
            boolean bl = NL_END = this.dftGraph(g) ? true : true;
            if (this.lastSubject != null) {
                this.out.print(" .");
            }
            if (NL_END) {
                this.out.decIndent(this.graphIndent());
                this.out.println();
                this.out.println("}");
            } else {
                this.out.decIndent(this.graphIndent());
                if (this.out.atLineStart()) {
                    this.out.println("}");
                } else {
                    this.out.println(" }");
                }
            }
            this.lastSubject = null;
            this.lastGraph = null;
        }
    }

    protected void setGraphIndent(int x) {
        this.currentGraphIndent = x;
    }

    protected int graphIndent() {
        return this.currentGraphIndent;
    }
}

