/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.LangCSV;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.LangRDFXML;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.sparql.core.Quad;

@Deprecated
public class RiotParsers {
    private RiotParsers() {
    }

    @Deprecated
    public static LangRIOT createParser(InputStream input, Lang lang, String baseIRI, StreamRDF dest) {
        if (lang == RDFLanguages.RDFXML) {
            return RiotParsers.createParserRDFXML(input, baseIRI, dest);
        }
        if (lang == RDFLanguages.CSV) {
            return new LangCSV(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        }
        Tokenizer tokenizer = lang == RDFLanguages.RDFJSON ? new TokenizerJSON(PeekReader.makeUTF8(input)) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotParsers.createParser(tokenizer, lang, baseIRI, dest);
    }

    @Deprecated
    public static LangRIOT createParser(Reader input, Lang lang, String baseIRI, StreamRDF dest) {
        if (lang == RDFLanguages.RDFXML) {
            return RiotParsers.createParserRDFXML(input, baseIRI, dest);
        }
        if (lang == RDFLanguages.CSV) {
            return new LangCSV(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        }
        Tokenizer tokenizer = lang == RDFLanguages.RDFJSON ? new TokenizerJSON(PeekReader.make(input)) : TokenizerFactory.makeTokenizer(input);
        return RiotParsers.createParser(tokenizer, lang, baseIRI, dest);
    }

    @Deprecated
    static LangTurtle createParserTurtle(InputStream input, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotParsers.createParserTurtle(tokenizer, baseIRI, dest);
    }

    @Deprecated
    static LangTurtle createParserTurtle(Tokenizer tokenizer, String baseIRI, StreamRDF dest) {
        ParserProfile profile = RiotLib.profile(RDFLanguages.TURTLE, baseIRI);
        LangTurtle parser = new LangTurtle(tokenizer, profile, dest);
        return parser;
    }

    @Deprecated
    static LangRDFXML createParserRDFXML(InputStream input, String baseIRI, StreamRDF dest) {
        baseIRI = RiotParsers.baseURI_RDFXML(baseIRI);
        LangRDFXML parser = LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        return parser;
    }

    @Deprecated
    static LangRDFXML createParserRDFXML(Reader input, String baseIRI, StreamRDF dest) {
        baseIRI = RiotParsers.baseURI_RDFXML(baseIRI);
        LangRDFXML parser = LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), dest);
        return parser;
    }

    private static String baseURI_RDFXML(String baseIRI) {
        if (baseIRI == null) {
            return SysRIOT.chooseBaseIRI();
        }
        return SysRIOT.chooseBaseIRI(baseIRI);
    }

    @Deprecated
    static LangRDFJSON createParserRdfJson(Tokenizer tokenizer, StreamRDF dest) {
        ParserProfile profile = RiotLib.profile(RDFLanguages.RDFJSON, null);
        LangRDFJSON parser = new LangRDFJSON(tokenizer, profile, dest);
        return parser;
    }

    @Deprecated
    static LangRDFJSON createParserRdfJson(InputStream input, StreamRDF dest) {
        TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8(input));
        return RiotParsers.createParserRdfJson(tokenizer, dest);
    }

    @Deprecated
    static LangTriG createParserTriG(InputStream input, String baseIRI, StreamRDF dest) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotParsers.createParserTriG(tokenizer, baseIRI, dest);
    }

    @Deprecated
    static LangTriG createParserTriG(Tokenizer tokenizer, String baseIRI, StreamRDF dest) {
        ParserProfile profile = RiotLib.profile(RDFLanguages.TRIG, baseIRI);
        LangTriG parser = new LangTriG(tokenizer, profile, dest);
        return parser;
    }

    @Deprecated
    static LangNTriples createParserNTriples(InputStream input, StreamRDF dest) {
        return RiotParsers.createParserNTriples(input, CharSpace.UTF8, dest);
    }

    @Deprecated
    static LangNTriples createParserNTriples(InputStream input, CharSpace charSpace, StreamRDF dest) {
        Tokenizer tokenizer = charSpace == CharSpace.ASCII ? TokenizerFactory.makeTokenizerASCII(input) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotParsers.createParserNTriples(tokenizer, dest);
    }

    @Deprecated
    static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest) {
        ParserProfile profile = RiotLib.profile(RDFLanguages.NTRIPLES, null);
        LangNTriples parser = new LangNTriples(tokenizer, profile, dest);
        return parser;
    }

    @Deprecated
    public static Iterator<Triple> createIteratorNTriples(InputStream input, StreamRDF dest) {
        return RiotParsers.createParserNTriples(input, dest);
    }

    @Deprecated
    static LangNQuads createParserNQuads(InputStream input, StreamRDF dest) {
        return RiotParsers.createParserNQuads(input, CharSpace.UTF8, dest);
    }

    @Deprecated
    public static Iterator<Quad> createIteratorNQuads(InputStream input, StreamRDF dest) {
        return RiotParsers.createParserNQuads(input, dest);
    }

    @Deprecated
    static LangNQuads createParserNQuads(InputStream input, CharSpace charSpace, StreamRDF dest) {
        Tokenizer tokenizer = charSpace == CharSpace.ASCII ? TokenizerFactory.makeTokenizerASCII(input) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotParsers.createParserNQuads(tokenizer, dest);
    }

    @Deprecated
    static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest) {
        ParserProfile profile = RiotLib.profile(RDFLanguages.NQUADS, null);
        LangNQuads parser = new LangNQuads(tokenizer, profile, dest);
        return parser;
    }

    @Deprecated
    static LangRIOT createParser(Tokenizer tokenizer, Lang lang, String baseIRI, StreamRDF dest) {
        if (RDFLanguages.sameLang(RDFLanguages.RDFXML, lang)) {
            throw new RiotException("Not possible - can't parse RDF/XML from a RIOT token stream");
        }
        if (RDFLanguages.sameLang(RDFLanguages.TURTLE, lang) || RDFLanguages.sameLang(RDFLanguages.N3, lang)) {
            return RiotParsers.createParserTurtle(tokenizer, baseIRI, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return RiotParsers.createParserNTriples(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            return RiotParsers.createParserRdfJson(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotParsers.createParserNQuads(tokenizer, dest);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotParsers.createParserTriG(tokenizer, baseIRI, dest);
        }
        return null;
    }
}

