/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.jdbc.results.JenaResultSet;
import org.apache.jena.jdbc.results.metadata.AskResultsMetadata;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AskResults
extends JenaResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AskResults.class);
    private boolean result;
    private boolean closed = false;
    private int currRow = 0;
    private boolean needsCommit = false;
    private AskResultsMetadata metadata;
    private String columnLabel;

    public AskResults(JenaStatement statement, boolean result, boolean commit) throws SQLException {
        super(statement);
        this.result = result;
        this.needsCommit = commit;
        this.metadata = statement.getJenaConnection().applyPostProcessors(new AskResultsMetadata(this));
        this.columnLabel = this.metadata.getColumnLabel(1);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (row == 1) {
            return this.first();
        }
        if (row == -1) {
            return this.last();
        }
        if (row == 0) {
            return true;
        }
        throw new SQLException("Moving the requested number of rows would be outside the allowable range of rows");
    }

    @Override
    public void afterLast() {
        this.currRow = 2;
    }

    @Override
    public void beforeFirst() {
        this.currRow = 0;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.needsCommit) {
            LOGGER.info("Result Set associated with an auto-committing transaction, performing a commit now");
            this.getStatement().getConnection().commit();
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.columnLabel.equals(columnLabel)) {
            return 1;
        }
        throw new SQLException("The given column does not exist in this result set");
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        this.currRow = 1;
        return true;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public int getRow() {
        return this.currRow;
    }

    @Override
    public int getType() {
        return 1004;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 2;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 1;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        this.currRow = 1;
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (this.currRow < 2) {
            ++this.currRow;
        }
        return this.currRow == 1;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (this.currRow == 0 && rows >= 0 && rows <= 2) {
            this.currRow += rows;
            return true;
        }
        if (this.currRow == 1 && rows >= -1 && rows <= 1) {
            this.currRow += rows;
            return true;
        }
        if (this.currRow == 2 && rows >= -2 && rows <= 0) {
            this.currRow += rows;
            return true;
        }
        throw new SQLException("Moving the requested number of rows would be outside the allowable range of rows");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets only support forward fetch");
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("Fetch Size is not relevant for ASK results");
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    protected String findColumnLabel(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.columnLabel;
        }
        throw new SQLException("Column Index is out of bounds");
    }

    @Override
    protected Node getNode(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.currRow != 1) {
            throw new SQLException("Not currently at a row");
        }
        if (this.columnLabel.equals(columnLabel)) {
            return NodeFactory.createLiteral(Boolean.toString(this.result), XSDDatatype.XSDboolean);
        }
        throw new SQLException("The given column does not exist in the result set");
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.currRow != 1) {
            throw new SQLException("Not currently at a row");
        }
        if (this.columnLabel.equals(columnLabel)) {
            this.setNull(false);
            return this.result;
        }
        throw new SQLException("The given column does not exist in the result set");
    }
}

