/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TurtleTripleCallback
implements JsonLdTripleCallback {
    private static final int MAX_LINE_LENGTH = 160;
    private static final int TAB_SPACES = 4;
    private static final String COLS_KEY = "..cols..";
    final Map<String, String> availableNamespaces = new LinkedHashMap<String, String>(){};
    Set<String> usedNamespaces;

    @Override
    public Object call(RDFDataset dataset) {
        for (Map.Entry<String, String> e2 : dataset.getNamespaces().entrySet()) {
            this.availableNamespaces.put(e2.getValue(), e2.getKey());
        }
        this.usedNamespaces = new LinkedHashSet<String>();
        boolean tabs = false;
        LinkedHashMap refs = new LinkedHashMap();
        LinkedHashMap<String, Map<String, List<Object>>> ttl = new LinkedHashMap<String, Map<String, List<Object>>>();
        for (String graphName : dataset.keySet()) {
            Iterator triples = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            String prevSubject = "";
            String prevPredicate = "";
            Map thisSubject = null;
            List<RDFDataset.Node> thisPredicate = null;
            Iterator iterator = triples.iterator();
            while (iterator.hasNext()) {
                RDFDataset.Quad triple = (RDFDataset.Quad)iterator.next();
                String subject = triple.getSubject().getValue();
                String predicate = triple.getPredicate().getValue();
                if (prevSubject.equals(subject)) {
                    if (!prevPredicate.equals(predicate)) {
                        if (thisSubject.containsKey(predicate)) {
                            thisPredicate = (List)thisSubject.get(predicate);
                        } else {
                            thisPredicate = new ArrayList<RDFDataset.Node>();
                            thisSubject.put(predicate, thisPredicate);
                        }
                        prevPredicate = predicate;
                    }
                } else {
                    if (ttl.containsKey(subject)) {
                        thisSubject = (Map)ttl.get(subject);
                    } else {
                        thisSubject = new LinkedHashMap();
                        ttl.put(subject, thisSubject);
                    }
                    if (thisSubject.containsKey(predicate)) {
                        thisPredicate = (List)thisSubject.get(predicate);
                    } else {
                        thisPredicate = new ArrayList();
                        thisSubject.put(predicate, thisPredicate);
                    }
                    prevSubject = subject;
                    prevPredicate = predicate;
                }
                if (triple.getObject().isLiteral()) {
                    thisPredicate.add(triple.getObject());
                    continue;
                }
                String o = triple.getObject().getValue();
                if (o.startsWith("_:")) {
                    if (!refs.containsKey(o)) {
                        refs.put(o, new ArrayList());
                    }
                    ((List)refs.get(o)).add(thisPredicate);
                }
                thisPredicate.add((RDFDataset.Node)((Object)o));
            }
        }
        LinkedHashMap collections = new LinkedHashMap();
        ArrayList subjects = new ArrayList(ttl.keySet());
        block3: for (String subj : subjects) {
            Map preds = (Map)ttl.get(subj);
            if (preds == null || !preds.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")) continue;
            ArrayList col = new ArrayList();
            collections.put(subj, col);
            while (true) {
                String next;
                List first = (List)preds.remove("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
                Object o = first.get(0);
                col.add(o);
                if (refs.containsKey(o)) {
                    ((List)refs.get(o)).remove(first);
                    ((List)refs.get(o)).add(col);
                }
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(next = (String)((List)preds.remove("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")).get(0))) continue block3;
                if (collections.containsKey(next)) {
                    col.addAll((Collection)collections.remove(next));
                    continue block3;
                }
                preds = (Map)ttl.remove(next);
                refs.remove(next);
            }
        }
        for (String id : refs.keySet()) {
            if (((List)refs.get(id)).size() > 1) continue;
            Object object = ttl.remove(id);
            if (collections.containsKey(id)) {
                object = new LinkedHashMap();
                ArrayList tmp = new ArrayList();
                tmp.add(collections.remove(id));
                ((HashMap)object).put(COLS_KEY, tmp);
            }
            List predicate = (List)((List)refs.get(id)).get(0);
            predicate.set(predicate.lastIndexOf(id), object);
        }
        for (String id : collections.keySet()) {
            Map subj = (Map)ttl.get(id);
            if (!subj.containsKey(COLS_KEY)) {
                subj.put(COLS_KEY, new ArrayList());
            }
            ((List)subj.get(COLS_KEY)).add(collections.get(id));
        }
        String output = this.generateTurtle(ttl, 0, 0, false);
        String prefixes = "";
        for (String prefix : this.usedNamespaces) {
            String name = this.availableNamespaces.get(prefix);
            prefixes = prefixes + "@prefix " + name + ": <" + prefix + "> .\n";
        }
        return ("".equals(prefixes) ? "" : prefixes + "\n") + output;
    }

    private String generateObject(Object object, String sep, boolean hasNext, int indentation, int lineLength) {
        String obj;
        String rval = "";
        if (object instanceof String) {
            obj = this.getURI((String)object);
        } else if (object instanceof RDFDataset.Literal) {
            obj = ((RDFDataset.Literal)object).getValue();
            String lang = ((RDFDataset.Literal)object).getLanguage();
            String dt = ((RDFDataset.Literal)object).getDatatype();
            if (lang != null) {
                obj = "\"" + obj + "\"";
                obj = obj + "@" + lang;
            } else if (dt != null) {
                if (!("http://www.w3.org/2001/XMLSchema#double".equals(dt) || "http://www.w3.org/2001/XMLSchema#integer".equals(dt) || "http://www.w3.org/2001/XMLSchema#float".equals(dt) || "http://www.w3.org/2001/XMLSchema#boolean".equals(dt))) {
                    obj = "\"" + obj + "\"";
                    if (!"http://www.w3.org/2001/XMLSchema#string".equals(dt)) {
                        obj = obj + "^^" + this.getURI(dt);
                    }
                }
            } else {
                obj = "\"" + obj + "\"";
            }
        } else {
            LinkedHashMap<String, Map<String, List<Object>>> tmp = new LinkedHashMap<String, Map<String, List<Object>>>();
            tmp.put("_:x", (Map)object);
            obj = this.generateTurtle(tmp, indentation + 1, lineLength, true);
        }
        int idxofcr = obj.indexOf("\n");
        if ((hasNext ? 1 : 0) + lineLength + (idxofcr != -1 ? idxofcr : obj.length()) > 160) {
            rval = rval + "\n" + this.tabs(indentation + 1);
            lineLength = (indentation + 1) * 4;
        }
        rval = rval + obj;
        lineLength = idxofcr != -1 ? (lineLength += obj.length() - obj.lastIndexOf("\n")) : (lineLength += obj.length());
        if (hasNext) {
            rval = rval + sep;
            if ((lineLength += sep.length()) < 160) {
                rval = rval + " ";
                ++lineLength;
            } else {
                rval = rval + "\n";
            }
        }
        return rval;
    }

    private String generateTurtle(Map<String, Map<String, List<Object>>> ttl, int indentation, int lineLength, boolean isObject) {
        String rval = "";
        Iterator<String> subjIter = ttl.keySet().iterator();
        while (subjIter.hasNext()) {
            String subject = subjIter.next();
            Map<String, List<Object>> subjval = ttl.get(subject);
            boolean hasOpenBnodeBracket = false;
            if (subject.startsWith("_:")) {
                if (!subjval.containsKey(COLS_KEY)) {
                    rval = rval + "[ ";
                    lineLength += 2;
                    hasOpenBnodeBracket = true;
                }
                if (subjval.containsKey(COLS_KEY)) {
                    List<Object> collections = subjval.remove(COLS_KEY);
                    for (Object collection : collections) {
                        rval = rval + "( ";
                        lineLength += 2;
                        Iterator objIter = ((List)collection).iterator();
                        while (objIter.hasNext()) {
                            Object object = objIter.next();
                            rval = rval + this.generateObject(object, "", objIter.hasNext(), indentation, lineLength);
                            lineLength = rval.length() - rval.lastIndexOf("\n");
                        }
                        rval = rval + " ) ";
                        lineLength += 3;
                    }
                }
            } else {
                rval = rval + this.getURI(subject) + " ";
                lineLength += subject.length() + 1;
            }
            Iterator<String> predIter = ttl.get(subject).keySet().iterator();
            while (predIter.hasNext()) {
                String predicate = predIter.next();
                rval = rval + this.getURI(predicate) + " ";
                lineLength += predicate.length() + 1;
                Iterator<Object> objIter = ttl.get(subject).get(predicate).iterator();
                while (objIter.hasNext()) {
                    Object object = objIter.next();
                    rval = rval + this.generateObject(object, ",", objIter.hasNext(), indentation, lineLength);
                    lineLength = rval.length() - rval.lastIndexOf("\n");
                }
                if (!predIter.hasNext()) continue;
                rval = rval + " ;\n" + this.tabs(indentation + 1);
                lineLength = (indentation + 1) * 4;
            }
            if (hasOpenBnodeBracket) {
                rval = rval + " ]";
            }
            if (isObject) continue;
            rval = rval + " .\n";
            if (!subjIter.hasNext()) continue;
            rval = rval + "\n";
        }
        return rval;
    }

    private String tabs(int tabs) {
        String rval = "";
        for (int i = 0; i < tabs; ++i) {
            rval = rval + "    ";
        }
        return rval;
    }

    private String getURI(String uri) {
        if (uri.startsWith("_:")) {
            return uri;
        }
        for (String prefix : this.availableNamespaces.keySet()) {
            if (!uri.startsWith(prefix)) continue;
            this.usedNamespaces.add(prefix);
            return this.availableNamespaces.get(prefix) + ":" + uri.substring(prefix.length());
        }
        return "<" + uri + ">";
    }
}

